/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.metrology.AerotechDevice;
import org.lsst.ccs.subsystem.metrology.KeyenceDevice;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;
import org.lsst.ccs.subsystem.metrology.status.MetrologyStateStatus;

public class MetrologySubSys
extends Subsystem
implements HasLifecycle,
Monitor.AlarmHandler,
StatusMessageListener {
    List<Device> devcList = new ArrayList<Device>();
    String stateCorrelId;
    MetrologyConfig metrologyc = new MetrologyConfig();
    private ConcurrentMessagingUtils cmu;
    private static final org.lsst.ccs.utilities.logging.Logger LOGGER = org.lsst.ccs.utilities.logging.Logger.getLogger((String)"org.lsst.ccs.subsystem.metrology.main");
    private static final String METROLOGY_DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
    private String teststand_dest = "ts2";
    private final String ts8_dest = System.getProperty("lsst.ccs.subsystem.ts8", "ts8");
    public static final String BROADCAST_TASK = "publish-data";
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService agentConfigurationService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupName
    private String name;
    private long broadcastMillis = 10000L;
    @ConfigurationParameter
    private boolean monitorCCDTemp = true;
    int state = 0;
    boolean last_systemOK = true;
    int nwarn = 0;
    double last_vac = 0.0;
    int disp_mode = 0;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AerotechDevice aeroDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    KeyenceDevice keyDevc;
    List<Double> plot_posx = new ArrayList<Double>();
    List<Double> plot_posy = new ArrayList<Double>();
    List<Double> plot_posz = new ArrayList<Double>();
    List<Double> move_posx = new ArrayList<Double>();
    List<Double> move_posy = new ArrayList<Double>();
    private boolean abort_action = false;
    private double last_temp_a = -999.0;
    private double last_temp_b = -999.0;
    private double last_temp_c = -999.0;
    private double last_temp_d = -999.0;
    private boolean got_reb_temps = false;
    private double last_vqmpressure = -999.0;
    ConfigurationInfo configInfo = null;

    public MetrologySubSys() {
        super("metrology", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scan() throws DriverException, InterruptedException {
        this.scanfl("/home/ts5prod/Metrology_Scan_Data.csv");
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region to the specified file")
    public void scanfl(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename) throws DriverException, InterruptedException {
        this.configInfo = this.agentConfigurationService.getConfigurationInfo();
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.scan(filename, Double.parseDouble((String)configForComponent.get("startx")), Double.parseDouble((String)configForComponent.get("stopx")), Double.parseDouble((String)configForComponent.get("dx")), Double.parseDouble((String)configForComponent.get("starty")), Double.parseDouble((String)configForComponent.get("stopy")), Double.parseDouble((String)configForComponent.get("dy")), Double.parseDouble((String)configForComponent.get("z")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="startx", description="x start position") double startx, @Argument(name="stopx", description="x stop position") double stopx, @Argument(name="dx", description="x step size") double dx, @Argument(name="starty", description="y start position") double starty, @Argument(name="stopy", description="y stop position") double stopy, @Argument(name="dy", description="y step size") double dy, @Argument(name="z", description="z position") double z) throws DriverException, InterruptedException {
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.scan(filename, startx, stopx, dx, starty, stopy, dy, z, Double.parseDouble((String)configForComponent.get("speed")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="startx", description="x start position") double startx, @Argument(name="stopx", description="x stop position") double stopx, @Argument(name="dx", description="x step size") double dx, @Argument(name="starty", description="y start position") double starty, @Argument(name="stopy", description="y stop position") double stopy, @Argument(name="dy", description="y step size") double dy, @Argument(name="z", description="z position") double z, @Argument(name="speed", description="speed") double speed) throws DriverException, InterruptedException {
        LOGGER.info((Object)("Scan requested with parameters:\n x: " + startx + "mm ->" + stopx + "mm  in steps of " + dx + "mm \n y: " + starty + "mm ->" + stopy + "mm  in steps of " + dy + "mm \n output to: " + filename));
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.SCANNING.ordinal());
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.aeroDevc.moveAbsZ(z);
        double accel = Double.parseDouble((String)configForComponent.get("acceleration"));
        int nsamps = Integer.decode((String)configForComponent.get("nsamples"));
        int measmode = Integer.decode((String)configForComponent.get("measmode"));
        LOGGER.debug((Object)("Setting the acceleration to " + accel));
        this.aeroDevc.rampRate(accel);
        LOGGER.debug((Object)("Setting the speed to " + speed));
        this.aeroDevc.setSpeed(speed);
        this.keyDevc.commmode();
        LOGGER.debug((Object)("Setting cycle mode to " + nsamps));
        this.keyDevc.setcycles(nsamps);
        LOGGER.debug((Object)("Setting surface measurement mode to " + measmode));
        this.keyDevc.setmeasmode(1, measmode);
        this.keyDevc.setmeasmode(2, measmode);
        this.keyDevc.genmode();
        this.plot_posx.clear();
        this.plot_posy.clear();
        this.plot_posz.clear();
        this.move_posx.clear();
        this.move_posy.clear();
        if (!filename.isEmpty()) {
            FileWriter fstream = null;
            BufferedWriter out = null;
            File pdFl = new File(filename);
            try {
                if (pdFl.exists()) {
                    LOGGER.error((Object)"File already exists!!! ABORTING!");
                    return;
                }
                pdFl.createNewFile();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to create file (" + filename + ") for reason " + e));
            }
            try {
                fstream = new FileWriter(pdFl);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
            }
            try {
                if (fstream != null) {
                    out = new BufferedWriter(fstream);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to open buffered writer stream for file (" + filename + ") for reason " + e));
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# filename: " + filename + "\n# start time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n#  x: " + startx + "mm ->" + stopx + "mm  in steps of " + dx + "mm \n#  y: " + starty + "mm ->" + stopy + "mm  in steps of " + dy + "mm \n#  z: " + z + "mm \n#  speed: " + speed + "\n#  acceleration: " + accel + "\n#  cycle mode: " + nsamps + "\n#  measurement mode: " + measmode + "\n#  displacement summing mode: " + MetrologyConfig.Displacement_Summing_Modes.values()[this.disp_mode] + "\n# #######################################################################\n");
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
            }
            int i = 0;
            double y = starty;
            for (double x = startx; x <= stopx; x += dx) {
                while (y >= starty && y <= stopy && !this.abort_action) {
                    this.aeroDevc.moveAbsXY(x, y);
                    this.sleep(0.2);
                    double[] disps = this.keyDevc.readAll();
                    double displacement = -999.0;
                    if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.NormalDispSum.ordinal()) {
                        if (disps[0] > -900.0 && disps[1] > -900.0) {
                            displacement = disps[1] + disps[0];
                        }
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead1Only.ordinal()) {
                        displacement = disps[0];
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead2Only.ordinal()) {
                        displacement = disps[1];
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementDiff.ordinal()) {
                        if (disps[0] > -900.0 && disps[1] > -900.0) {
                            displacement = disps[1] - disps[0];
                        }
                    } else {
                        LOGGER.error((Object)"BAD disp_mode!");
                    }
                    double xmeas = Double.NaN;
                    double ymeas = Double.NaN;
                    double zmeas = Double.NaN;
                    while (Double.isNaN(xmeas) || Double.isNaN(ymeas) || Double.isNaN(zmeas)) {
                        double[] p = this.aeroDevc.getPosXYZ();
                        xmeas = p[0];
                        ymeas = p[1];
                        zmeas = p[2];
                    }
                    this.sleep(0.2);
                    System.out.println("x= " + x + " y= " + y + " displacement= " + displacement + " xmeas= " + xmeas + " ymeas= " + ymeas + " disp1= " + disps[0] + " disp2= " + disps[1] + " z= " + z + " zmeas= " + zmeas + " temp_a= " + this.last_temp_a + " temp_b= " + this.last_temp_b + " temp_c= " + this.last_temp_c + " temp_d= " + this.last_temp_d + " vqmpressure= " + this.last_vqmpressure + " tstamp= " + Long.toString(System.currentTimeMillis()));
                    if (displacement > -900.0) {
                        this.plot_posx.add(xmeas);
                        this.plot_posy.add(ymeas);
                        this.plot_posz.add(displacement);
                        if (out != null) {
                            String line = x + "," + y + "," + displacement + "," + xmeas + "," + ymeas + "," + disps[0] + "," + disps[1] + "," + z + "," + zmeas + "," + this.last_temp_a + "," + this.last_temp_b + "," + this.last_temp_c + "," + this.last_temp_d + "," + this.last_vqmpressure + "," + Long.toString(System.currentTimeMillis());
                            try {
                                out.write(line);
                                out.newLine();
                                out.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++i;
                    y += dy;
                }
                dy = -dy;
                y += dy;
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# end time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n");
                    out.close();
                    if (System.getenv("HOSTNAME").contains("ts5.inst.bnl")) {
                        Runtime r = Runtime.getRuntime();
                        try {
                            LOGGER.warning((Object)"Copying scan data to BNL astro GPFS");
                            Process p1 = r.exec("scp -rp " + filename + " ccdtest@astroracf:/gpfs01/astro/workarea/ccdtest/ts5/DATA/");
                            LOGGER.warning((Object)("The scan has been copied to: /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]));
                            Process process = r.exec("ssh ccdtest@astroracf ls -l /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]);
                        }
                        catch (IOException ex) {
                            LOGGER.error((Object)("Scan copy failed with error " + ex));
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to close file!");
                }
            }
        }
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
        this.abort_action = false;
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scanPL(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename) throws DriverException, InterruptedException {
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.scanPL(filename, Double.parseDouble((String)configForComponent.get("speed")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scanPL(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="speed", description="speed") double speed) throws DriverException, InterruptedException {
        LOGGER.info((Object)("Point List Scan requested with parameters:\n output to: " + filename));
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.SCANNING.ordinal());
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        double accel = Double.parseDouble((String)configForComponent.get("acceleration"));
        int nsamps = Integer.decode((String)configForComponent.get("nsamples"));
        int measmode = Integer.decode((String)configForComponent.get("measmode"));
        LOGGER.debug((Object)("Setting the acceleration to " + accel));
        this.aeroDevc.rampRate(accel);
        LOGGER.debug((Object)("Setting the speed to " + speed));
        this.aeroDevc.setSpeed(speed);
        double z = this.aeroDevc.getLastPosZ();
        this.keyDevc.commmode();
        LOGGER.debug((Object)("Setting cycle mode to " + nsamps));
        this.keyDevc.setcycles(nsamps);
        LOGGER.debug((Object)("Setting surface measurement mode to " + measmode));
        this.keyDevc.setmeasmode(1, measmode);
        this.keyDevc.setmeasmode(2, measmode);
        this.keyDevc.genmode();
        this.plot_posx.clear();
        this.plot_posy.clear();
        this.plot_posz.clear();
        this.move_posx.clear();
        this.move_posy.clear();
        if (!filename.isEmpty()) {
            FileWriter fstream = null;
            BufferedWriter out = null;
            File pdFl = new File(filename);
            try {
                if (pdFl.exists()) {
                    LOGGER.error((Object)"File already exists!!! ABORTING!");
                    return;
                }
                pdFl.createNewFile();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to create file (" + filename + ") for reason " + e));
            }
            try {
                fstream = new FileWriter(pdFl);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
            }
            try {
                if (fstream != null) {
                    out = new BufferedWriter(fstream);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to open buffered writer stream for file (" + filename + ") for reason " + e));
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# filename: " + filename + "\n# start time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n#  speed: " + speed + "\n#  acceleration: " + accel + "\n#  cycle mode: " + nsamps + "\n#  measurement mode: " + measmode + "\n#  displacement summing mode: " + MetrologyConfig.Displacement_Summing_Modes.values()[this.disp_mode] + "\n# #######################################################################\n");
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
            }
            int i = 0;
            for (MetrologyConfig.pointset_states componentState : MetrologyConfig.pointset_states.values()) {
                String componentName = componentState.name();
                Map PSconfigForComponent = this.configInfo.getCurrentValuesFor(componentName);
                double PointX = Double.parseDouble((String)PSconfigForComponent.get("PointX"));
                double PointY = Double.parseDouble((String)PSconfigForComponent.get("PointY"));
                double PointZ = Double.parseDouble((String)PSconfigForComponent.get("PointZ"));
                if (this.abort_action) break;
                if (PointX < -900.0 || PointY < -900.0 || PointZ < -900.0) continue;
                this.aeroDevc.moveAbsXYZ(PointX, PointY, PointZ);
                this.sleep(0.2);
                double[] disps = this.keyDevc.readAll();
                double displacement = -999.0;
                if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.NormalDispSum.ordinal()) {
                    if (disps[0] > -900.0 && disps[1] > -900.0) {
                        displacement = disps[1] + disps[0];
                    }
                } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead1Only.ordinal()) {
                    displacement = disps[0];
                } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead2Only.ordinal()) {
                    displacement = disps[1];
                } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementDiff.ordinal()) {
                    if (disps[0] > -900.0 && disps[1] > -900.0) {
                        displacement = disps[1] - disps[0];
                    }
                } else {
                    LOGGER.error((Object)"BAD disp_mode!");
                }
                double xmeas = Double.NaN;
                double ymeas = Double.NaN;
                double zmeas = Double.NaN;
                while (Double.isNaN(xmeas) || Double.isNaN(ymeas) || Double.isNaN(zmeas)) {
                    double[] p = this.aeroDevc.getPosXYZ();
                    xmeas = p[0];
                    ymeas = p[1];
                    zmeas = p[2];
                }
                this.sleep(0.2);
                System.out.println("x= " + PointX + " y= " + PointY + " displacement= " + displacement + " xmeas= " + xmeas + " ymeas= " + ymeas + " disp1= " + disps[0] + " disp2= " + disps[1] + " z= " + PointZ + " zmeas= " + zmeas + " temp_a= " + this.last_temp_a + " temp_b= " + this.last_temp_b + " temp_c= " + this.last_temp_c + " temp_d= " + this.last_temp_d + " vqmpressure= " + this.last_vqmpressure + " tstamp= " + Long.toString(System.currentTimeMillis()));
                if (displacement > -900.0) {
                    this.plot_posx.add(xmeas);
                    this.plot_posy.add(ymeas);
                    this.plot_posz.add(displacement);
                    if (out != null) {
                        String line = PointX + "," + PointY + "," + displacement + "," + xmeas + "," + ymeas + "," + disps[0] + "," + disps[1] + "," + PointZ + "," + zmeas + "," + this.last_temp_a + "," + this.last_temp_b + "," + this.last_temp_c + "," + this.last_temp_d + "," + this.last_vqmpressure + "," + Long.toString(System.currentTimeMillis());
                        try {
                            out.write(line);
                            out.newLine();
                            out.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# end time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n");
                    out.close();
                    if (System.getenv("HOSTNAME").contains("ts5.inst.bnl")) {
                        Runtime r = Runtime.getRuntime();
                        try {
                            LOGGER.warning((Object)"Copying scan data to BNL astro GPFS");
                            Process p1 = r.exec("scp -rp " + filename + " ccdtest@astroracf:/gpfs01/astro/workarea/ccdtest/ts5/DATA/");
                            LOGGER.warning((Object)("The scan has been copied to: /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]));
                            Process process = r.exec("ssh ccdtest@astroracf ls -l /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]);
                        }
                        catch (IOException ex) {
                            LOGGER.error((Object)("Scan copy failed with error " + ex));
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to close file!");
                }
            }
        }
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
        this.abort_action = false;
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void noStepScan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename) throws DriverException, InterruptedException {
        this.configInfo = this.agentConfigurationService.getConfigurationInfo();
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.noStepScan(filename, Double.parseDouble((String)configForComponent.get("startx")), Double.parseDouble((String)configForComponent.get("stopx")), Double.parseDouble((String)configForComponent.get("dx")), Double.parseDouble((String)configForComponent.get("starty")), Double.parseDouble((String)configForComponent.get("stopy")), Double.parseDouble((String)configForComponent.get("dy")), Double.parseDouble((String)configForComponent.get("z")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void noStepScan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="startx", description="x start position") double startx, @Argument(name="stopx", description="x stop position") double stopx, @Argument(name="dx", description="x step size") double dx, @Argument(name="starty", description="y start position") double starty, @Argument(name="stopy", description="y stop position") double stopy, @Argument(name="dy", description="y step size") double dy, @Argument(name="z", description="z position") double z) throws DriverException, InterruptedException {
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.noStepScan(filename, startx, stopx, dx, starty, stopy, dy, z, Double.parseDouble((String)configForComponent.get("speed")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void noStepScan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="startx", description="x start position") double startx, @Argument(name="stopx", description="x stop position") double stopx, @Argument(name="dx", description="x step size") double dx, @Argument(name="starty", description="y start position") double starty, @Argument(name="stopy", description="y stop position") double stopy, @Argument(name="dy", description="y step size") double dy, @Argument(name="z", description="z position") double z, @Argument(name="speed", description="speed") double speed) throws DriverException, InterruptedException {
        LOGGER.info((Object)("Scan requested with parameters:\n x: " + startx + "mm -> " + stopx + "mm  in steps of " + dx + "mm \n y: " + starty + "mm -> " + stopy + "mm  in steps of " + dy + "mm \n output to: " + filename));
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.SCANNING.ordinal());
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.aeroDevc.moveAbsZ(z);
        double accel = Double.parseDouble((String)configForComponent.get("acceleration"));
        int nsamps = Integer.decode((String)configForComponent.get("nsamples"));
        int measmode = Integer.decode((String)configForComponent.get("measmode"));
        LOGGER.debug((Object)("Setting the acceleration to " + accel));
        this.aeroDevc.rampRate(accel);
        LOGGER.debug((Object)("Setting the speed to " + speed));
        this.aeroDevc.setSpeed(speed);
        this.keyDevc.commmode();
        LOGGER.debug((Object)("Setting cycle mode to " + nsamps));
        this.keyDevc.setcycles(nsamps);
        LOGGER.debug((Object)("Setting surface measurement mode to " + measmode));
        this.keyDevc.setmeasmode(1, measmode);
        this.keyDevc.setmeasmode(2, measmode);
        this.keyDevc.genmode();
        this.plot_posx.clear();
        this.plot_posy.clear();
        this.plot_posz.clear();
        this.move_posx.clear();
        this.move_posy.clear();
        if (!filename.isEmpty()) {
            FileWriter fstream = null;
            BufferedWriter out = null;
            File pdFl = new File(filename);
            try {
                if (pdFl.exists()) {
                    pdFl.delete();
                }
                pdFl.createNewFile();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to create file (" + filename + ") for reason " + e));
            }
            try {
                fstream = new FileWriter(pdFl);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
            }
            try {
                if (fstream != null) {
                    out = new BufferedWriter(fstream);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to open buffered writer stream for file (" + filename + ") for reason " + e));
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# filename: " + filename + "\n# start time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n#  x: " + startx + "mm ->" + stopx + "mm  in steps of " + dx + "mm \n#  y: " + starty + "mm ->" + stopy + "mm  in steps of " + dy + "mm \n#  z: " + z + "mm \n#  speed: " + speed + "\n#  acceleration: " + accel + "\n#  cycle mode: " + nsamps + "\n#  measurement mode: " + measmode + "\n#  displacement summing mode: " + MetrologyConfig.Displacement_Summing_Modes.values()[this.disp_mode] + "\n# #######################################################################\n");
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
            }
            if (!this.abort_action) {
                this.aeroDevc.moveAbsXY(startx, starty);
            }
            double preScanStartTime_fwd = System.currentTimeMillis();
            this.aeroDevc.moveAbsXY(startx, stopy);
            double preScanStopTime_fwd = System.currentTimeMillis();
            if (!this.abort_action) {
                this.aeroDevc.moveAbsXY(stopx, stopy);
            }
            double preScanStartTime_bwd = System.currentTimeMillis();
            if (!this.abort_action) {
                this.aeroDevc.moveAbsXY(stopx, starty);
            }
            double preScanStopTime_bwd = System.currentTimeMillis();
            if (!this.abort_action) {
                this.aeroDevc.moveAbsXY(startx, starty);
            }
            final double tm_starty = starty;
            final double tm_stopy = stopy;
            if (this.abort_action) {
                return;
            }
            int i = 0;
            for (double x = startx; x <= stopx; x += dx) {
                String msg;
                double y = starty;
                final double tm_x = x;
                final double tm_dy = dy;
                if (tm_dy > 0.0) {
                    msg = "move to scan line start point x,y = " + tm_x + " ," + tm_starty;
                    LOGGER.debug((Object)msg);
                    if (!this.abort_action) {
                        this.aeroDevc.moveAbsXY(tm_x, tm_starty);
                        this.move_posx.add(tm_x);
                        this.move_posy.add(tm_starty);
                    }
                } else {
                    msg = "move to scan line start point x,y = " + tm_x + " ," + tm_stopy;
                    LOGGER.debug((Object)msg);
                    if (!this.abort_action) {
                        this.aeroDevc.moveAbsXY(tm_x, tm_stopy);
                        this.move_posx.add(tm_x);
                        this.move_posy.add(tm_stopy);
                    }
                }
                double xmeas = Double.NaN;
                double ymeas = Double.NaN;
                double zmeas = Double.NaN;
                while (Double.isNaN(xmeas) || Double.isNaN(ymeas) || Double.isNaN(zmeas)) {
                    double[] p = this.aeroDevc.getPosXYZ();
                    xmeas = p[0];
                    ymeas = p[1];
                    zmeas = p[2];
                }
                this.sleep(0.2);
                long runStartTime = System.currentTimeMillis();
                Runnable tmove = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (tm_dy > 0.0) {
                                String msg = "thread move started to x,y" + tm_x + " ," + tm_stopy;
                                LOGGER.debug((Object)msg);
                                MetrologySubSys.this.move_posx.add(tm_x);
                                MetrologySubSys.this.move_posy.add(tm_stopy);
                                MetrologySubSys.this.aeroDevc.moveAbsXY(tm_x, tm_stopy);
                            } else {
                                String msg = "thread move started to x,y" + tm_x + " ," + tm_starty;
                                LOGGER.debug((Object)msg);
                                MetrologySubSys.this.move_posx.add(tm_x);
                                MetrologySubSys.this.move_posy.add(tm_starty);
                                MetrologySubSys.this.aeroDevc.moveAbsXY(tm_x, tm_starty);
                            }
                            LOGGER.debug((Object)"move thread terminated");
                        }
                        catch (DriverException e) {
                            LOGGER.error((Object)"driver exception in tmove queue", (Throwable)e);
                        }
                    }
                };
                Thread motion = new Thread(tmove);
                if (!this.abort_action) {
                    motion.start();
                }
                while (y >= starty && y <= stopy) {
                    long timeMark = dy > 0.0 ? (long)((y - starty) / (stopy - starty) * (preScanStopTime_fwd - preScanStartTime_fwd) + (double)runStartTime) : (long)((y - stopy) / (starty - stopy) * (preScanStopTime_bwd - preScanStartTime_bwd) + (double)runStartTime);
                    if (this.abort_action) {
                        motion.interrupt();
                        break;
                    }
                    while (System.currentTimeMillis() < timeMark) {
                    }
                    long time_before_key = System.currentTimeMillis();
                    double[] disps = this.keyDevc.readAll();
                    long time_after_key = System.currentTimeMillis();
                    double displacement = -999.0;
                    if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.NormalDispSum.ordinal()) {
                        if (disps[0] > -900.0 && disps[1] > -900.0) {
                            displacement = disps[1] + disps[0];
                        }
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead1Only.ordinal()) {
                        displacement = disps[0];
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead2Only.ordinal()) {
                        displacement = disps[1];
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementDiff.ordinal()) {
                        if (disps[0] > -900.0 && disps[1] > -900.0) {
                            displacement = disps[1] - disps[0];
                        }
                    } else {
                        LOGGER.error((Object)"BAD disp_mode!");
                    }
                    double actual_time = time_before_key;
                    ymeas = dy > 0.0 ? (actual_time - (double)runStartTime) / (preScanStopTime_fwd - preScanStartTime_fwd) * (stopy - starty) + starty : (actual_time - (double)runStartTime) / (preScanStopTime_bwd - preScanStartTime_bwd) * (starty - stopy) + stopy;
                    System.out.println("x= " + x + " y= " + y + " displacement= " + displacement + " xmeas= " + xmeas + " ymeas= " + ymeas + " disp1= " + disps[0] + " disp2= " + disps[1] + " z= " + z + " zmeas= " + zmeas + " temp_a= " + this.last_temp_a + " temp_b= " + this.last_temp_b + " temp_c= " + this.last_temp_c + " temp_d= " + this.last_temp_d + " vqmpressure= " + this.last_vqmpressure + " tstamp= " + Long.toString((long)actual_time));
                    if (displacement > -900.0) {
                        this.plot_posx.add(xmeas);
                        this.plot_posy.add(ymeas);
                        this.plot_posz.add(displacement);
                        if (out != null) {
                            String line = x + "," + y + "," + displacement + "," + xmeas + "," + ymeas + "," + disps[0] + "," + disps[1] + "," + z + "," + zmeas + "," + this.last_temp_a + "," + this.last_temp_b + "," + this.last_temp_c + "," + this.last_temp_d + "," + this.last_vqmpressure + "," + Long.toString((long)actual_time);
                            try {
                                out.write(line);
                                out.newLine();
                                out.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++i;
                    y += dy;
                }
                motion.join();
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# end time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n");
                    out.close();
                    if (System.getenv("HOSTNAME").contains("ts5.inst.bnl")) {
                        Runtime r = Runtime.getRuntime();
                        try {
                            LOGGER.warning((Object)"Copying scan data to BNL astro GPFS");
                            Process p1 = r.exec("scp -rp " + filename + " ccdtest@astroracf:/gpfs01/astro/workarea/ccdtest/ts5/DATA/");
                            LOGGER.warning((Object)("The scan has been copied to: /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]));
                            Process process = r.exec("ssh ccdtest@astroracf ls -l /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]);
                        }
                        catch (IOException ex) {
                            LOGGER.error((Object)("Scan copy failed with error " + ex));
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to close file!");
                }
            }
        }
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
        this.abort_action = false;
    }

    @Command(type=Command.CommandType.QUERY, description="do repeated measurements at the same positions")
    public void doreps(@Argument(name="filename", description="filename for storing measurement ") String filename, @Argument(name="nreps", description="number of repetitions") int nreps, @Argument(name="period", description="period in seconds") double period) throws DriverException {
        LOGGER.info((Object)("Reps requested with parameters:\n nreps: " + nreps + "\n period:" + period + "\n output to: " + filename));
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.SCANNING.ordinal());
        if (!filename.isEmpty()) {
            FileWriter fstream = null;
            BufferedWriter out = null;
            File pdFl = new File(filename);
            try {
                if (pdFl.exists()) {
                    pdFl.delete();
                }
                pdFl.createNewFile();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to create file (" + filename + ") for reason " + e));
            }
            try {
                fstream = new FileWriter(pdFl);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
            }
            try {
                if (fstream != null) {
                    out = new BufferedWriter(fstream);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to open buffered writer stream for file (" + filename + ") for reason " + e));
            }
            for (int i = 0; i < nreps && !this.abort_action; ++i) {
                double[] disps = this.keyDevc.readAll();
                double displacement = disps[1] + disps[0];
                double[] p = this.aeroDevc.getPosXYZ();
                this.sleep(period);
                if (out == null) continue;
                String line = i + "," + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "," + p[0] + "," + p[1] + "," + p[2] + "," + disps[0] + "," + disps[1] + "," + displacement;
                try {
                    out.write(line);
                    out.newLine();
                    out.flush();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to close file!");
                }
            }
        }
        this.abort_action = false;
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
    }

    @Command(description="abort motion")
    public void abortMotion() throws DriverException {
        LOGGER.error((Object)"SETTING ABORT ACTION TRUE!");
        this.abort_action = true;
        LOGGER.error((Object)"SENDING ABORT COMMAND TO AEROTECH!");
        this.aeroDevc.abort();
        LOGGER.error((Object)"DISABLING AXES!");
        this.aeroDevc.disableAxes();
        LOGGER.error((Object)"ABORTING ANY ACTIVE SCRIPT!");
        this.sendSyncMetrologyCommand("abortInterpreter", "ts");
    }

    protected Object sendSyncMetrologyCommand(String name, Object ... params) {
        try {
            return this.cmu.sendSynchronousCommand(new CommandRequest(METROLOGY_DEST, name), Duration.ofMillis(30000L));
        }
        catch (Exception e) {
            LOGGER.warning((Object)("Unable to perform jgroup communication with destination + " + METROLOGY_DEST + " - Exception " + e));
            return null;
        }
    }

    public void build() {
        Runnable myRunnable = new Runnable(){

            @Override
            public void run() {
                MetrologySubSys.this.periodicBroadcast();
            }
        };
        AgentPeriodicTask periodicTask = new AgentPeriodicTask(BROADCAST_TASK, myRunnable).withPeriod(Duration.ofMillis(this.broadcastMillis));
        this.periodicTaskService.scheduleAgentPeriodicTask(periodicTask);
    }

    public void postInit() {
        this.agentPropertiesService.setAgentProperty("metrologyType", MetrologySubSys.class.getCanonicalName());
        LOGGER.info((Object)"DPSF and Cloud Factory started.");
        this.teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        this.state |= 2;
    }

    public void postStart() {
        this.cmu = new ConcurrentMessagingUtils(this.subsys.getMessagingAccess());
        try {
            LOGGER.info((Object)"Enabling Aerotech axes");
            this.aeroDevc.enableAxes();
        }
        catch (DriverException ex) {
            Logger.getLogger(MetrologySubSys.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.keyDevc.commmode();
            this.keyDevc.setmindispunit(2);
            this.keyDevc.genmode();
        }
        catch (DriverException ex) {
            Logger.getLogger(MetrologySubSys.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void start() {
        try {
            this.startSubSys();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error starting Aerotech subsystem: " + e));
        }
        try {
            this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
        }
        catch (Exception ee) {
            LOGGER.error((Object)"Exception while setting state flags:", (Throwable)ee);
        }
        Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.teststand_dest).or(BusMessageFilterFactory.messageOrigin((String)this.ts8_dest)).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, filter);
    }

    protected void periodicBroadcast() {
        if ((this.state & 0x10) != 0) {
            System.exit(0);
        }
        this.publishState();
    }

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        String alarm_ev = null;
        switch (event) {
            case 0: {
                alarm_ev = "TRIP";
                break;
            }
            case 3: {
                alarm_ev = "RESET";
                break;
            }
            default: {
                alarm_ev = "Unknown";
            }
        }
        LOGGER.error((Object)("Received alarm for " + alarm_ev + " event, where trip=" + 0 + " and reset=" + 3));
        LOGGER.error((Object)("Alarm is from " + MetrologyConfig.EVENT_ID.values()[parm]));
        return false;
    }

    @Command(name="soundAlarm")
    public void soundAlarm() {
        Runtime r = Runtime.getRuntime();
        try {
            LOGGER.error((Object)("Sending warning sound as requested by " + this.name));
            Process process = r.exec("./make-warning-sound");
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to exec shell command to send warning sound " + ex));
        }
    }

    @Command(name="soundBleep")
    public void soundBleep() {
        Runtime r = Runtime.getRuntime();
        try {
            LOGGER.severe((Object)("Sending bleep sound as requested by " + this.name));
            Process process = r.exec("./make-bleep-sound");
        }
        catch (IOException ex) {
            LOGGER.severe((Object)("Failed to exec shell command to send bleep sound " + ex));
        }
    }

    @Command(name="resetTrip", description="reset trips etc...")
    public void resetTrip() {
    }

    @Command(type=Command.CommandType.ACTION, description="Start the metrology subsystem")
    public void startSubSys() throws Exception {
        this.state |= 1;
        LOGGER.info((Object)"Starting Metrology SubSystem.");
        Object param = null;
        this.configInfo = this.agentConfigurationService.getConfigurationInfo();
        this.state |= 0x400;
        this.publishState();
    }

    @Command(name="stopsubsys", type=Command.CommandType.ACTION, description="Stop and set the Aerotech sub system into the ready state")
    public void stopSubSys() {
        LOGGER.info((Object)"Stop Sub System called.");
        this.state &= 0xFFFFFFFD;
        this.publishState();
        this.state |= 0x20;
        this.publishState();
    }

    @Command(name="saveconfig", type=Command.CommandType.ACTION, description="Saves the current configuration")
    public void saveConfiguration() throws IOException {
        try {
            this.agentConfigurationService.saveChanges();
        }
        catch (ConfigurationServiceException ex) {
            LOGGER.warning((Object)("Failed to save all changes " + (Object)((Object)ex)));
        }
        LOGGER.info((Object)"Saved configuration.");
    }

    @Command(name="printfullstate", type=Command.CommandType.QUERY, description="Prints the full aerotech state")
    public String printFullState() {
        MetrologyState aerotechState = new MetrologyState(this.state, this.metrologyc.getCfgstate(), (int)this.periodicTaskService.getPeriodicTaskPeriod(BROADCAST_TASK).toMillis());
        MetrologyStateStatus aerotechs = new MetrologyStateStatus(aerotechState);
        return aerotechs.toString();
    }

    @Command(name="getstate", type=Command.CommandType.QUERY, description="Returns the current value of the TS state")
    public int getState() {
        return this.state;
    }

    @Command(description="Sets the configuration state.")
    public void setCfgState(int cstate) {
        LOGGER.info((Object)("Setting subsystem configuration state to " + MetrologyConfig.configuration_states.values()[cstate]));
        this.metrologyc.setCfgState(cstate);
    }

    @Command(description="Sets the configuration state.")
    public void setCfgStateByName(String selectedstate) {
        int cfgstate = MetrologyConfig.configuration_states.valueOf((String)selectedstate).ordinal();
        LOGGER.info((Object)("Setting subsystem configuration state to " + MetrologyConfig.configuration_states.values()[cfgstate]));
        this.metrologyc.setCfgState(cfgstate);
    }

    @Command(name="setstate", type=Command.CommandType.QUERY, description="sets the current value of the TS state")
    public void setState(int state) {
        this.state = state;
        this.publishState();
    }

    private void sleep(double secs) {
        try {
            long millis = (long)(secs * 1000.0);
            LOGGER.debug((Object)("Sleeping for " + millis + " millis"));
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            LOGGER.error((Object)("Rude awakening!" + ex));
        }
    }

    @Command(name="publishState", type=Command.CommandType.QUERY, description="publishes the Aerotech state")
    public void publishState() {
        LOGGER.debug((Object)"Entering pubishState");
        MetrologyState metrologyState = new MetrologyState(this.state, this.metrologyc.getOperatingState(), (int)this.periodicTaskService.getPeriodicTaskPeriod(BROADCAST_TASK).toMillis());
        this.getDevStates(metrologyState);
        KeyValueData kd = new KeyValueData("MetrologyState", (Serializable)metrologyState);
        this.subsys.publishSubsystemDataOnStatusBus(kd);
        LOGGER.debug((Object)"published state");
    }

    void getDevStates(MetrologyState tst) {
        if (this.aeroDevc != null) {
            double posx = Double.NaN;
            double posy = Double.NaN;
            double posz = Double.NaN;
            if (this.metrologyc.getOperatingState() != MetrologyConfig.operating_states.SCANNING.ordinal()) {
                try {
                    while (Double.isNaN(posx) || Double.isNaN(posy) || Double.isNaN(posz)) {
                        double[] p = this.aeroDevc.getPosXYZ();
                        posx = p[0];
                        posy = p[1];
                        posz = p[2];
                        this.sleep(0.2);
                    }
                }
                catch (DriverException e) {
                    LOGGER.error((Object)("Error reading Aerotech position: " + (Object)((Object)e)));
                    this.aeroDevc.reconnect();
                }
            } else {
                posx = this.aeroDevc.getLastPosX();
                posy = this.aeroDevc.getLastPosY();
                posz = this.aeroDevc.getLastPosZ();
            }
            tst.setPosx(posx);
            tst.setPosy(posy);
            tst.setPosz(posz);
        }
        if (this.keyDevc != null) {
            if (this.metrologyc.getOperatingState() != MetrologyConfig.operating_states.SCANNING.ordinal()) {
                try {
                    tst.setDisplacement1(this.keyDevc.read(1));
                    tst.setDisplacement2(this.keyDevc.read(2));
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"failed to retrieve Keyence displacement for publishing!");
                }
            } else {
                tst.setDisplacement1(this.keyDevc.getLast_read()[0]);
                tst.setDisplacement2(this.keyDevc.getLast_read()[1]);
            }
        }
        try {
            Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
            double accel = Double.parseDouble((String)configForComponent.get("acceleration"));
            int nsamps = Integer.decode((String)configForComponent.get("nsamples"));
            int measmode = Integer.decode((String)configForComponent.get("measmode"));
            tst.setAcceleration(accel);
            tst.setNsamples(nsamps);
            tst.setMeasmode(measmode);
        }
        catch (NullPointerException ex) {
            LOGGER.error((Object)("Null Pointer Exception - config not ready: " + ex));
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        block27: {
            if (this.monitorCCDTemp) {
                try {
                    StatusSubsystemData ssd = (StatusSubsystemData)msg;
                    KeyValueData msgObject = ssd.getSubsystemData();
                    if (msgObject instanceof KeyValueDataList) {
                        for (KeyValueData d : (KeyValueDataList)msgObject) {
                            LOGGER.debug((Object)("In onDataArrival method. KEY=" + d.getKey()));
                            switch (d.getKey()) {
                                case "temp_a": {
                                    if (this.got_reb_temps) break;
                                    this.last_temp_a = (Double)d.getValue();
                                    break;
                                }
                                case "temp_b": {
                                    if (this.got_reb_temps) break;
                                    this.last_temp_b = (Double)d.getValue();
                                    break;
                                }
                                case "temp_c": {
                                    if (!this.got_reb_temps) {
                                        this.last_temp_c = (Double)d.getValue();
                                        break;
                                    }
                                    this.last_temp_d = (Double)d.getValue();
                                    break;
                                }
                                case "temp_d": {
                                    if (this.got_reb_temps) break;
                                    this.last_temp_d = (Double)d.getValue();
                                    break;
                                }
                                case "vqmpressure": {
                                    this.last_vqmpressure = (Double)d.getValue();
                                    break;
                                }
                                case "R00.Reb0.CCDTemp1": {
                                    this.last_temp_a = (Double)d.getValue();
                                    this.got_reb_temps = true;
                                    break;
                                }
                                case "R00.Reb1.CCDTemp1": {
                                    this.last_temp_b = (Double)d.getValue();
                                    this.got_reb_temps = true;
                                    break;
                                }
                                case "R00.Reb2.CCDTemp1": {
                                    this.last_temp_c = (Double)d.getValue();
                                    this.got_reb_temps = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    if (e.toString().contains("de-serializing")) break block27;
                    LOGGER.info((Object)("Problem unpacking message:" + e));
                }
            }
        }
        if (msg.getOriginAgentInfo().getName().equals(METROLOGY_DEST) && msg.getObject() instanceof ConfigurationInfo) {
            this.configInfo = (ConfigurationInfo)msg.getObject();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="get displacememt summing mode")
    public int getDisp_mode() {
        return this.disp_mode;
    }

    @Command(type=Command.CommandType.QUERY, description="set displacememt summing mode")
    public void setDisp_mode(int disp_mode) {
        this.disp_mode = disp_mode;
    }
}

