/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keyence.KeyenceG5001;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.metrology.KeyenceDevice;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;
import org.lsst.ccs.utilities.logging.Logger;

public class KeyenceG5001Device
extends Device
implements KeyenceDevice {
    private String devcName = null;
    private int baudRate = 0;
    protected MetrologyState.pwrstates kstate = MetrologyState.pwrstates.NOTCONFIGURED;
    protected boolean failedToInitialize = false;
    protected boolean isconnected = true;
    protected double[] lastRead = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final KeyenceG5001 keydev = new KeyenceG5001();

    protected void initDevice() {
        if (this.devcName == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"devcName", (String)"not specified");
        }
        this.fullName = "KeyenceG5001 module (" + this.devcName + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.keydev.openSerial(this.devcName, this.baudRate);
                this.setOnline(true);
                this.initSensors();
                this.kstate = MetrologyState.pwrstates.OK;
                this.log.info((Object)("Connected to " + this.fullName));
            }
            catch (DriverException e) {
                if (this.inited) break block2;
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.keydev.close();
            this.kstate = MetrologyState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 2) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        if (chan == 0) {
            value = this.lastRead[0];
        }
        if (chan == 1) {
            value = this.lastRead[1];
        }
        return value;
    }

    @Override
    @Command(name="read", description="get keyence head measurement")
    public double read(@Argument(name="ikey", description="keyence head number") int ikey) throws DriverException {
        double[] response = this.readAll();
        return response[ikey - 1];
    }

    @Override
    @Command(name="getcycles", description="get sampling cycle setting")
    public int getcycles() throws DriverException {
        return this.keydev.getnsamps();
    }

    @Override
    @Command(name="setcycles", description="set number of cycles")
    public void setcycles(@Argument(name="cycles", description="sampling cycle mode") int cycles) throws DriverException {
        this.keydev.setnsamps(cycles);
    }

    @Override
    @Command(name="getmeasmode", description="get mode")
    public int getmeasmode(@Argument(name="ikey", description="keyence head number") int ikey) throws DriverException {
        return this.keydev.getmeasmode(ikey);
    }

    @Override
    @Command(name="setmeasmode", description="set mode")
    public void setmeasmode(@Argument(name="ikey", description="keyence head number") int ikey, @Argument(name="mode", description="mode number") int mode) throws DriverException {
        this.keydev.setmeasmode(ikey, mode);
    }

    @Override
    @Command(name="setmindispunit", description="set mode")
    public void setmindispunit(@Argument(name="dspu", description="(0: 0.01 mm, 1: 0.001 mm, 2: 0.0001 mm, 3: 0.00001 mm, 4: 0.1 um, 5: 0.01 um, 6: 0.001 um)") int dspu) throws DriverException {
        this.keydev.setmindispunit(dspu);
    }

    @Override
    @Command(name="readAll", description="get keyence head measurement")
    public double[] readAll() throws DriverException {
        double[] response = this.keydev.readDistance();
        System.arraycopy(response, 0, this.lastRead, 0, response.length);
        return response;
    }

    @Override
    @Command(description="communications mode")
    public void commmode() throws DriverException {
        this.keydev.commmode();
    }

    @Override
    @Command(description="general mode")
    public void genmode() throws DriverException {
        this.keydev.genmode();
    }

    @Override
    @Command(description="returns any axis fault messages")
    public String getError() throws DriverException {
        return "not implemented yet";
    }

    @Override
    @Command(description="sets lasers on/off")
    public void laser(@Argument(name="laserstate", description="false for laser off / true for on") boolean laserstate) throws DriverException {
        this.keydev.laser(laserstate);
    }

    @Command(description="generic write", level=10)
    public String keyenceChat(@Argument(name="command", description="The raw Keyence command") String command) throws DriverException {
        return this.keydev.read(command);
    }

    @Override
    public double[] getLastRead() {
        return this.lastRead;
    }

    @Command(name="setstate", description="set KeyenceG5001 device status")
    public void setState(int istate) {
        this.kstate = MetrologyState.pwrstates.values()[istate];
    }

    @Command(name="getstate", description="get KeyenceG5001 device status")
    public int getState() {
        return this.kstate.ordinal();
    }
}

