/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keyence;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class KeyenceG5001
extends Ascii {
    private static final int timeout = 1000;
    public static final int DEFAULT_BAUD = 38400;
    public static final String DEFAULT_DEV = "/dev/ttyS1";
    private static final Map<String, String> errors;

    public KeyenceG5001() {
        this.setOptions(Ascii.Option.NO_NET);
        this.setDefaultParm(38400);
    }

    @Override
    public synchronized void open(DriverConstants.ConnType type, String ident, int baud, int dChar) throws DriverException {
        super.open(type, ident, baud, 0);
        this.setTimeout(1000);
        this.setTerminator(Ascii.Terminator.CR);
    }

    public void laser(boolean laserstate) throws DriverException {
        if (laserstate) {
            this.genmode();
        } else {
            this.commmode();
        }
    }

    public void commmode() throws DriverException {
        block2: {
            try {
                this.writeKey("Q0");
            }
            catch (DriverException e) {
                if (e.getMessage().contains("51")) break block2;
                throw e;
            }
        }
    }

    public void genmode() throws DriverException {
        block2: {
            try {
                this.writeKey("R0");
            }
            catch (DriverException e) {
                if (e.getMessage().contains("51")) break block2;
                throw e;
            }
        }
    }

    public void setnsamps(int cycle) throws DriverException {
        this.writeKey("SW,CA," + cycle);
    }

    public int getnsamps() throws DriverException {
        return this.readIntKey("SR,CA");
    }

    public void setmeasmode(int ikey, int mode) throws DriverException {
        this.writeKey("SW,HB,M", ikey, String.valueOf(mode));
    }

    public int getmeasmode(int ikey) throws DriverException {
        return this.readIntKey("SR,HB,M", ikey);
    }

    public void setmindispunit(int ikey, int dspu) throws DriverException {
        this.writeKey("SW,OG", ikey, String.valueOf(dspu));
    }

    public int getmindispunit(int ikey) throws DriverException {
        return this.readIntKey("SR,OG", ikey);
    }

    public void setmindispunit(int dspu) throws DriverException {
        this.setmindispunit(1, dspu);
        this.setmindispunit(2, dspu);
    }

    public double readDistance(int ikey) throws DriverException {
        return this.readDoubleKey("MS", ikey)[0];
    }

    public double[] readDistance() throws DriverException {
        return this.readDoubleKey("MA");
    }

    public synchronized void writeKey(String command) throws DriverException {
        String rply = this.read(command);
        if (!rply.startsWith(command.split(",")[0].toUpperCase())) {
            this.reportCommandError(rply);
        }
    }

    public synchronized String readKey(String command) throws DriverException {
        String rply = this.read(command);
        if (rply.startsWith(command.toUpperCase())) {
            return rply.substring(command.length() + 1);
        }
        this.reportCommandError(rply);
        return null;
    }

    private void writeKey(String command, int ikey, String arg) throws DriverException {
        this.writeKey(String.format("%s,%02d,%s", command, ikey, arg));
    }

    private String readKey(String command, int ikey) throws DriverException {
        return this.readKey(String.format("%s,%02d", command, ikey));
    }

    private int readIntKey(String command, int ikey) throws DriverException {
        return KeyenceG5001.getInt(this.readKey(command, ikey));
    }

    private int readIntKey(String command) throws DriverException {
        return KeyenceG5001.getInt(this.readKey(command));
    }

    private static int getInt(String resp) throws DriverException {
        try {
            return Integer.decode(resp);
        }
        catch (NumberFormatException ex) {
            throw new DriverException("Command response is not an integer: " + resp);
        }
    }

    private double[] readDoubleKey(String command, int ikey) throws DriverException {
        return KeyenceG5001.getDoubles(this.readKey(command, ikey));
    }

    private double[] readDoubleKey(String command) throws DriverException {
        return KeyenceG5001.getDoubles(this.readKey(command));
    }

    private static double[] getDoubles(String resp) throws DriverException {
        String[] words = resp.split(",");
        double[] value = new double[words.length];
        for (int i = 0; i < words.length; ++i) {
            try {
                value[i] = Double.parseDouble(words[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                if (words[i].equals("-FFFFFFF") || words[i].equals("+FFFFFFF") || words[i].equals("XXXXXXXX")) {
                    value[i] = Double.NaN;
                    continue;
                }
                throw new DriverException("Unparseable response: " + resp);
            }
        }
        return value;
    }

    private void reportCommandError(String reply) throws DriverException {
        String[] words = reply.split(",");
        if (words[0].equals("ER")) {
            String errnum = words[words.length - 1];
            String errmsg = errors.get(errnum);
            if (errmsg != null) {
                throw new DriverException("Command execution error: " + errnum + " (" + errmsg + ")");
            }
            throw new DriverException("Command execution error: " + errnum);
        }
        throw new DriverException("Unrecognized command response: " + reply);
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("50", "Command error");
        tmp.put("51", "Status error");
        tmp.put("60", "Command length error");
        tmp.put("61", "Parameter count error");
        tmp.put("62", "Parameter range error");
        tmp.put("63", "Parameter range error (OUT calculation count)");
        tmp.put("64", "Parameter range error (OUT or head number)");
        tmp.put("65", "Parameter range error (OUT for veloc/accn)");
        tmp.put("66", "Parameter range error (OUT recursive)");
        tmp.put("67", "Parameter range error (cycle too fast)");
        tmp.put("68", "Parameter range error (scaling)");
        tmp.put("69", "Parameter range error (analog output scaling)");
        tmp.put("70", "Parameter range error (number of data points)");
        tmp.put("71", "Parameter range error (OUT too large)");
        tmp.put("88", "Timeout error");
        tmp.put("99", "Other error");
        errors = Collections.unmodifiableMap(tmp);
    }
}

