/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentPropertyPredicate;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentPresenceManager
implements StatusMessageListener {
    private final Object agentsLock = new Object();
    final CopyOnWriteArrayList<AgentPresenceListener> listAPL = new CopyOnWriteArrayList();
    private final Map<AgentInfo, TimeoutTask> mapAgents = new ConcurrentHashMap<AgentInfo, TimeoutTask>();
    private final List<AgentInfo> fullyConnectedAgents = new CopyOnWriteArrayList<AgentInfo>();
    private static final int SUSPICION_LENGTH = 10;
    private final Timer timer = new Timer(true);
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.messaging.agentpresencemanager");
    private final ReentrantLock agentConnectionWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, AgentPropertyPredicate> agentConnectionWaitList;
    private final ReentrantLock agentDisconnectionWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, String> agentDisconnectionWaitList;
    private final BlockingQueue<Runnable> notifications = new ArrayBlockingQueue<Runnable>(10);

    private static boolean hasStateChanged(AgentPresenceState oldState, AgentPresenceState newState) {
        if (oldState == newState) {
            return false;
        }
        if (oldState.ordinal() < newState.ordinal()) {
            return true;
        }
        throw new RuntimeException("Illegal AgentPresenceState Transition : " + (Object)((Object)oldState) + " -> " + (Object)((Object)newState));
    }

    public AgentPresenceManager() {
        ExecutorService queueExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "Connection/Disconnection queue");
            t.setDaemon(true);
            return t;
        });
        queueExecutor.submit(() -> this.checkQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.agentsLock;
        synchronized (object) {
            for (TimerTask timerTask : this.mapAgents.values()) {
                if (timerTask == null) continue;
                timerTask.cancel();
            }
            this.mapAgents.clear();
            this.fullyConnectedAgents.clear();
        }
    }

    private void checkQueue() {
        try {
            while (true) {
                this.notifications.take().run();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed when draining Connection/Disconnection queue.", e);
        }
    }

    @Override
    public void onStatusMessage(StatusMessage s) {
        AgentInfo a = s.getOriginAgentInfo();
        if (a == null) {
            return;
        }
        int broadCastPeriod = -1;
        if (s instanceof StatusHeartBeat) {
            StatusHeartBeat hb = (StatusHeartBeat)s;
            broadCastPeriod = hb.getStatusBroadcastPeriod();
        }
        if (s.getState().isInState(PhaseState.OFF_LINE)) {
            log.debug((Object)"remove agent on status end");
            this.removeAgent(a);
        } else if (s.getState().isInState(PhaseState.INITIALIZING)) {
            this.updateAgent(a, broadCastPeriod, AgentPresenceState.CONNECTING);
        } else {
            this.updateAgent(a, broadCastPeriod, AgentPresenceState.CONNECTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgent(AgentInfo a, int broadcastPeriod, AgentPresenceState state) {
        ConnectionDisconnectionNotification notification = null;
        Object object = this.agentsLock;
        synchronized (object) {
            TimeoutTask task = this.mapAgents.get(a);
            if (task != null) {
                AgentPresenceState oldState;
                boolean hasStateChanged;
                task.cancel();
                if (broadcastPeriod == -1) {
                    broadcastPeriod = task.getBroadcastPeriod();
                }
                AgentPresenceState newState = (hasStateChanged = AgentPresenceManager.hasStateChanged(oldState = task.getAgentPresenceState(), state)) ? state : oldState;
                task = new TimeoutTask(a, broadcastPeriod, newState);
                this.mapAgents.put(a, task);
                if (hasStateChanged) {
                    notification = new ConnectionDisconnectionNotification(a, newState);
                }
            } else {
                if (broadcastPeriod == -1) {
                    broadcastPeriod = 10;
                }
                task = new TimeoutTask(a, broadcastPeriod, state);
                this.mapAgents.put(a, task);
                notification = new ConnectionDisconnectionNotification(a, state, true);
            }
            if (notification != null) {
                this.notifications.offer(notification);
            }
            this.timer.schedule((TimerTask)task, 10000 * broadcastPeriod);
        }
        log.debug((Object)("reset timer for agent " + a.getName() + " to " + broadcastPeriod));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAgent(AgentInfo agent) {
        ConnectionDisconnectionNotification notification = null;
        log.debug((Object)("removing agent " + agent.getName()));
        TimeoutTask t = null;
        Object object = this.agentsLock;
        synchronized (object) {
            t = this.mapAgents.remove(agent);
            if (t != null) {
                t.cancel();
                notification = new ConnectionDisconnectionNotification(agent, AgentPresenceState.DISCONNECTING);
                this.notifications.offer(notification);
            }
        }
        if (t == null) {
            log.debug((Object)"removing agent with null timer");
        }
    }

    public List<AgentInfo> listConnectedAgents() {
        return new ArrayList<AgentInfo>(this.fullyConnectedAgents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnecting(String agentName) {
        AgentInfo agentToRemove = null;
        Object object = this.agentsLock;
        synchronized (object) {
            for (AgentInfo a : this.mapAgents.keySet()) {
                if (!a.getName().equals(agentName)) continue;
                agentToRemove = a;
                break;
            }
        }
        if (agentToRemove != null) {
            this.removeAgent(agentToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentPresenceListener(AgentPresenceListener l) {
        Object object = this.agentsLock;
        synchronized (object) {
            l.connecting(this.mapAgents.keySet().toArray(new AgentInfo[0]));
            l.connected(this.fullyConnectedAgents.toArray(new AgentInfo[0]));
            this.listAPL.add(l);
        }
    }

    public void removeAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.remove(l);
    }

    public boolean agentExists(String agentName) {
        ArrayList<AgentInfo> existingAgents = new ArrayList<AgentInfo>(this.mapAgents.keySet());
        for (AgentInfo a : existingAgents) {
            if (!a.getName().equals(agentName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAgentConnected(String agentName) {
        List<AgentInfo> list = this.fullyConnectedAgents;
        synchronized (list) {
            for (AgentInfo a : this.fullyConnectedAgents) {
                if (!a.getName().equals(agentName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAgentConnected(AgentPropertyPredicate agentPredicate) {
        List<AgentInfo> list = this.fullyConnectedAgents;
        synchronized (list) {
            for (AgentInfo a : this.fullyConnectedAgents) {
                if (!agentPredicate.test(a)) continue;
                return true;
            }
            return false;
        }
    }

    public final boolean waitForAgent(String name, long timeout, TimeUnit unit) throws InterruptedException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("agentName", name);
        AgentPropertyPredicate innerPredicate = new AgentPropertyPredicate(properties);
        return this.waitForAgent(innerPredicate, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForAgent(AgentPropertyPredicate predicate, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.agentConnectionWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            if (this.isAgentConnected(predicate)) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.agentConnectionWaitLock.newCondition();
            if (this.agentConnectionWaitList == null) {
                this.agentConnectionWaitList = new LinkedHashMap(4);
            }
            this.agentConnectionWaitList.put(condition, predicate);
            while (this.agentConnectionWaitList != null && this.agentConnectionWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.agentConnectionWaitLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentConnectionWaitNotify(AgentInfo agentInfo) {
        try {
            this.agentConnectionWaitLock.lockInterruptibly();
            if (this.agentConnectionWaitList == null) {
                return;
            }
            Iterator<Map.Entry<Condition, AgentPropertyPredicate>> it = this.agentConnectionWaitList.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Condition, AgentPropertyPredicate> entry = it.next();
                AgentPropertyPredicate agentWaitPredicate = entry.getValue();
                if (!agentWaitPredicate.test(agentInfo)) continue;
                entry.getKey().signal();
                it.remove();
            }
            if (this.agentConnectionWaitList.isEmpty()) {
                this.agentConnectionWaitList = null;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.agentConnectionWaitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForAgentDisconnection(String name, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.agentDisconnectionWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            if (!this.isAgentConnected(name)) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.agentDisconnectionWaitLock.newCondition();
            if (this.agentDisconnectionWaitList == null) {
                this.agentDisconnectionWaitList = new LinkedHashMap(4);
            }
            this.agentDisconnectionWaitList.put(condition, name);
            while (this.agentDisconnectionWaitList != null && this.agentDisconnectionWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.agentDisconnectionWaitLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentDisconnectionWaitNotify(String name) {
        try {
            this.agentDisconnectionWaitLock.lockInterruptibly();
            try {
                if (this.agentDisconnectionWaitList == null) {
                    return;
                }
                Iterator<Map.Entry<Condition, String>> it = this.agentDisconnectionWaitList.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Condition, String> entry = it.next();
                    String agentWaitName = entry.getValue();
                    if (!name.equals(agentWaitName)) continue;
                    entry.getKey().signal();
                    it.remove();
                }
                if (this.agentDisconnectionWaitList.isEmpty()) {
                    this.agentDisconnectionWaitList = null;
                }
            }
            finally {
                this.agentDisconnectionWaitLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            log.severe((Object)"Exception when notifying for disconnection ", (Throwable)ie);
        }
    }

    private class ConnectionDisconnectionNotification
    implements Runnable {
        private final AgentInfo agentInfo;
        private final AgentPresenceState state;
        private final boolean isFirstNotification;

        ConnectionDisconnectionNotification(AgentInfo agentInfo, AgentPresenceState state) {
            this(agentInfo, state, false);
        }

        ConnectionDisconnectionNotification(AgentInfo agentInfo, AgentPresenceState state, boolean isFirstNotification) {
            this.agentInfo = agentInfo;
            this.state = state;
            this.isFirstNotification = isFirstNotification;
        }

        @Override
        public void run() {
            if (this.state == AgentPresenceState.DISCONNECTING) {
                AgentPresenceManager.this.listAPL.forEach(l -> l.disconnecting(this.agentInfo));
                AgentPresenceManager.this.fullyConnectedAgents.remove(this.agentInfo);
                AgentPresenceManager.this.agentDisconnectionWaitNotify(this.agentInfo.getName());
            }
            if (this.isFirstNotification) {
                AgentInfo[] agents = new AgentInfo[]{this.agentInfo};
                AgentPresenceManager.this.listAPL.forEach(l -> l.connecting(agents));
            }
            if (this.state == AgentPresenceState.CONNECTED) {
                AgentPresenceManager.this.listAPL.forEach(l -> l.connected(this.agentInfo));
                AgentPresenceManager.this.fullyConnectedAgents.add(this.agentInfo);
                AgentPresenceManager.this.agentConnectionWaitNotify(this.agentInfo);
            }
        }
    }

    class TimeoutTask
    extends TimerTask {
        private final AgentInfo agent;
        private final int broadcastPeriod;
        private final AgentPresenceState state;

        TimeoutTask(AgentInfo agent, int broadcastPeriod, AgentPresenceState state) {
            this.agent = agent;
            this.broadcastPeriod = broadcastPeriod;
            this.state = state;
        }

        int getBroadcastPeriod() {
            return this.broadcastPeriod;
        }

        @Override
        public void run() {
            AgentPresenceManager.this.removeAgent(this.agent);
        }

        AgentPresenceState getAgentPresenceState() {
            return this.state;
        }
    }

    public static enum AgentPresenceState {
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

