package org.lsst.ccs.subsystem.metrology;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

/**
 * KeyenceG5001 device class for the metrology subsystem
 *
 * @author: Homer Neal
 */
public class KeyenceG5001DeviceSim extends KeyenceG5001Device {

    private int ncycles, measmode, mindispunit;
    
    /**
     * Initializes the device.
     */
    @Override
    protected void initialize() {
    }

    /**
     * Returns the sampling cycle setting being used for the displacement measurements
     * 
     * @return
     */
    @Override
    @Command(name = "getcycles", description = "get sampling cycle setting")
    public int getcycles() {
        return ncycles;
    }

    /**
     * Sets the sampling cycle mode to be used for the displacement measurements
     */
    @Override
    @Command(name = "setcycles", description = "set number of cycles")
    public void setcycles(@Argument(name = "cycles", description = "sampling cycle mode") int cycles) {
        ncycles = cycles;
    }

    /**
     * Gets the sensing mode
     * 
     * @return
     */
    @Override
    @Command(name = "getmeasmode", description = "get mode")
    public int getmeasmode(@Argument(name = "ikey", description = "keyence head number") int ikey) {
        return measmode;
    }

    /**
     * Sets the sensing mode
     * 
     * @param mode
     * 0: Normal, 
     * 1: Translucent object,
     * 2: Transparent object, 
     * 3: Transparent object 2, 
     * 4: Semi opaque
     */
    @Override
    @Command(name = "setmeasmode", description = "set mode")
    public void setmeasmode(@Argument(name = "ikey", description = "keyence head number") int ikey,
                            @Argument(name = "mode", description = "mode number") int mode) {
        measmode = mode;
    }

    /**
     * Sets the minimum display unit
     * 
     * @param dspu
     */
    @Override
    @Command(name = "setmindispunit", description = "set mode")
    public void setmindispunit(@Argument(name = "dspu", description = "(0: 0.01 mm, 1: 0.001 mm, 2: 0.0001 mm, 3: 0.00001 mm, 4: 0.1 um, 5: 0.01 um, 6: 0.001 um)") int dspu
    ) {
        mindispunit = dspu;
    }

    /**
     * Reads the distances from the Keyence heads
     * 
     * @return
     */
    @Override
    @Command(name = "readAll", description = "get keyence head measurement")
    public double[] readAll() {
        double[] response = {1.2, 3.1};
        System.arraycopy(response, 0, lastRead, 0, response.length);
        return response;
    }

    /**
     * Sets communications mode.
     */
    @Override
    @Command(description = "communications mode")
    public void commmode() {
    }

    /**
     * Sets general mode.
     */
    @Override
    @Command(description = "general mode")
    public void genmode() {
    }

    /**
     * Turns laser on/off
     * 
     * @param laserstate
     */
    @Override
    @Command(description = "sets lasers on/off")
    public void laser(@Argument(name = "laserstate", description = "false for laser off / true for on") boolean laserstate) {
    }

    /**
     * Generic write operation followed by a read.
     * 
     * @param command
     * @return
     */
    @Override
    @Command(description = "generic write")
    public String keyenceChat(@Argument(name = "command", description = "The raw Keyence command") String command) {
        return command;
    }

}
