package org.lsst.ccs.subsystem.metrology;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Defines an Kryence device interface.
 *
 * @author Homer Neal
 */
public interface KeyenceDevice {

    double read(int ikey) throws DriverException ;
    
    double[] readAll() throws DriverException ;
    
    double[] getLastRead();
    
    default double[] getLast_read() {
        return getLastRead();
    }
    
    void laser(boolean state) throws DriverException;
    
    int getcycles() throws DriverException ;
    
    void setcycles(int nsamps) throws DriverException ;
    
    int getmeasmode(int ikey) throws DriverException ;
    
    void setmeasmode(int ikey, int measmode) throws DriverException ;

    void setmindispunit(int dspu) throws DriverException ;

    void commmode() throws DriverException ;

    void genmode() throws DriverException ;

    String getError() throws DriverException ;
    
}
