package org.lsst.ccs.subsystem.metrology;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;

/**
 *
 * @author The LSST CCS Team
 */
public class PointListConfigurable {

    private final Map<String, Integer> currentParms = new HashMap<>();
    private int min;
    private int max;

    @ConfigurationParameter(name = "PointX", category = "PointListConfig")
    private double PointX;
    @ConfigurationParameter(name = "PointY", category = "PointListConfig")
    private double PointY;
    @ConfigurationParameter(name = "PointZ", category = "PointListConfig")
    private double PointZ;

    final double MIN_X = 0.,
            MAX_X = 300.;
    final double MIN_Y = 0.,
            MAX_Y = 300.;
    final double MIN_Z = 0.,
            MAX_Z = 200.;
    
    public PointListConfigurable(
            double PointX, double PointY, double PointZ) {

//    public MetrologyConfigurable(HashMap<String, Object> parms) {
        
//        System.out.println("MetrologyConfigurable name = "+this.toString());
        assert (PointX > MIN_X);
        assert (PointX < MAX_X);
        assert (PointY > MIN_Y);
        assert (PointY < MAX_Y);
        assert (PointZ > MIN_Z);
        assert (PointZ < MAX_Z);


        this.PointX = PointX; this.PointY = PointY; this.PointZ = PointZ;

    }

    
    @ConfigurationParameterChanger(propertyName = "PointX")
    public void setPointX(Object PointX) {
        double val = (double) PointX;
        assert (val > MIN_X);
        assert (val < MAX_X);
        System.out.println("configuring pointx to "+val);
        this.PointX = val;
    }
    @ConfigurationParameterChanger(propertyName = "PointY")
    public void setPointY(Object PointY) {
        double val = (double) PointY;
        assert (val > MIN_Y);
        assert (val < MAX_Y);
        System.out.println("configuring pointy to "+val);
        this.PointY = val;
    }
    @ConfigurationParameterChanger(propertyName = "PointZ")
    public void setPointZ(Object PointZ) {
        double val = (double) PointZ;
        assert (val > MIN_Z);
        assert (val < MAX_Z);
        System.out.println("configuring pointz to "+val);
        this.PointZ = val;
    }

    @ConfigurationParameterChanger
    public void setCurrentParms(Object currentParms) {
        Map<String, Integer> map = (Map<String, Integer>) currentParms;
        this.currentParms.putAll(map);
    }


}
