package org.lsst.ccs.subsystem.metrology;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;

/**
 ***************************************************************************
 **
 * KeyenceG5001 device class for the metrology subsystem
 *
 * * @author: Homer Neal
 * **************************************************************************
 */
public class KeyenceG5001DeviceSim extends KeyenceG5001Device {


    private int ncycles, measmode, mindispunit;
    
    /**
     ***************************************************************************
     **
     ** KeyenceG5001Device constructor - put KeyenceG5001 in initial subsystem
     * state
     *
     ** @param host device address
     ** @param port port or baud * * @param runBias CCD bias voltage while
     * running
     *
     * @throws org.lsst.ccs.drivers.commons.DriverException
     * **************************************************************************
     */
    public KeyenceG5001DeviceSim(String host, int port)
            throws DriverException {
        super(host,port);
    }

    /**
     ***************************************************************************
     **
     ** Initializes the device
     * **************************************************************************
     */
    @Override
    protected void initialize() {
        if (isconnected) {
            log.debug("KeyenceG5001 device is already initialized");
            /*
             try {
             log.debug(keydev.getVersion());
             } catch (Exception e) {
             if (!failedToInitialize) {
             log.error("KeyenceG5001 device failed to respond to ident request! The initialization has FAILED.");
             failedToInitialize = true;
             }
             isconnected = false;
             }
             */
            log.debug("Setting device online.");
            setOnline(true);
            kstate = MetrologyState.pwrstates.OK;
        } else {
            if (!failedToInitialize) {
                log.error("Tried to initialize unconnected Keyence device!");
                failedToInitialize = true;
            }

        }
    }

    /**
     ***************************************************************************
     **
     ** gets version of the Ensemble controller *
     * **************************************************************************
     */
    @Command(description = "return controller version")
    public String getVersion() throws DriverException {
        return "Simulation 1.0";
    }


    /**
     ***************************************************************************
     **
     ** return the sampling cycle setting being used for the displacement measurements
     * **************************************************************************
     */
    @Command(name = "getcycles", description = "get sampling cycle setting")
    public int getcycles( 
        //@Argument(name = "ikey", description = "keyence head number") int ikey    
            ) throws DriverException {
        return ncycles;
    }

    /**
     ***************************************************************************
     **
     ** set the sampling cycle mode to be used for the displacement measurements
     * **************************************************************************
     */
    @Command(name = "setcycles", description = "set number of cycles")
    public void setcycles(
            @Argument(name = "cycles", description = "sampling cycle mode") int cycles
    ) throws DriverException {
        ncycles = cycles;
    }

    /**
     ***************************************************************************
     **
     ** return the sensing mode
     * **************************************************************************
     */
    @Command(name = "getmeasmode", description = "get mode")
    public int getmeasmode() throws DriverException {
        return measmode;
    }

    /**
     ***************************************************************************
     **
     ** set the sensing mode
     * 
     * 0: Normal, 
     * 1: Translucent object,
     * 2: Transparent object, 
     * 3: Transparent object 2, 
     * 4: Semi opaque
     * 
     * **************************************************************************
     */
    @Command(name = "setmeasmode", description = "set mode")
    public void setmeasmode(@Argument(name = "mode", description = "mode number") int mode
    ) throws DriverException {
        measmode = mode;
    }

    /**
     ***************************************************************************
     **
     ** set the minimum display unit
     * 
     * 
     * **************************************************************************
     */
    @Command(name = "setmindispunit", description = "set mode")
    public void setmindispunit(@Argument(name = "dspu", description = "(0: 0.01 mm, 1: 0.001 mm, 2: 0.0001 mm, 3: 0.00001 mm, 4: 0.1 um, 5: 0.01 um, 6: 0.001 um)") int dspu
    ) throws DriverException {
        mindispunit = dspu;
    }

    /**
     ***************************************************************************
     **
     ** read the distance from the Keyence head
     * **************************************************************************
     * @throws org.lsst.ccs.drivers.commons.DriverException
     */
    @Command(name = "readAll", description = "get keyence head measurement")
    public double[] readAll() throws DriverException {
        double[] response = {1.2, 3.1};
        for (int i = 0; i < response.length; i++) {
            last_read[i] = response[i];
        }
        return (response);
    }

     /***************************************************************************
     **
     ** communications mode
     *        
     * **************************************************************************
     * @throws org.lsst.ccs.drivers.commons.DriverException
     */
    @Command(description = "communications mode")
    public void commmode() throws DriverException {
    }

     /***************************************************************************
     **
     ** general mode
     *        
     * **************************************************************************
     * @throws org.lsst.ccs.drivers.commons.DriverException
     */
    @Command(description = "general mode")
    public void genmode() throws DriverException {
    }


    /**
     ***************************************************************************
     **
     ** reset
     * **************************************************************************
     */
    @Command(description = "clears all fault mesdsages")
    public void reset() throws DriverException {
    }

    /**
     ***************************************************************************
     **
     ** laser on/off
     * **************************************************************************
     */
    @Command(description = "sets lasers on/off")
    public void laser(@Argument(name = "laserstate", description = "false for laser off / true for on") boolean laserstate) throws DriverException {
    }

    /**
     ***************************************************************************
     ** Generic write operation followed by a read.
     ** 
     * **************************************************************************
     */
    @Command(description = "generic write")
    public String keyenceChat(@Argument(name = "command", description = "The raw Keyence command") String command) throws DriverException {
        return command;
    }

}
