package org.lsst.ccs.subsystem.metrology;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 ** Defines an Aerotech device interface.
 *
 * @author Homer Neal
 */
public interface AerotechDevice {

    void abort() throws DriverException ;

    void enableAxes() throws DriverException ;

    void disableAxes() throws DriverException ;

    String getVersion() throws DriverException ;
    
    void rampRate(double rate) throws DriverException;

    void setSpeed(double speed) throws DriverException;

    void moveIncX(double dx) throws DriverException;

    void moveIncY(double dy) throws DriverException;

    void moveIncZ(double dz) throws DriverException;

    void moveIncXY(double dx, double dy) throws DriverException;

    void moveIncXYZ(double dx, double dy, double dz) throws DriverException;

    void moveAbsX(double x) throws DriverException;

    void moveAbsY(double y) throws DriverException;

    void moveAbsZ(double z) throws DriverException;
    
    void moveAbsXY(double x, double y) throws DriverException;

    void moveAbsXYZ(double x, double y, double z) throws DriverException;
    
    double getPosX() throws DriverException ;

    double getPosY() throws DriverException ;

    double getPosZ() throws DriverException ;

    double[] getPosXYZ() throws DriverException ;

    double getLastPosX();

    double getLastPosY();

    double getLastPosZ();
    
    double getxOffset();

    double getyOffset();

    double getzOffset();

    void setxOffset(double xoff);

    void setyOffset(double yoff);

    void setzOffset(double zoff);
    
    String getError() throws DriverException ;
    
    void reset() throws DriverException ;

    void fullreset() throws DriverException ;

    void reconnect();
    
    void goHome() throws DriverException ;

    void setupHome(int mode) throws DriverException ;

    void softLowLim(String axis, int param) throws DriverException ;

    void softHighLim(String axis, int param) throws DriverException ;

    // Deprecated methods
    @Deprecated
    @Command(description = "move incrementally in x")
    default void moveInc_x(@Argument(description = "amount to move in user units") double dx) throws DriverException {
        moveIncX(dx);
    }
    @Deprecated
    @Command(description = "move incrementally in y")
    default void moveInc_y(@Argument(description = "amount to move in user units") double dy) throws DriverException {
        moveIncY(dy);
    }
    @Deprecated
    @Command(description = "move incrementally in z")
    default void moveInc_z(@Argument(description = "amount to move in user units") double dz) throws DriverException {
        moveIncZ(dz);
    }
    @Deprecated
    @Command(description = "move incrementally in x and y")
    default void moveInc_xy(@Argument(description = "amount to move in x in user units") double dx,
                            @Argument(description = "amount to move in y in user units") double dy) throws DriverException {
        moveIncXY(dx, dy);
    }
    @Deprecated
    @Command(description = "move incrementally in x, y and z")
    default void moveInc_xyz(@Argument(description = "amount to move in x in user units") double dx,
                             @Argument(description = "amount to move in y in user units") double dy,
                             @Argument(description = "amount to move in z in user units") double dz) throws DriverException {
        moveIncXYZ(dx, dy, dz);
    }
    @Deprecated
    @Command(description = "move absolutely in x")
    default void moveAbs_x(@Argument(description = "x position in user units") double x) throws DriverException {
        moveAbsX(x);
    }
    @Deprecated
    @Command(description = "move absolutely in y")
    default void moveAbs_y(@Argument(description = "y position in user units") double y) throws DriverException {
        moveAbsY(y);
    }
    @Deprecated
    @Command(description = "move absolutely in z")
    default void moveAbs_z(@Argument(description = "z position in user units") double z) throws DriverException {
        moveAbsZ(z);
    }
    @Deprecated
    @Command(description = "move absolutely in x and y")
    default void moveAbs_xy(@Argument(description = "x position in user units") double x,
                            @Argument(description = "y position in user units") double y) throws DriverException {
        moveAbsXY(x, y);
    }
    @Deprecated
    @Command(description = "move absolutely in x, y and z")
    default void moveAbs_xyz(@Argument(description = "x position in user units") double x,
                             @Argument(description = "y position in user units") double y,
                             @Argument(description = "z position in user units") double z) throws DriverException {
        moveAbsXYZ(x, y, z);
    }
    @Deprecated
    @Command(description = "returns position in x")
    default double getPos_x() throws DriverException {
        return getPosX();
    }
    @Deprecated
    @Command(description = "returns position in y")
    default double getPos_y() throws DriverException {
        return getPosY();
    }
    @Deprecated
    @Command(description = "returns position in z")
    default double getPos_z() throws DriverException {
        return getPosZ();
    }
    @Deprecated
    @Command(description = "returns position in x, y and z")
    default double[] getPos_xyz() throws DriverException {
        return getPosXYZ();
    }
    @Deprecated
    default double getLastPos_x() {
        return getLastPosX();
    }
    @Deprecated
    default double getLastPos_y() {
        return getLastPosY();
    }
    @Deprecated
    default double getLastPos_z() {
        return getLastPosZ();
    }
    
}
