/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

public abstract class EfficiencyBinnerUtils {
    static final int[] INDX = new int[]{1, 2, 4, 7, 11, 16, 22, 29, 37, 46};
    static final int[] MX = new int[]{10, 11, 12, 15, 20, 25, 50, 100, 500};
    static final double[][] TAB1 = new double[][]{{0.0, 1.0}, {0.0, 0.975}, {0.0126, 0.9874}, {0.0, 0.8419}, {0.0084, 0.9057}, {0.0676, 0.9324}, {0.0, 0.7076}, {0.0063, 0.8059}, {0.0527, 0.8534}, {0.1181, 0.8819}, {0.0, 0.6024}, {0.0051, 0.7164}, {0.0433, 0.7772}, {0.099, 0.8159}, {0.157, 0.843}, {0.0, 0.5218}, {0.0042, 0.6412}, {0.0367, 0.7096}, {0.0852, 0.7551}, {0.137, 0.788}, {0.1871, 0.8129}, {0.0, 0.4593}, {0.0036, 0.5787}, {0.0319, 0.6509}, {0.0749, 0.7007}, {0.1216, 0.7376}, {0.1675, 0.7662}, {0.211, 0.789}, {0.0, 0.4096}, {0.0032, 0.5265}, {0.0281, 0.6001}, {0.0667, 0.6525}, {0.1093, 0.6921}, {0.1517, 0.7233}, {0.1923, 0.7486}, {0.2304, 0.7696}, {0.0, 0.3694}, {0.0028, 0.4825}, {0.0252, 0.5561}, {0.0602, 0.6097}, {0.0993, 0.6511}, {0.1386, 0.6842}, {0.1766, 0.7114}, {0.2127, 0.7341}, {0.2466, 0.7534}, {0.0, 0.3363}, {0.0025, 0.445}, {0.0228, 0.5178}, {0.0549, 0.5719}, {0.0909, 0.6143}, {0.1276, 0.6486}, {0.1634, 0.6771}, {0.1975, 0.7012}, {0.2298, 0.7218}, {0.2602, 0.7398}};
    static final double[][][] TAB2 = new double[][][]{new double[][]{{0.0, 0.3085}, {0.0023, 0.4128}, {0.0209, 0.4841}, {0.0504, 0.5381}, {0.0839, 0.581}, {0.1182, 0.6162}, {0.152, 0.6456}, {0.1844, 0.6707}, {0.2153, 0.6924}, {0.2445, 0.7114}}, new double[][]{{0.0, 0.2849}, {0.0021, 0.3848}, {0.0192, 0.4545}, {0.0466, 0.508}, {0.0779, 0.551}, {0.1102, 0.5866}, {0.1421, 0.6167}, {0.173, 0.6425}, {0.2025, 0.6649}, {0.2306, 0.6847}}, new double[][]{{0.0, 0.2646}, {0.0019, 0.3603}, {0.0178, 0.4281}, {0.0433, 0.4809}, {0.0727, 0.5238}, {0.1031, 0.5596}, {0.1334, 0.59}, {0.1629, 0.6164}, {0.1912, 0.6394}, {0.2182, 0.6598}}, new double[][]{{0.0, 0.218}, {0.0016, 0.3023}, {0.0146, 0.3644}, {0.0358, 0.4142}, {0.0605, 0.4557}, {0.0866, 0.491}, {0.1128, 0.5217}, {0.1387, 0.5487}, {0.1638, 0.5726}, {0.188, 0.5941}}, new double[][]{{0.0, 0.1684}, {0.0012, 0.2382}, {0.0112, 0.2916}, {0.0278, 0.3359}, {0.0474, 0.3738}, {0.0683, 0.407}, {0.0897, 0.4364}, {0.1112, 0.4628}, {0.1322, 0.4865}, {0.1529, 0.5083}}, new double[][]{{0.0, 0.1372}, {0.001, 0.1964}, {0.0091, 0.2429}, {0.0227, 0.2823}, {0.0389, 0.3167}, {0.0564, 0.3473}, {0.0745, 0.3747}, {0.0928, 0.3997}, {0.1109, 0.4225}, {0.1288, 0.4437}}, new double[][]{{0.0, 0.0711}, {5.0E-4, 0.1045}, {0.0047, 0.1321}, {0.0118, 0.1567}, {0.0206, 0.179}, {0.0302, 0.1996}, {0.0403, 0.2187}, {0.0508, 0.2367}, {0.0615, 0.2537}, {0.0722, 0.2699}}, new double[][]{{0.0, 0.0362}, {3.0E-4, 0.0539}, {0.0024, 0.0691}, {0.006, 0.0828}, {0.0106, 0.0956}, {0.0156, 0.1077}, {0.0211, 0.1191}, {0.0267, 0.1301}, {0.0325, 0.1407}, {0.0385, 0.151}}, new double[][]{{0.0, 0.0074}, {1.0E-4, 0.0111}, {5.0E-4, 0.0143}, {0.0012, 0.0173}, {0.0022, 0.0202}, {0.0032, 0.023}, {0.0044, 0.0256}, {0.0056, 0.0282}, {0.0068, 0.0308}, {0.0081, 0.0333}}};

    static double H95CL(double R1, double R2, int IER) {
        double P;
        int NT;
        int N1 = (int)Math.round(R1);
        if (N1 > (NT = (int)Math.round(R2))) {
            throw new IllegalArgumentException();
        }
        int NX = Math.min(N1, NT - N1);
        int KL = 2;
        if (IER == 2) {
            KL = 1;
        }
        if (NX != N1) {
            KL = 3 - KL;
        }
        int NMX = NT - NX;
        if (NX >= 10) {
            return 1.96 * Math.sqrt(R1 * (R2 - R1) / R2) / R2;
        }
        if (NMX >= 10) {
            int K = NX + 1;
            if (NMX >= 500) {
                P = TAB2[8][K - 1][KL - 1] * 500.0 / (double)NMX;
            } else if (NMX < 12) {
                P = TAB2[NMX - 8][K - 1][KL - 1];
            } else {
                int IT = NMX >= 100 ? 8 : (NMX >= 49 ? 7 : (NMX >= 25 ? 6 : (NMX >= 20 ? 5 : (NMX >= 15 ? 4 : 3))));
                P = TAB2[IT - 1][K - 1][KL - 1] + ((double)NMX - (double)MX[IT - 1]) / (double)(MX[IT] - MX[IT - 1]) * (TAB2[IT][K - 1][KL - 1] - TAB2[IT - 1][K - 1][KL - 1]);
            }
        } else {
            int K = INDX[NMX] + NX;
            P = TAB1[K - 1][KL - 1];
        }
        if (NX != N1) {
            P = 1.0 - P;
        }
        return Math.abs(P - R1 / Math.max(1.0, R2));
    }
}

