/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.utilities.logging.Logger;

public class MBeanService
implements ServiceLifecycle {
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.mbean");
    private MBeanServer mbs;

    public MBeanService(Agent a) {
        ComponentLookup lookup = a.getComponentLookup();
        lookup.addComponentNodeToLookup(lookup.getTopComponentNode(), new ComponentNode(lookup.getTopComponentNode(), "mbeanService", (Object)this));
    }

    @Override
    public void preInit() {
        try {
            this.mbs = ManagementFactory.getPlatformMBeanServer();
            this.log.info((Object)"MBean Server started successfully");
        }
        catch (Exception e) {
            this.log.severe((Object)"Failed to start JMX server.", (Throwable)e);
        }
    }

    public void registerMBean(Object obj, ObjectName objName) {
        try {
            this.mbs.registerMBean(obj, objName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

