/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Address;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Owner
implements Streamable {
    protected Address address;
    protected long thread_id;

    public Owner() {
    }

    public Owner(Address address, long thread_id) {
        this.address = address;
        this.thread_id = thread_id;
    }

    public Address getAddress() {
        return this.address;
    }

    public long getThreadId() {
        return this.thread_id;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Util.writeAddress(this.address, out);
        Bits.writeLong(this.thread_id, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.address = Util.readAddress(in);
        this.thread_id = Bits.readLong(in);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Owner other = (Owner)obj;
        return this.address.equals(other.address) && this.thread_id == other.thread_id;
    }

    public int hashCode() {
        return (int)((long)this.address.hashCode() + this.thread_id);
    }

    public String toString() {
        return this.address + "::" + this.thread_id;
    }
}

