/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.ConfigurableComponent;

public class PointListConfigurable
extends ConfigurableComponent {
    private final Map<String, Integer> currentParms = new HashMap<String, Integer>();
    private int min;
    private int max;
    @ConfigurationParameter(name="PointX", category="PointListConfig")
    private double PointX;
    @ConfigurationParameter(name="PointY", category="PointListConfig")
    private double PointY;
    @ConfigurationParameter(name="PointZ", category="PointListConfig")
    private double PointZ;
    final double MIN_X = 0.0;
    final double MAX_X = 300.0;
    final double MIN_Y = 0.0;
    final double MAX_Y = 300.0;
    final double MIN_Z = 0.0;
    final double MAX_Z = 200.0;

    public PointListConfigurable(double PointX, double PointY, double PointZ) {
        assert (PointX > 0.0);
        assert (PointX < 300.0);
        assert (PointY > 0.0);
        assert (PointY < 300.0);
        assert (PointZ > 0.0);
        assert (PointZ < 200.0);
        this.PointX = PointX;
        this.PointY = PointY;
        this.PointZ = PointZ;
    }

    @ConfigurationParameterChanger(propertyName="PointX")
    public void setPointX(Object PointX) {
        double val = (Double)PointX;
        assert (val > 0.0);
        assert (val < 300.0);
        System.out.println("configuring pointx to " + val);
        this.PointX = val;
    }

    @ConfigurationParameterChanger(propertyName="PointY")
    public void setPointY(Object PointY) {
        double val = (Double)PointY;
        assert (val > 0.0);
        assert (val < 300.0);
        System.out.println("configuring pointy to " + val);
        this.PointY = val;
    }

    @ConfigurationParameterChanger(propertyName="PointZ")
    public void setPointZ(Object PointZ) {
        double val = (Double)PointZ;
        assert (val > 0.0);
        assert (val < 200.0);
        System.out.println("configuring pointz to " + val);
        this.PointZ = val;
    }

    @ConfigurationParameterChanger
    public void setCurrentParms(Object currentParms) {
        Map map = (Map)currentParms;
        this.currentParms.putAll(map);
    }
}

