/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.IPlotter;
import hep.aida.IPlotterStyle;
import hep.aida.util.XMLUtils;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.metrology.AerotechDevice;
import org.lsst.ccs.subsystem.metrology.KeyenceDevice;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;
import org.lsst.ccs.subsystem.metrology.data.MetrologyFullState;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;
import org.lsst.ccs.subsystem.metrology.status.MetrologyStateStatus;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

public class MetrologySubSys
extends Module
implements Monitor.AlarmHandler,
StatusMessageListener,
AgentPresenceListener {
    Map<String, Device> devcMap;
    List<Device> devcList = new ArrayList<Device>();
    BitSet loLimChange = new BitSet();
    BitSet hiLimChange = new BitSet();
    BitSet goodChans = new BitSet();
    BitSet onlineChans = new BitSet();
    String stateCorrelId;
    MetrologyConfig metrologyc = new MetrologyConfig();
    private ConcurrentMessagingUtils cmu;
    private static final org.lsst.ccs.utilities.logging.Logger LOGGER = org.lsst.ccs.utilities.logging.Logger.getLogger((String)"org.lsst.ccs.subsystem.metrology.main");
    private static final String METROLOGY_DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
    private String teststand_dest = "ts2";
    private String ts8_dest = "ts8";
    String configName = "test";
    int state = 0;
    boolean last_systemOK = true;
    int nwarn = 0;
    double last_vac = 0.0;
    int disp_mode = 0;
    Monitor mon;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    AerotechDevice aeroDevc;
    KeyenceDevice keyDevc;
    IDataPointSetFactory dpsf;
    IHistogramFactory cf;
    IAnalysisFactory af = IAnalysisFactory.create();
    List<Double> plot_posx = new ArrayList<Double>();
    List<Double> plot_posy = new ArrayList<Double>();
    List<Double> plot_posz = new ArrayList<Double>();
    private long lastWarningTMillis = 0L;
    private long warningInterval = 240000L;
    private String lastWarning = "";
    private boolean abort_action = false;
    private double last_temp_a = -999.0;
    private double last_temp_b = -999.0;
    private double last_temp_c = -999.0;
    private double last_temp_d = -999.0;
    private boolean got_reb_temps = false;
    private double last_vqmpressure = -999.0;
    private double last_reb0ccdtemp = -999.0;
    private double last_reb1ccdtemp = -999.0;
    private double last_reb2ccdtemp = -999.0;
    ConfigurationInfo configInfo = null;

    public MetrologySubSys(String name, int tickMillis, String configName) {
        super(name, tickMillis);
        this.configName = configName;
    }

    @Command(type=Command.CommandType.ACTION, description="reinit devices")
    public void reinit() {
        this.mon.initSensors();
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scan() throws DriverException, InterruptedException, ExecutionException {
        this.scanfl("/home/ts5prod/Metrology_Scan_Data.csv");
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region to the specified file")
    public void scanfl(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename) throws DriverException, InterruptedException, ExecutionException {
        this.configInfo = ((ConfigurableSubsystem)super.getSubsystem()).getConfigurationInfo();
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.scan(filename, Double.parseDouble((String)configForComponent.get("startx")), Double.parseDouble((String)configForComponent.get("stopx")), Double.parseDouble((String)configForComponent.get("dx")), Double.parseDouble((String)configForComponent.get("starty")), Double.parseDouble((String)configForComponent.get("stopy")), Double.parseDouble((String)configForComponent.get("dy")), Double.parseDouble((String)configForComponent.get("z")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="startx", description="x start position") double startx, @Argument(name="stopx", description="x stop position") double stopx, @Argument(name="dx", description="x step size") double dx, @Argument(name="starty", description="y start position") double starty, @Argument(name="stopy", description="y stop position") double stopy, @Argument(name="dy", description="y step size") double dy, @Argument(name="z", description="z position") double z) throws DriverException, InterruptedException, ExecutionException {
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.scan(filename, startx, stopx, dx, starty, stopy, dy, z, Double.parseDouble((String)configForComponent.get("speed")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="startx", description="x start position") double startx, @Argument(name="stopx", description="x stop position") double stopx, @Argument(name="dx", description="x step size") double dx, @Argument(name="starty", description="y start position") double starty, @Argument(name="stopy", description="y stop position") double stopy, @Argument(name="dy", description="y step size") double dy, @Argument(name="dy", description="z position") double z, @Argument(name="speed", description="speed") double speed) throws DriverException, InterruptedException, ExecutionException {
        FileWriter fstream = null;
        File pdFl = null;
        BufferedWriter out = null;
        LOGGER.info((Object)("Scan requested with parameters:\n x: " + startx + "mm ->" + stopx + "mm  in steps of " + dx + "mm \n y: " + starty + "mm ->" + stopy + "mm  in steps of " + dy + "mm \n output to: " + filename));
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.SCANNING.ordinal());
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.aeroDevc.moveAbs_z(z);
        double accel = Double.parseDouble((String)configForComponent.get("acceleration"));
        int nsamps = Integer.decode((String)configForComponent.get("nsamples"));
        int measmode = Integer.decode((String)configForComponent.get("measmode"));
        LOGGER.info((Object)("Setting the acceleration to " + accel));
        this.aeroDevc.rampRate(accel);
        LOGGER.info((Object)("Setting the speed to " + speed));
        this.aeroDevc.setSpeed(speed);
        this.keyDevc.commmode();
        LOGGER.info((Object)("Setting cycle mode to " + nsamps));
        this.keyDevc.setcycles(nsamps);
        LOGGER.info((Object)("Setting surface measurement mode to " + measmode));
        this.keyDevc.setmeasmode(measmode);
        this.keyDevc.genmode();
        this.plot_posx.clear();
        this.plot_posy.clear();
        this.plot_posz.clear();
        if (filename != "") {
            pdFl = new File(filename);
            try {
                if (pdFl.exists()) {
                    LOGGER.error((Object)"File already exists!!! ABORTING!");
                    return;
                }
                pdFl.createNewFile();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to create file (" + filename + ") for reason " + e));
            }
            try {
                fstream = new FileWriter(pdFl);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
            }
            try {
                if (fstream != null) {
                    out = new BufferedWriter(fstream);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to open buffered writer stream for file (" + filename + ") for reason " + e));
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# filename: " + filename + "\n# start time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n#  x: " + startx + "mm ->" + stopx + "mm  in steps of " + dx + "mm \n#  y: " + starty + "mm ->" + stopy + "mm  in steps of " + dy + "mm \n#  z: " + z + "mm \n#  speed: " + speed + "\n#  acceleration: " + accel + "\n#  cycle mode: " + nsamps + "\n#  measurement mode: " + measmode + "\n#  displacement summing mode: " + MetrologyConfig.Displacement_Summing_Modes.values()[this.disp_mode] + "\n# #######################################################################\n");
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
            }
            int i = 0;
            double y = starty;
            for (double x = startx; x <= stopx; x += dx) {
                while (y >= starty && y <= stopy && !this.abort_action) {
                    this.aeroDevc.moveAbs_xy(x, y);
                    this.Sleep(0.2);
                    double[] disps = this.keyDevc.readAll();
                    double displacement = -999.0;
                    if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.NormalDispSum.ordinal()) {
                        if (disps[0] > -900.0 && disps[1] > -900.0) {
                            displacement = disps[1] + disps[0];
                        }
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead1Only.ordinal()) {
                        displacement = disps[0];
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead2Only.ordinal()) {
                        displacement = disps[1];
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementDiff.ordinal()) {
                        if (disps[0] > -900.0 && disps[1] > -900.0) {
                            displacement = disps[1] - disps[0];
                        }
                    } else {
                        LOGGER.error((Object)"BAD disp_mode!");
                    }
                    double xmeas = Double.NaN;
                    double ymeas = Double.NaN;
                    double zmeas = Double.NaN;
                    while (Double.isNaN(xmeas) || Double.isNaN(ymeas) || Double.isNaN(zmeas)) {
                        double[] p = this.aeroDevc.getPos_xyz();
                        xmeas = p[0];
                        ymeas = p[1];
                        zmeas = p[2];
                        System.out.println("Waiting for position information to become available.");
                    }
                    this.Sleep(0.2);
                    System.out.println("x= " + x + " y= " + y + " displacement= " + displacement + " xmeas= " + xmeas + " ymeas= " + ymeas + " disp1= " + disps[0] + " disp2= " + disps[1] + " z= " + z + " zmeas= " + zmeas + " temp_a= " + this.last_temp_a + " temp_b= " + this.last_temp_b + " temp_c= " + this.last_temp_c + " temp_d= " + this.last_temp_d + " vqmpressure= " + this.last_vqmpressure + " tstamp= " + Long.toString(System.currentTimeMillis()));
                    if (displacement > -900.0) {
                        this.plot_posx.add(xmeas);
                        this.plot_posy.add(ymeas);
                        this.plot_posz.add(displacement);
                        if (out != null) {
                            String line = null;
                            line = x + "," + y + "," + displacement + "," + xmeas + "," + ymeas + "," + disps[0] + "," + disps[1] + "," + z + "," + zmeas + "," + this.last_temp_a + "," + this.last_temp_b + "," + this.last_temp_c + "," + this.last_temp_d + "," + this.last_vqmpressure + "," + Long.toString(System.currentTimeMillis());
                            try {
                                out.write(line);
                                out.newLine();
                                out.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++i;
                    y += dy;
                }
                dy = -dy;
                y += dy;
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# end time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n");
                    out.close();
                    if (System.getenv("HOSTNAME").contains("ts5.inst.bnl")) {
                        Runtime r = Runtime.getRuntime();
                        try {
                            LOGGER.warning((Object)"Copying scan data to BNL astro GPFS");
                            Process p1 = r.exec("scp -rp " + filename + " ccdtest@astroracf:/gpfs01/astro/workarea/ccdtest/ts5/DATA/");
                            LOGGER.warning((Object)("The scan has been copied to: /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]));
                            Process process = r.exec("ssh ccdtest@astroracf ls -l /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]);
                        }
                        catch (IOException ex) {
                            LOGGER.error((Object)("Scan copy failed with error " + ex));
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to close file!");
                }
            }
            if (!this.abort_action) {
                this.plotscan(180.0, 80.0, 90.0);
            }
        }
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
        this.abort_action = false;
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scanPL(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename) throws DriverException, InterruptedException, ExecutionException {
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.scanPL(filename, Double.parseDouble((String)configForComponent.get("speed")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void scanPL(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="speed", description="speed") double speed) throws DriverException, InterruptedException, ExecutionException {
        FileWriter fstream = null;
        File pdFl = null;
        BufferedWriter out = null;
        LOGGER.info((Object)("Point List Scan requested with parameters:\n output to: " + filename));
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.SCANNING.ordinal());
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        double accel = Double.parseDouble((String)configForComponent.get("acceleration"));
        int nsamps = Integer.decode((String)configForComponent.get("nsamples"));
        int measmode = Integer.decode((String)configForComponent.get("measmode"));
        LOGGER.info((Object)("Setting the acceleration to " + accel));
        this.aeroDevc.rampRate(accel);
        LOGGER.info((Object)("Setting the speed to " + speed));
        this.aeroDevc.setSpeed(speed);
        double z = this.aeroDevc.getLastPos_z();
        this.keyDevc.commmode();
        LOGGER.info((Object)("Setting cycle mode to " + nsamps));
        this.keyDevc.setcycles(nsamps);
        LOGGER.info((Object)("Setting surface measurement mode to " + measmode));
        this.keyDevc.setmeasmode(measmode);
        this.keyDevc.genmode();
        this.plot_posx.clear();
        this.plot_posy.clear();
        this.plot_posz.clear();
        if (filename != "") {
            pdFl = new File(filename);
            try {
                if (pdFl.exists()) {
                    LOGGER.error((Object)"File already exists!!! ABORTING!");
                    return;
                }
                pdFl.createNewFile();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to create file (" + filename + ") for reason " + e));
            }
            try {
                fstream = new FileWriter(pdFl);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
            }
            try {
                if (fstream != null) {
                    out = new BufferedWriter(fstream);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to open buffered writer stream for file (" + filename + ") for reason " + e));
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# filename: " + filename + "\n# start time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n#  speed: " + speed + "\n#  acceleration: " + accel + "\n#  cycle mode: " + nsamps + "\n#  measurement mode: " + measmode + "\n#  displacement summing mode: " + MetrologyConfig.Displacement_Summing_Modes.values()[this.disp_mode] + "\n# #######################################################################\n");
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
            }
            int i = 0;
            for (MetrologyConfig.pointset_states componentState : MetrologyConfig.pointset_states.values()) {
                String componentName = componentState.name();
                Map PSconfigForComponent = this.configInfo.getCurrentValuesFor(componentName);
                double PointX = Double.parseDouble((String)PSconfigForComponent.get("PointX"));
                double PointY = Double.parseDouble((String)PSconfigForComponent.get("PointY"));
                double PointZ = Double.parseDouble((String)PSconfigForComponent.get("PointZ"));
                if (this.abort_action) break;
                if (PointX < -900.0 || PointY < -900.0 || PointZ < -900.0) continue;
                this.aeroDevc.moveAbs_xyz(PointX, PointY, PointZ);
                this.Sleep(0.2);
                double[] disps = this.keyDevc.readAll();
                double displacement = -999.0;
                if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.NormalDispSum.ordinal()) {
                    if (disps[0] > -900.0 && disps[1] > -900.0) {
                        displacement = disps[1] + disps[0];
                    }
                } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead1Only.ordinal()) {
                    displacement = disps[0];
                } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead2Only.ordinal()) {
                    displacement = disps[1];
                } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementDiff.ordinal()) {
                    if (disps[0] > -900.0 && disps[1] > -900.0) {
                        displacement = disps[1] - disps[0];
                    }
                } else {
                    LOGGER.error((Object)"BAD disp_mode!");
                }
                double xmeas = Double.NaN;
                double ymeas = Double.NaN;
                double zmeas = Double.NaN;
                while (Double.isNaN(xmeas) || Double.isNaN(ymeas) || Double.isNaN(zmeas)) {
                    double[] p = this.aeroDevc.getPos_xyz();
                    xmeas = p[0];
                    ymeas = p[1];
                    zmeas = p[2];
                    System.out.println("Waiting for position information to become available.");
                }
                this.Sleep(0.2);
                System.out.println("x= " + PointX + " y= " + PointY + " displacement= " + displacement + " xmeas= " + xmeas + " ymeas= " + ymeas + " disp1= " + disps[0] + " disp2= " + disps[1] + " z= " + PointZ + " zmeas= " + zmeas + " temp_a= " + this.last_temp_a + " temp_b= " + this.last_temp_b + " temp_c= " + this.last_temp_c + " temp_d= " + this.last_temp_d + " vqmpressure= " + this.last_vqmpressure + " tstamp= " + Long.toString(System.currentTimeMillis()));
                if (displacement > -900.0) {
                    this.plot_posx.add(xmeas);
                    this.plot_posy.add(ymeas);
                    this.plot_posz.add(displacement);
                    if (out != null) {
                        String line = null;
                        line = PointX + "," + PointY + "," + displacement + "," + xmeas + "," + ymeas + "," + disps[0] + "," + disps[1] + "," + PointZ + "," + zmeas + "," + this.last_temp_a + "," + this.last_temp_b + "," + this.last_temp_c + "," + this.last_temp_d + "," + this.last_vqmpressure + "," + Long.toString(System.currentTimeMillis());
                        try {
                            out.write(line);
                            out.newLine();
                            out.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# end time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n");
                    out.close();
                    if (System.getenv("HOSTNAME").contains("ts5.inst.bnl")) {
                        Runtime r = Runtime.getRuntime();
                        try {
                            LOGGER.warning((Object)"Copying scan data to BNL astro GPFS");
                            Process p1 = r.exec("scp -rp " + filename + " ccdtest@astroracf:/gpfs01/astro/workarea/ccdtest/ts5/DATA/");
                            LOGGER.warning((Object)("The scan has been copied to: /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]));
                            Process process = r.exec("ssh ccdtest@astroracf ls -l /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]);
                        }
                        catch (IOException ex) {
                            LOGGER.error((Object)("Scan copy failed with error " + ex));
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to close file!");
                }
            }
        }
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
        this.abort_action = false;
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void noStepScan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename) throws DriverException, InterruptedException, ExecutionException {
        this.configInfo = ((ConfigurableSubsystem)super.getSubsystem()).getConfigurationInfo();
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.noStepScan(filename, Double.parseDouble((String)configForComponent.get("startx")), Double.parseDouble((String)configForComponent.get("stopx")), Double.parseDouble((String)configForComponent.get("dx")), Double.parseDouble((String)configForComponent.get("starty")), Double.parseDouble((String)configForComponent.get("stopy")), Double.parseDouble((String)configForComponent.get("dy")), Double.parseDouble((String)configForComponent.get("z")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void noStepScan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="startx", description="x start position") double startx, @Argument(name="stopx", description="x stop position") double stopx, @Argument(name="dx", description="x step size") double dx, @Argument(name="starty", description="y start position") double starty, @Argument(name="stopy", description="y stop position") double stopy, @Argument(name="dy", description="y step size") double dy, @Argument(name="z", description="z position") double z) throws DriverException, InterruptedException, ExecutionException {
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.noStepScan(filename, startx, stopx, dx, starty, stopy, dy, z, Double.parseDouble((String)configForComponent.get("speed")));
    }

    @Command(type=Command.CommandType.QUERY, description="scan a region")
    public void noStepScan(@Argument(name="filename", description="filename for storing measurement (.csv)") String filename, @Argument(name="startx", description="x start position") double startx, @Argument(name="stopx", description="x stop position") double stopx, @Argument(name="dx", description="x step size") double dx, @Argument(name="starty", description="y start position") double starty, @Argument(name="stopy", description="y stop position") double stopy, @Argument(name="dy", description="y step size") double dy, @Argument(name="z", description="z position") double z, @Argument(name="speed", description="speed") double speed) throws DriverException, InterruptedException, ExecutionException {
        FileWriter fstream = null;
        File pdFl = null;
        BufferedWriter out = null;
        LOGGER.info((Object)("Scan requested with parameters:\n x: " + startx + "mm -> " + stopx + "mm  in steps of " + dx + "mm \n y: " + starty + "mm -> " + stopy + "mm  in steps of " + dy + "mm \n output to: " + filename));
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.SCANNING.ordinal());
        Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
        this.aeroDevc.moveAbs_z(z);
        double accel = Double.parseDouble((String)configForComponent.get("acceleration"));
        int nsamps = Integer.decode((String)configForComponent.get("nsamples"));
        int measmode = Integer.decode((String)configForComponent.get("measmode"));
        LOGGER.info((Object)("Setting the acceleration to " + accel));
        this.aeroDevc.rampRate(accel);
        LOGGER.info((Object)("Setting the speed to " + speed));
        this.aeroDevc.setSpeed(speed);
        this.keyDevc.commmode();
        LOGGER.info((Object)("Setting cycle mode to " + nsamps));
        this.keyDevc.setcycles(nsamps);
        LOGGER.info((Object)("Setting surface measurement mode to " + measmode));
        this.keyDevc.setmeasmode(measmode);
        this.keyDevc.genmode();
        this.plot_posx.clear();
        this.plot_posy.clear();
        this.plot_posz.clear();
        if (filename != "") {
            pdFl = new File(filename);
            try {
                if (pdFl.exists()) {
                    pdFl.delete();
                }
                pdFl.createNewFile();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to create file (" + filename + ") for reason " + e));
            }
            try {
                fstream = new FileWriter(pdFl);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
            }
            try {
                if (fstream != null) {
                    out = new BufferedWriter(fstream);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to open buffered writer stream for file (" + filename + ") for reason " + e));
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# filename: " + filename + "\n# start time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n#  x: " + startx + "mm ->" + stopx + "mm  in steps of " + dx + "mm \n#  y: " + starty + "mm ->" + stopy + "mm  in steps of " + dy + "mm \n#  z: " + z + "mm \n#  speed: " + speed + "\n#  acceleration: " + accel + "\n#  cycle mode: " + nsamps + "\n#  measurement mode: " + measmode + "\n#  displacement summing mode: " + MetrologyConfig.Displacement_Summing_Modes.values()[this.disp_mode] + "\n# #######################################################################\n");
                }
                catch (IOException ex) {
                    LOGGER.error((Object)ex);
                }
            }
            if (!this.abort_action) {
                this.aeroDevc.moveAbs_xy(startx, starty);
            }
            double preScanStartTime_fwd = System.currentTimeMillis();
            this.aeroDevc.moveAbs_xy(startx, stopy);
            double preScanStopTime_fwd = System.currentTimeMillis();
            if (!this.abort_action) {
                this.aeroDevc.moveAbs_xy(stopx, stopy);
            }
            double preScanStartTime_bwd = System.currentTimeMillis();
            if (!this.abort_action) {
                this.aeroDevc.moveAbs_xy(stopx, starty);
            }
            double preScanStopTime_bwd = System.currentTimeMillis();
            if (!this.abort_action) {
                this.aeroDevc.moveAbs_xy(startx, starty);
            }
            final double tm_starty = starty;
            final double tm_stopy = stopy;
            if (this.abort_action) {
                return;
            }
            int i = 0;
            double y = starty;
            block14: for (double x = startx; x <= stopx; x += dx) {
                String msg;
                final double tm_x = x;
                final double tm_dy = dy;
                if (tm_dy > 0.0) {
                    msg = "move to scan line start point x,y = " + tm_x + " ," + tm_starty;
                    LOGGER.info((Object)msg);
                    System.out.println(msg);
                    if (!this.abort_action) {
                        this.aeroDevc.moveAbs_xy(tm_x, tm_starty);
                    }
                } else {
                    msg = "move to scan line start point x,y = " + tm_x + " ," + tm_stopy;
                    LOGGER.info((Object)msg);
                    System.out.println(msg);
                    if (!this.abort_action) {
                        this.aeroDevc.moveAbs_xy(tm_x, tm_stopy);
                    }
                }
                double xmeas = Double.NaN;
                double ymeas = Double.NaN;
                double zmeas = Double.NaN;
                while (Double.isNaN(xmeas) || Double.isNaN(ymeas) || Double.isNaN(zmeas)) {
                    double[] p = this.aeroDevc.getPos_xyz();
                    xmeas = p[0];
                    ymeas = p[1];
                    zmeas = p[2];
                    System.out.println("Waiting for position information to become available.");
                }
                this.Sleep(0.2);
                long runStartTime = System.currentTimeMillis();
                System.out.println("Y-runStartTime = " + runStartTime);
                System.out.println("Starting move to other endpoint.");
                Runnable tmove = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (tm_dy > 0.0) {
                                String msg = "thread move started to x,y" + tm_x + " ," + tm_stopy;
                                LOGGER.info((Object)msg);
                                System.out.println(msg);
                                MetrologySubSys.this.aeroDevc.moveAbs_xy(tm_x, tm_stopy);
                            } else {
                                String msg = "thread move started to x,y" + tm_x + " ," + tm_starty;
                                LOGGER.info((Object)msg);
                                System.out.println(msg);
                                MetrologySubSys.this.aeroDevc.moveAbs_xy(tm_x, tm_starty);
                            }
                            LOGGER.info((Object)"move thread terminated");
                            System.out.println("move thread terminated");
                        }
                        catch (DriverException e) {
                            LOGGER.error((Object)"driver exception in tmove queue", (Throwable)e);
                        }
                    }
                };
                Thread motion = new Thread(tmove);
                if (!this.abort_action) {
                    motion.start();
                }
                while (y >= starty && y <= stopy) {
                    long timeMark = dy > 0.0 ? (long)((y - starty) / (stopy - starty) * (preScanStopTime_fwd - preScanStartTime_fwd) + (double)runStartTime) : (long)((y - stopy) / (starty - stopy) * (preScanStopTime_bwd - preScanStartTime_bwd) + (double)runStartTime);
                    System.out.println("next timeMark is " + timeMark);
                    if (this.abort_action) {
                        motion.interrupt();
                        continue block14;
                    }
                    System.out.print("waiting for time to make next read");
                    while (System.currentTimeMillis() < timeMark) {
                    }
                    long time_before_key = System.currentTimeMillis();
                    double[] disps = this.keyDevc.readAll();
                    long time_after_key = System.currentTimeMillis();
                    double displacement = -999.0;
                    if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.NormalDispSum.ordinal()) {
                        if (disps[0] > -900.0 && disps[1] > -900.0) {
                            displacement = disps[1] + disps[0];
                        }
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead1Only.ordinal()) {
                        displacement = disps[0];
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementHead2Only.ordinal()) {
                        displacement = disps[1];
                    } else if (this.disp_mode == MetrologyConfig.Displacement_Summing_Modes.DisplacementDiff.ordinal()) {
                        if (disps[0] > -900.0 && disps[1] > -900.0) {
                            displacement = disps[1] - disps[0];
                        }
                    } else {
                        LOGGER.error((Object)"BAD disp_mode!");
                    }
                    double actual_time = time_before_key;
                    ymeas = dy > 0.0 ? (actual_time - (double)runStartTime) / (preScanStopTime_fwd - preScanStartTime_fwd) * (stopy - starty) + starty : (actual_time - (double)runStartTime) / (preScanStopTime_bwd - preScanStartTime_bwd) * (starty - stopy) + stopy;
                    System.out.println("x= " + x + " y= " + y + " displacement= " + displacement + " xmeas= " + xmeas + " ymeas= " + ymeas + " disp1= " + disps[0] + " disp2= " + disps[1] + " z= " + z + " zmeas= " + zmeas + " temp_a= " + this.last_temp_a + " temp_b= " + this.last_temp_b + " temp_c= " + this.last_temp_c + " temp_d= " + this.last_temp_d + " vqmpressure= " + this.last_vqmpressure + " tstamp= " + Long.toString((long)actual_time));
                    if (displacement > -900.0) {
                        this.plot_posx.add(xmeas);
                        this.plot_posy.add(ymeas);
                        this.plot_posz.add(displacement);
                        if (out != null) {
                            String line = x + "," + y + "," + displacement + "," + xmeas + "," + ymeas + "," + disps[0] + "," + disps[1] + "," + z + "," + zmeas + "," + this.last_temp_a + "," + this.last_temp_b + "," + this.last_temp_c + "," + this.last_temp_d + "," + this.last_vqmpressure + "," + Long.toString((long)actual_time);
                            try {
                                out.write(line);
                                out.newLine();
                                out.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++i;
                    y += dy;
                }
            }
            if (out != null) {
                try {
                    out.write("# #######################################################################\n# end time: " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "\n");
                    out.close();
                    if (System.getenv("HOSTNAME").contains("ts5.inst.bnl")) {
                        Runtime r = Runtime.getRuntime();
                        try {
                            LOGGER.warning((Object)"Copying scan data to BNL astro GPFS");
                            Process p1 = r.exec("scp -rp " + filename + " ccdtest@astroracf:/gpfs01/astro/workarea/ccdtest/ts5/DATA/");
                            LOGGER.warning((Object)("The scan has been copied to: /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]));
                            Process process = r.exec("ssh ccdtest@astroracf ls -l /gpfs01/astro/workarea/ccdtest/ts5/DATA/" + filename.split("/")[filename.split("/").length - 1]);
                        }
                        catch (IOException ex) {
                            LOGGER.error((Object)("Scan copy failed with error " + ex));
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to close file!");
                }
            }
            if (!this.abort_action) {
                this.plotscan(180.0, 80.0, 90.0);
            }
        }
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
        this.abort_action = false;
    }

    @Command(type=Command.CommandType.QUERY, description="do repeated measurements at the same positions")
    public void doreps(@Argument(name="filename", description="filename for storing measurement ") String filename, @Argument(name="nreps", description="number of repetitions") int nreps, @Argument(name="period", description="period in seconds") double period) throws DriverException {
        FileWriter fstream = null;
        File pdFl = null;
        BufferedWriter out = null;
        LOGGER.info((Object)("Reps requested with parameters:\n nreps: " + nreps + "\n period:" + period + "\n output to: " + filename));
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.SCANNING.ordinal());
        if (filename != "") {
            pdFl = new File(filename);
            try {
                if (pdFl.exists()) {
                    pdFl.delete();
                }
                pdFl.createNewFile();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to create file (" + filename + ") for reason " + e));
            }
            try {
                fstream = new FileWriter(pdFl);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
            }
            try {
                if (fstream != null) {
                    out = new BufferedWriter(fstream);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to open buffered writer stream for file (" + filename + ") for reason " + e));
            }
            for (int i = 0; i < nreps && !this.abort_action; ++i) {
                double[] disps = this.keyDevc.readAll();
                double displacement = disps[1] + disps[0];
                double[] p = this.aeroDevc.getPos_xyz();
                this.Sleep(period);
                if (out == null) continue;
                String line = null;
                line = i + "," + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + "," + p[0] + "," + p[1] + "," + p[2] + "," + disps[0] + "," + disps[1] + "," + displacement;
                try {
                    out.write(line);
                    out.newLine();
                    out.flush();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to close file!");
                }
            }
        }
        this.abort_action = false;
        this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
    }

    @Command(description="plot the scan data")
    public void plotscan() throws DriverException {
        this.plotscan(80.0, 180.0, 90.0);
    }

    @Command(description="abort motion")
    public void abortMotion() throws DriverException {
        LOGGER.error((Object)"SETTING ABORT ACTION TRUE!");
        this.abort_action = true;
        LOGGER.error((Object)"SENDING ABORT COMMAND TO AEROTECH!");
        this.aeroDevc.abort();
        LOGGER.error((Object)"DISABLING AXES!");
        this.aeroDevc.disableAxes();
        LOGGER.error((Object)"ABORTING ANY ACTIVE SCRIPT!");
        this.sendSyncMetrologyCommand("abortInterpreter", "ts");
    }

    protected Object sendSyncMetrologyCommand(String name, Object ... params) {
        try {
            return this.cmu.sendSynchronousCommand(new CommandRequest(METROLOGY_DEST, name), Duration.ofMillis(30000L));
        }
        catch (Exception e) {
            LOGGER.warning((Object)("Unable to perform jgroup communication with destination + " + METROLOGY_DEST + " - Exception " + e));
            return null;
        }
    }

    @Command(description="plot the scan data")
    public void plotscan(@Argument(name="rotation_x", description="rotation about the x axis") double rotx, @Argument(name="rotation_y", description="rotation about the y axis") double roty, @Argument(name="rotation_z", description="rotation about the z axis") double rotz) throws DriverException {
        double rotation_xaxis = rotx / 180.0 * Math.PI;
        double rotation_yaxis = roty / 180.0 * Math.PI;
        double rotation_zaxis = rotz / 180.0 * Math.PI;
        LOGGER.info((Object)"doing new aidaplots");
        KeyValueDataList plots = new KeyValueDataList();
        LOGGER.info((Object)"declaring pdthst");
        IDataPointSet pdthst = this.dpsf.create("FlatnessScan", "TS5 Surface Scan - Date:" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())), 2);
        Iterator<Double> posy = this.plot_posy.iterator();
        Iterator<Double> posz = this.plot_posz.iterator();
        LOGGER.info((Object)"starting iteration over data points");
        for (double x : this.plot_posx) {
            double y = posy.next();
            double z = posz.next();
            LOGGER.info((Object)("plotscan: " + x + " , " + y + " , " + z));
            IDataPoint point = pdthst.addPoint();
            double x1 = Math.cos(rotation_yaxis) * x + Math.sin(rotation_yaxis) * z;
            double y1 = y;
            double z1 = -Math.sin(rotation_yaxis) * x + Math.cos(rotation_yaxis) * z;
            double x2 = Math.cos(rotation_zaxis) * x1 + Math.sin(rotation_zaxis) * y1;
            double y2 = -Math.sin(rotation_zaxis) * x1 + Math.cos(rotation_zaxis) * y1;
            double z2 = z1;
            double vx = x2;
            double vy = Math.cos(rotation_xaxis) * y2 + Math.sin(rotation_xaxis) * z2;
            double vz = -Math.sin(rotation_xaxis) * y2 + Math.cos(rotation_xaxis) * z2;
            LOGGER.info((Object)"setting coordinates");
            point.coordinate(0).setValue(vx);
            point.coordinate(0).setErrorPlus(0.0);
            point.coordinate(1).setValue(vy);
            point.coordinate(1).setErrorPlus(0.0);
            point.coordinate(1).setErrorMinus(0.0);
            LOGGER.info((Object)("added rotated point: " + vx + " , " + vy + " , " + vz));
        }
        try {
            pdthst.setTitle("Flatness Plot");
            LOGGER.info((Object)"doing new addplots");
            plots.addData("surface", (Serializable)((Object)XMLUtils.createXMLString((IManagedObject)((IManagedObject)pdthst))));
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Unable to create XML rep of AidaPlot object!", (Throwable)ex);
        }
        IPlotter plotter = this.af.createPlotterFactory().create("Plot IDataPointSets");
        plotter.createRegions(1, 1);
        IPlotterStyle regionStyle = plotter.region(0).style();
        plotter.region(0).plot(pdthst);
        regionStyle.dataStyle().lineStyle().setParameter("setOpacity", "0.0");
        LOGGER.info((Object)"publishing plot");
        KeyValueData kd = new KeyValueData("ScanPlots", (Serializable)plots);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kd);
    }

    public void initModule() {
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, LOGGER);
        LOGGER.error((Object)"Performing mon.initConfiguration");
        this.mon.initConfiguration();
        this.aeroDevc = (AerotechDevice)this.mon.getDevice("Positioner");
        this.keyDevc = (KeyenceDevice)this.mon.getDevice("Measurer");
        LOGGER.error((Object)"calling initSensors");
        this.mon.initSensors();
        LOGGER.error((Object)"completed calling initSensors");
        try {
            this.startSubSys();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error starting Aerotech subsystem: " + e));
        }
        try {
            this.metrologyc.setOperatingState(MetrologyConfig.operating_states.IDLE.ordinal());
        }
        catch (Exception ee) {
            LOGGER.error((Object)"Exception while setting state flags:", (Throwable)ee);
        }
        this.mon.start();
        LOGGER.info((Object)"Monitoring started.");
        super.startTicking();
        LOGGER.info((Object)"Ticking started.");
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        this.dpsf = this.af.createDataPointSetFactory(null);
        this.cf = this.af.createHistogramFactory(null);
        LOGGER.info((Object)"DPSF and Cloud Factory started.");
        try {
            LOGGER.info((Object)"Enabling Aerotech axes");
            this.aeroDevc.enableAxes();
        }
        catch (DriverException ex) {
            Logger.getLogger(MetrologySubSys.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.keyDevc.commmode();
            this.keyDevc.setmindispunit(2);
            this.keyDevc.genmode();
        }
        catch (DriverException ex) {
            Logger.getLogger(MetrologySubSys.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        this.state |= 2;
    }

    public void start() {
        Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.teststand_dest).or(BusMessageFilterFactory.messageOrigin((String)this.ts8_dest)).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        this.getSubsystem().getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, filter);
    }

    public void tick() {
        System.out.print(".");
        if ((this.state & 0x10) != 0) {
            System.exit(0);
        }
        this.publishState();
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    public void processAlarm(int event, int parm) {
        String alarm_ev = null;
        switch (event) {
            case 0: {
                alarm_ev = "TRIP";
                break;
            }
            case 2: {
                alarm_ev = "RESET";
                break;
            }
            default: {
                alarm_ev = "Unknown";
            }
        }
        LOGGER.error((Object)("Received alarm for " + alarm_ev + " event, where trip=" + 0 + " and reset=" + 2));
        LOGGER.error((Object)("Alarm is from " + MetrologyConfig.EVENT_ID.values()[parm]));
    }

    @Command(name="soundAlarm")
    public void soundAlarm() {
        Runtime r = Runtime.getRuntime();
        try {
            LOGGER.error((Object)("Sending warning sound as requested by " + super.getName()));
            Process process = r.exec("./make-warning-sound");
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to exec shell command to send warning sound " + ex));
        }
    }

    @Command(name="soundBleep")
    public void soundBleep() {
        Runtime r = Runtime.getRuntime();
        try {
            LOGGER.severe((Object)("Sending bleep sound as requested by " + super.getName()));
            Process process = r.exec("./make-bleep-sound");
        }
        catch (IOException ex) {
            LOGGER.severe((Object)("Failed to exec shell command to send bleep sound " + ex));
        }
    }

    @Command(name="resetTrip", description="reset trips etc...")
    public void resetTrip() {
    }

    @Command(type=Command.CommandType.ACTION, description="Start the metrology subsystem")
    public void startSubSys() throws Exception {
        this.state |= 1;
        LOGGER.info((Object)"Starting Metrology SubSystem.");
        Object param = null;
        this.configInfo = ((ConfigurableSubsystem)super.getSubsystem()).getConfigurationInfo();
        this.cmu = new ConcurrentMessagingUtils(this.getSubsystem().getMessagingAccess());
        this.state |= 0x400;
        this.publishState();
    }

    @Command(name="stopsubsys", type=Command.CommandType.ACTION, description="Stop and set the Aerotech sub system into the ready state")
    public void stopSubSys() {
        LOGGER.info((Object)"Stop Sub System called.");
        this.state &= 0xFFFFFFFD;
        this.publishState();
        this.state |= 0x20;
        this.setTickMillis(0);
        this.publishState();
    }

    @Command(name="saveconfig", type=Command.CommandType.ACTION, description="Saves the current configuration")
    public void saveConfiguration() throws IOException {
        try {
            this.getEnvironment().saveAllChanges();
        }
        catch (ConfigurationServiceException ex) {
            LOGGER.warning((Object)("Failed to save all changes " + (Object)((Object)ex)));
        }
        this.mon.clearLimitChanges();
        this.mon.publishState();
        LOGGER.info((Object)"Saved configuration.");
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the full aerotech state")
    public MetrologyFullState getFullState() {
        MetrologyState metrologyState = new MetrologyState(this.state, this.metrologyc.getCfgstate(), this.getTickMillis(), 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0, 0.0, 0.0);
        MonitorFullState monState = this.mon.getFullState();
        return new MetrologyFullState(metrologyState, monState);
    }

    @Command(name="printfullstate", type=Command.CommandType.QUERY, description="Prints the full aerotech state")
    public String printFullState() {
        MetrologyState aerotechState = new MetrologyState(this.state, this.metrologyc.getCfgstate(), this.getTickMillis());
        MetrologyStateStatus aerotechs = new MetrologyStateStatus(aerotechState);
        return aerotechs.toString();
    }

    @Command(name="getstate", type=Command.CommandType.QUERY, description="Returns the current value of the TS state")
    public int getState() {
        return this.state;
    }

    @Command(description="Sets the configuration state.")
    public void setCfgState(int cstate) {
        LOGGER.info((Object)("Setting subsystem configuration state to " + MetrologyConfig.configuration_states.values()[cstate]));
        this.metrologyc.setCfgState(cstate);
    }

    @Command(description="Sets the configuration state.")
    public void setCfgStateByName(String selectedstate) {
        int cfgstate = MetrologyConfig.configuration_states.valueOf((String)selectedstate).ordinal();
        LOGGER.info((Object)("Setting subsystem configuration state to " + MetrologyConfig.configuration_states.values()[cfgstate]));
        this.metrologyc.setCfgState(cfgstate);
    }

    @Command(name="setstate", type=Command.CommandType.QUERY, description="sets the current value of the TS state")
    public void setState(int state) {
        this.state = state;
        this.publishState();
    }

    public void Sleep(double secs) {
        try {
            long millis = (long)(secs * 1000.0);
            LOGGER.info((Object)("Sleeping for " + millis + " millis"));
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            LOGGER.error((Object)("Rude awakening!" + ex));
        }
    }

    @Command(name="publishState", type=Command.CommandType.QUERY, description="publishes the Aerotech state")
    public void publishState() {
        LOGGER.info((Object)"Entering pubishState");
        System.out.println("publishing");
        MetrologyState metrologyState = new MetrologyState(this.state, this.metrologyc.getOperatingState(), this.getTickMillis());
        try {
            this.getDevStates(metrologyState);
        }
        catch (InterruptedException ex) {
            LOGGER.error((Object)ex);
        }
        catch (ExecutionException ex) {
            LOGGER.error((Object)ex);
        }
        KeyValueData kd = new KeyValueData("MetrologyState", (Serializable)metrologyState);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kd);
        LOGGER.info((Object)"published state");
        System.out.println("published");
    }

    void getDevStates(MetrologyState tst) throws InterruptedException, ExecutionException {
        try {
            if (this.aeroDevc != null) {
                double posx = Double.NaN;
                double posy = Double.NaN;
                double posz = Double.NaN;
                if (this.metrologyc.getOperatingState() != MetrologyConfig.operating_states.SCANNING.ordinal()) {
                    while (Double.isNaN(posx) || Double.isNaN(posy) || Double.isNaN(posz)) {
                        double[] p = this.aeroDevc.getPos_xyz();
                        posx = p[0];
                        posy = p[1];
                        posz = p[2];
                        System.out.println("Waiting for position information to become available.");
                        this.Sleep(0.2);
                    }
                } else {
                    posx = this.aeroDevc.getLastPos_x();
                    posy = this.aeroDevc.getLastPos_y();
                    posz = this.aeroDevc.getLastPos_z();
                }
                System.out.println("in getdevstates: pos = " + posx + " , " + posy + " , " + posz);
                tst.setPosx(posx);
                tst.setPosy(posy);
                tst.setPosz(posz);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve aerotech position for publishing!");
        }
        if (this.metrologyc.getOperatingState() != MetrologyConfig.operating_states.SCANNING.ordinal()) {
            try {
                if (this.keyDevc != null) {
                    tst.setDisplacement1(this.keyDevc.read(1));
                    tst.setDisplacement2(this.keyDevc.read(2));
                }
            }
            catch (Exception e) {
                LOGGER.debug((Object)"failed to retrieve Keyence displacement for publishing!");
            }
        } else {
            tst.setDisplacement1(this.keyDevc.getLast_read()[0]);
            tst.setDisplacement2(this.keyDevc.getLast_read()[1]);
        }
        try {
            Map configForComponent = this.configInfo.getCurrentValuesFor(MetrologyConfig.configuration_states.values()[this.metrologyc.getCfgstate()].name());
            double accel = Double.parseDouble((String)configForComponent.get("acceleration"));
            int nsamps = Integer.decode((String)configForComponent.get("nsamples"));
            int measmode = Integer.decode((String)configForComponent.get("measmode"));
            tst.setAcceleration(accel);
            tst.setNsamples(nsamps);
            tst.setMeasmode(measmode);
        }
        catch (NullPointerException ex) {
            LOGGER.error((Object)("Null Pointer Exception - config not ready: " + ex));
        }
    }

    org.lsst.ccs.utilities.logging.Logger getLogger() {
        return LOGGER;
    }

    void reportError(String cName, String pName, Object pValue) throws Exception {
        LOGGER.error((Object)("Invalid " + pName + " (" + pValue + ") for " + cName));
        throw new Exception();
    }

    boolean checkAlarm(int alarm) {
        LOGGER.error((Object)("checking alarm value = " + alarm));
        return alarm < 1;
    }

    Device getDevice(String name) {
        return this.devcMap.get(name);
    }

    void setOnline(BitSet mask, boolean online) {
        BitSet prevOnline = (BitSet)this.onlineChans.clone();
        if (online) {
            this.onlineChans.or(mask);
        } else {
            this.onlineChans.andNot(mask);
        }
        if (!this.onlineChans.equals(prevOnline)) {
            this.publishState();
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        block26: {
            try {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                KeyValueData msgObject = ssd.getSubsystemData();
                if (msgObject instanceof KeyValueDataList) {
                    for (KeyValueData d : (KeyValueDataList)msgObject) {
                        LOGGER.info((Object)("In onDataArrival method. KEY=" + d.getKey()));
                        switch (d.getKey()) {
                            case "temp_a": {
                                if (this.got_reb_temps) break;
                                this.last_temp_a = (Double)d.getValue();
                                break;
                            }
                            case "temp_b": {
                                if (this.got_reb_temps) break;
                                this.last_temp_b = (Double)d.getValue();
                                break;
                            }
                            case "temp_c": {
                                if (!this.got_reb_temps) {
                                    this.last_temp_c = (Double)d.getValue();
                                    break;
                                }
                                this.last_temp_d = (Double)d.getValue();
                                break;
                            }
                            case "temp_d": {
                                if (this.got_reb_temps) break;
                                this.last_temp_d = (Double)d.getValue();
                                break;
                            }
                            case "vqmpressure": {
                                this.last_vqmpressure = (Double)d.getValue();
                                break;
                            }
                            case "R00.Reb0.CCDTemp1": {
                                this.last_temp_a = (Double)d.getValue();
                                this.got_reb_temps = true;
                                break;
                            }
                            case "R00.Reb1.CCDTemp1": {
                                this.last_temp_b = (Double)d.getValue();
                                this.got_reb_temps = true;
                                break;
                            }
                            case "R00.Reb2.CCDTemp1": {
                                this.last_temp_c = (Double)d.getValue();
                                this.got_reb_temps = true;
                                break;
                            }
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                if (e.toString().contains("de-serializing")) break block26;
                LOGGER.info((Object)("Problem unpacking message:" + e));
            }
        }
        if (msg.getOriginAgentInfo().getName().equals(METROLOGY_DEST) && msg.getObject() instanceof ConfigurationInfo) {
            this.configInfo = (ConfigurationInfo)msg.getObject();
        }
    }

    public void connecting(AgentInfo agent) {
        if (agent.getName().equals(this.teststand_dest)) {
            LOGGER.info((Object)("Connecting to agent " + agent.getName()));
        }
    }

    public void disconnecting(AgentInfo agent) {
        LOGGER.warning((Object)("Disconnecting from agent " + agent.getName()));
    }

    @Command(type=Command.CommandType.QUERY, description="get displacememt summing mode")
    public int getDisp_mode() {
        return this.disp_mode;
    }

    @Command(type=Command.CommandType.QUERY, description="set displacememt summing mode")
    public void setDisp_mode(int disp_mode) {
        this.disp_mode = disp_mode;
    }
}

