/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalsim.ResistiveThermalLink;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalCapacitance;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalLink;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalSimElement;

public class ThermalCapacitanceLink
extends ThermalLink {
    ResistiveThermalLink resLeft;
    ResistiveThermalLink resRight;
    ThermalCapacitance cap;

    public ThermalCapacitanceLink(ThermalModel model, String name, double resistance, double capacitance) {
        super(model, name);
        this.resLeft = new ResistiveThermalLink(model, name + "_rl", resistance / 2.0);
        this.resRight = new ResistiveThermalLink(model, name + "_rr", resistance / 2.0);
        this.cap = new ThermalCapacitance(model, name + "_c", capacitance);
        this.resLeft.setRight(this.cap);
        this.resRight.setLeft(this.cap);
    }

    public void setTemperature(double t) {
        this.cap.setTemperature(t);
    }

    @Override
    public double getTemperature() {
        return this.cap.getTemperature();
    }

    @Override
    protected ThermalSimElement getActualLeft() {
        return this.resLeft;
    }

    @Override
    protected ThermalSimElement getActualRight() {
        return this.resRight;
    }

    @Override
    void setLeft(ThermalCapacitance left) {
        super.setLeft(left);
        this.resLeft.setLeft(left);
    }

    @Override
    void setRight(ThermalCapacitance right) {
        super.setRight(right);
        this.resRight.setRight(right);
    }

    @Override
    protected void thermalLoop(long dt) {
    }

    @Override
    public double power(double tLeft, double tRight) {
        return 0.0;
    }

    @Override
    protected String getExtraInfo() {
        return String.format(" c=%5.2f r=%5.2f", this.cap.thermalCap, this.resLeft.res * 2.0);
    }

    @Override
    public boolean isActive() {
        return false;
    }
}

