/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalsim;

import org.lsst.ccs.subsystem.common.thermalsim.ResistiveThermalLink;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalCapacitance;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalModel;
import org.lsst.ccs.subsystem.common.thermalsim.ThermalSimElement;

public class LumpedThermalCapacitanceLink
extends ThermalSimElement {
    int nParts;
    ThermalCapacitance[] caps;
    ResistiveThermalLink[] links;

    public LumpedThermalCapacitanceLink(ThermalModel model, String name, double resistance, double capacitance, int nParts) {
        super(model, name);
        this.nParts = nParts;
        this.caps = new ThermalCapacitance[nParts];
        this.links = new ResistiveThermalLink[nParts];
        for (int i = 0; i < nParts; ++i) {
            this.caps[i] = new ThermalCapacitance(model, name + "_c" + i, capacitance / (double)nParts);
            this.links[i] = new ResistiveThermalLink(model, name + "_r" + i, resistance / (double)nParts);
            this.links[i].setLeft(this.caps[i]);
            if (i <= 0) continue;
            this.links[i - 1].setRight(this.caps[i]);
        }
    }

    @Override
    protected ThermalSimElement getActualRight() {
        return this.links[this.nParts - 1];
    }

    @Override
    protected ThermalSimElement getActualLeft() {
        return this.caps[0];
    }

    @Override
    protected void thermalLoop(long dt) {
    }

    @Override
    public double getTemperature() {
        double t = 0.0;
        for (ThermalCapacitance c : this.caps) {
            t += c.getTemperature();
        }
        return t / (double)this.nParts;
    }

    public void setTemperature(double t) {
        for (ThermalCapacitance c : this.caps) {
            c.setTemperature(t);
        }
    }

    @Override
    protected String getExtraInfo() {
        return String.format(" c=%5.2f r=%5.2f n=%3d", this.caps[0].thermalCap * (double)this.nParts, this.links[0].res * (double)this.nParts, this.nParts);
    }
}

