/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.thermalcontrol;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;

public class PIDController {
    DoubleSupplier temperatureProbe;
    DoubleConsumer heater;
    double target;
    double gain = 0.01;
    double derivativeTime = 1.0;
    double integralTime = 4.0 * this.derivativeTime;
    double maxCorr = 50.0;
    double minCorr = 0.0;
    double lastCorr = 0.0;
    long setupChangeTime = 0L;
    boolean freezeOnUpdate = true;
    boolean progressiveParmUpdates = false;
    ScheduledExecutorService execService = Executors.newScheduledThreadPool(1);
    protected volatile ScheduledFuture<?> future = null;
    double lastTime = 0.0;
    double lastErrorValue;
    double integral = 0.0;
    long minDelay = 2L;
    long loopTime = 100L;

    public PIDController(DoubleSupplier temperatureProbe, DoubleConsumer heater) {
        this.temperatureProbe = temperatureProbe;
        this.heater = heater;
    }

    public DoubleSupplier getTemperatureProbe() {
        return this.temperatureProbe;
    }

    public void setTarget(double target) {
        this.changeSetup();
        this.target = target;
    }

    public double getTarget() {
        return this.target;
    }

    public void setFreezeOnUpdate(boolean freezeOnUpdate) {
        this.freezeOnUpdate = freezeOnUpdate;
    }

    public boolean isFreezeOnUpdate() {
        return this.freezeOnUpdate;
    }

    public void changeSetup() {
        this.setupChangeTime = System.currentTimeMillis();
        this.resetIntegral();
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gain) {
        this.gain = gain;
        this.changeSetup();
    }

    public double getIntegralTime() {
        return this.integralTime;
    }

    public void setIntegralTime(double integralTime) {
        this.integralTime = integralTime;
        this.changeSetup();
    }

    public double getDerivativeTime() {
        return this.derivativeTime;
    }

    public void setDerivativeTime(double derivativeTime) {
        this.derivativeTime = derivativeTime;
    }

    public void resetIntegral() {
        this.integral = 0.0;
    }

    public void setMinCorr(double minCorr) {
        this.minCorr = minCorr;
    }

    public void setMaxCorr(double maxCorr) {
        this.maxCorr = maxCorr;
    }

    public double getMinCorr() {
        return this.minCorr;
    }

    public double getMaxCorr() {
        return this.maxCorr;
    }

    public void start() {
        this.future = this.execService.scheduleAtFixedRate(() -> this.process(), 0L, this.loopTime, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    public void process() {
        long timeStamp = System.currentTimeMillis();
        if ((double)timeStamp - this.lastTime < (double)this.minDelay) {
            return;
        }
        double t = this.temperatureProbe.getAsDouble();
        double error = t - this.target;
        this.integral += error;
        double der = (error - this.lastErrorValue) / ((double)timeStamp - this.lastTime);
        double corr = -this.gain * (error + this.integral / this.integralTime + der * this.derivativeTime);
        if (corr > this.maxCorr) {
            corr = this.maxCorr;
        }
        if (corr < this.minCorr) {
            corr = this.minCorr;
        }
        this.lastTime = timeStamp;
        this.lastErrorValue = error;
        if (this.freezeOnUpdate && ((double)(timeStamp - this.setupChangeTime) < this.integralTime * 1000.0 / 4.0 || (double)(timeStamp - this.setupChangeTime) < this.derivativeTime * 1000.0 / 4.0)) {
            corr = this.lastCorr;
        } else {
            this.lastCorr = corr;
        }
        System.out.printf("T %5.2f  \u0394T %5.2f p %5.2f\n", t, error, corr);
        this.heater.accept(corr);
    }
}

