/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;

public abstract class BusMessage<T extends Serializable, D>
implements Serializable {
    private static final long serialVersionUID = 345689513329636909L;
    private final SerializationUtils<T> serializationUtils = new SerializationUtils();
    private D encodedData;
    private byte[] serializedObject;
    private transient T deserializedObject = null;
    private final transient T embeddedObject;
    private String className = "";
    private AgentInfo originAgentInfo;
    private final long timeStamp = System.currentTimeMillis();

    public BusMessage(T obj) {
        this.embeddedObject = obj;
        if (obj != null) {
            this.className = obj.getClass().getName();
        } else {
            this.encodedData = null;
            this.serializedObject = null;
        }
    }

    protected abstract D encodeObject(T var1);

    public String getClassName() {
        return this.className;
    }

    public D getEncodedData() {
        if (this.embeddedObject != null) {
            return this.encodeObject(this.embeddedObject);
        }
        return this.encodedData;
    }

    public T getObject() {
        if (this.embeddedObject != null) {
            return this.embeddedObject;
        }
        if (this.serializedObject == null) {
            return null;
        }
        if (this.deserializedObject == null) {
            this.deserializedObject = this.serializationUtils.deserialize(this.serializedObject);
        }
        return this.deserializedObject;
    }

    public AgentInfo getOriginAgentInfo() {
        return this.originAgentInfo;
    }

    public final void setOriginAgentInfo(AgentInfo agent) {
        if (this.originAgentInfo != null) {
            throw new RuntimeException("The setOriginAgentInfo method on BusMessage must be invoked only once!!!");
        }
        this.originAgentInfo = agent;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sOrigin = this.getOriginAgentInfo() != null ? this.getOriginAgentInfo().getName() : "notSet";
        sb.append(this.getClass().getSimpleName()).append(" { origin=").append(sOrigin).append("\n");
        sb.append(" creation timestamp=").append(this.getTimeStamp()).append("\n");
        sb.append(" className=").append(this.className).append("\n");
        sb.append(" encodedData: \n");
        sb.append(this.getEncodedData());
        return sb.toString();
    }

    private void prepareForSendingOverTheBuses() throws IOException {
        if (this.embeddedObject != null) {
            this.encodedData = this.encodeObject(this.embeddedObject);
            this.serializedObject = this.serializationUtils.serialize(this.embeddedObject);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.prepareForSendingOverTheBuses();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private class SerializationUtils<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = -1377509787159869583L;

        private SerializationUtils() {
        }

        public byte[] serialize(T obj) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            return bos.toByteArray();
        }

        public T deserialize(byte[] bytes) throws EmbeddedObjectDeserializationException {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream ois = new ObjectInputStream(bis);
                return (T)((Serializable)ois.readObject());
            }
            catch (ClassNotFoundException x) {
                throw new EmbeddedObjectDeserializationException("Class not found while deserializing embedded object", x);
            }
            catch (IOException x) {
                throw new EmbeddedObjectDeserializationException("Could not deserialize embedded object", x);
            }
        }
    }
}

