/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.aerotech;

import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class AerotechPro165
extends Ascii {
    public static double timeout = 30000.0;
    public static final int DEFAULT_BAUD = 9600;
    public static final String DEFAULT_DEV = "/dev/ttyS1";
    private final String terminator = "\n";
    private byte[] buff = new byte[1024];
    private int buffIn;
    private int buffOut;
    private static final ReentrantLock KeyLock = new ReentrantLock();
    private double speed = 10.0;

    public void open(String devname, int port) throws DriverException {
        this.open(2, devname, port);
        this.setTimeout(timeout);
    }

    public void openserial(String serialname, int port) throws DriverException {
        System.out.println("openning connection to the Aerotech");
        this.open(2, serialname, port);
        this.setTimeout(timeout);
        this.setTerminator("\n");
        System.out.println("Sending returns to get its attention.");
        this.writeAerotechPro165("");
    }

    public void openftdi(String serialname, int port) throws DriverException {
        System.out.println("openning connection to the Aerotech");
        this.setTerminator("\n");
        this.open(1, serialname, port);
        this.setTimeout(timeout);
        System.out.println("Sending esc to get its attention.");
        this.writeAerotechPro165("");
    }

    public void opennet(String netaddress, int port) throws DriverException {
        System.out.println("opening connection to the Aerotech");
        this.setTerminator("\n");
        this.setTimeout(timeout);
        this.open(0, netaddress, port);
    }

    public void close() throws DriverException {
        super.close();
    }

    public String getVersion() throws DriverException {
        return this.readAerotechPro165("VERSION");
    }

    public String getError() throws DriverException {
        return "x:" + this.readAerotechPro165("AXISFAULT X") + "\n y:" + this.readAerotechPro165("AXISFAULT Y") + "\n z:" + this.readAerotechPro165("AXISFAULT Z");
    }

    public void reset() throws DriverException {
        this.writeAerotechPro165("ACKNOWLEDGEALL");
    }

    public void fullreset() throws DriverException {
        this.writeAerotechPro165("reset");
    }

    public void abort() throws DriverException {
        this.writeAerotechPro165("ABORT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPos_x() throws DriverException {
        double px = Double.NaN;
        try {
            KeyLock.lock();
            while (Double.isNaN(px)) {
                String rply = this.readAerotechPro165("PFBK X");
                System.out.println("getPos_x response: " + rply);
                try {
                    px = Double.parseDouble(rply.substring(1));
                }
                catch (NumberFormatException ex) {
                    System.out.println("Unable to decode " + rply.substring(1));
                }
            }
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
        return px;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPos_y() throws DriverException {
        double py = Double.NaN;
        try {
            KeyLock.lock();
            while (Double.isNaN(py)) {
                String rply = this.readAerotechPro165("PFBK Y");
                System.out.println("getPos_y response: " + rply);
                try {
                    py = Double.parseDouble(rply.substring(1));
                }
                catch (NumberFormatException ex) {
                    System.out.println("Unable to decode " + rply.substring(1));
                }
            }
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
        return py;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPos_z() throws DriverException {
        double pz = Double.NaN;
        try {
            KeyLock.lock();
            while (Double.isNaN(pz)) {
                String rply = this.readAerotechPro165("PFBK Z");
                System.out.println("getPos_z response: " + rply);
                try {
                    pz = Double.parseDouble(rply.substring(1));
                }
                catch (NumberFormatException ex) {
                    System.out.println("Unable to decode " + rply.substring(1));
                }
            }
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
        return pz;
    }

    public double[] getPos_xyz() throws DriverException {
        double[] p = new double[]{Double.NaN, Double.NaN, Double.NaN};
        p[0] = this.getPos_x();
        p[1] = this.getPos_y();
        p[2] = this.getPos_z();
        return p;
    }

    public void enableAxis(char axis) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("Enabling axis " + axis);
            this.readAerotechPro165("ENABLE " + axis);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void disableAxis(char axis) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("Disabling axis " + axis);
            this.readAerotechPro165("DISABLE " + axis);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAbs(double dx, double dy, double dz) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving absolutely dx, dy, dz = " + dx + " " + dy + " " + dz);
            this.readAerotechPro165("MOVEABS X " + dx + " Y " + dy + " Z " + dz);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void goHome() throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("homing all axes");
            this.readAerotechPro165("HOME X Y Z");
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void setupHome(int mode) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("setting home mode of all axes to " + mode);
            this.readAerotechPro165("setparm x, hometype, " + mode);
            this.readAerotechPro165("setparm y, hometype, " + mode);
            this.readAerotechPro165("setparm z, hometype, " + mode);
            this.readAerotechPro165("setparm z, homesetup, 0x00000001");
            this.readAerotechPro165("commitparameters");
            this.fullreset();
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void setSpeed(double speed) throws DriverException {
        this.speed = speed;
        System.out.println("setting speed = " + speed);
    }

    public void rampRate(double rate) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("setting ramp rate = " + rate);
            this.readAerotechPro165("RAMP RATE " + rate);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void rampMode(String mode) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("setting ramp mode = " + mode);
            this.readAerotechPro165("RAMP MODE " + mode);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void softLowLim(String axis, int param) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("setting software low lim to " + param);
            this.readAerotechPro165(axis + ", SoftwareLimitLow, " + param);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void softHighLim(String axis, int param) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("setting software high lim to " + param);
            this.readAerotechPro165(axis + ", SoftwareLimitHigh, " + param);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void moveAbs_x(double dx) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving absolutely dx= " + dx);
            this.readAerotechPro165("MOVEABS X " + dx + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void moveAbs_z(double dz) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving absolutely dz= " + dz + " F " + this.speed);
            this.readAerotechPro165("MOVEABS Z " + dz + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void moveAbs_y(double dy) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving absolutely dy= " + dy + " F " + this.speed);
            this.readAerotechPro165("MOVEABS Y " + dy + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAbs(double dx, double dy) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving absolutely dx, dy = " + dx + " " + dy);
            this.readAerotechPro165("MOVEABS X " + dx + " Y " + dy + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveInc(double dx, double dy, double dz) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving incrementally dx, dy, dz = " + dx + " " + dy + " " + dz);
            this.readAerotechPro165("MOVEINC X " + dx + " Y " + dy + " Z " + dz + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void moveInc_x(double dx) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving incrementally dx= " + dx);
            this.readAerotechPro165("MOVEINC X " + dx + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void moveInc_z(double dz) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving incrementally dz= " + dz);
            this.readAerotechPro165("MOVEINC Z " + dz + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public void moveInc_y(double dy) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving incrementally dy= " + dy);
            this.readAerotechPro165("MOVEINC Y " + dy + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveInc(double dx, double dy) throws DriverException {
        try {
            KeyLock.lock();
            System.out.println("moving incrementally dx, dy = " + dx + " " + dy);
            this.readAerotechPro165("MOVEINC X " + dx + " Y " + dy + " F " + this.speed);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
    }

    public synchronized void writeAerotechPro165(String command) throws DriverException {
        this.write(command + "\n");
    }

    public synchronized String readAerotechPro165() throws DriverException {
        return this.read();
    }

    public synchronized String readAerotechPro165(String command) throws DriverException {
        this.writeAerotechPro165(command);
        return this.readAerotechPro165();
    }
}

