/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keyence.KeyenceG5001;
import org.lsst.ccs.subsystem.metrology.KeyenceDevice;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class KeyenceG5001Device
extends Device
implements KeyenceDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean isconnected = false;
    KeyenceG5001 keydev = null;
    String keyence_host = null;
    int keyence_port = 38400;
    MetrologyState.pwrstates kstate = MetrologyState.pwrstates.NOTCONFIGURED;
    boolean failedToInitialize = false;
    private double[] last_read = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    public KeyenceG5001Device(String host, int port) throws DriverException {
        System.out.println("In Keyence initialization class");
        this.isconnected = true;
        this.keyence_host = host;
        this.keyence_port = port;
        try {
            this.keydev = new KeyenceG5001();
            this.keydev.openserial(host, port);
            System.out.println("Openned connection to Keyence!");
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to KeyenceG5001 device!");
            this.isconnected = false;
        }
    }

    public KeyenceG5001Device() {
        try {
            this.keydev = new KeyenceG5001();
        }
        catch (DriverException f) {
            System.out.println("Failed to create to KeyenceG5001 device instance!");
        }
    }

    @Override
    protected void configure(Monitor mon) {
        super.configure(mon);
        this.fullName = "KeyenceG5001 module";
    }

    @Override
    protected void close() {
        try {
            if (this.keydev != null) {
                this.keydev.close();
            }
            this.kstate = MetrologyState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)"KeyenceG5001 device failed to close!!!");
        }
    }

    @Override
    protected void initialize() {
        if (this.isconnected) {
            this.log.debug((Object)"KeyenceG5001 device is already initialized");
            this.log.debug((Object)"Setting device online.");
            this.setOnline(true);
            this.kstate = MetrologyState.pwrstates.OK;
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected Keyence device!");
            this.failedToInitialize = true;
        }
    }

    @Override
    @Command(description="return controller version")
    public String getVersion() throws DriverException {
        return this.keydev.getVersion();
    }

    @Override
    @Command(name="read", description="get keyence head measurement")
    public double read(@Argument(name="ikey", description="keyence head number") int ikey) throws DriverException {
        double[] response = this.readAll();
        return response[ikey - 1];
    }

    @Override
    @Command(name="getcycles", description="get sampling cycle setting")
    public int getcycles() throws DriverException {
        return this.keydev.getnsamps();
    }

    @Override
    @Command(name="setcycles", description="set number of cycles")
    public void setcycles(@Argument(name="cycles", description="sampling cycle mode") int cycles) throws DriverException {
        this.keydev.setnsamps(cycles);
    }

    @Override
    @Command(name="getmeasmode", description="get mode")
    public int getmeasmode() throws DriverException {
        return -99;
    }

    @Override
    @Command(name="setmeasmode", description="set mode")
    public void setmeasmode(@Argument(name="mode", description="mode number") int mode) throws DriverException {
        this.keydev.setmeasmode(mode);
    }

    @Override
    @Command(name="setmindispunit", description="set mode")
    public void setmindispunit(@Argument(name="dspu", description="(0: 0.01 mm, 1: 0.001 mm, 2: 0.0001 mm, 3: 0.00001 mm, 4: 0.1 um, 5: 0.01 um, 6: 0.001 um)") int dspu) throws DriverException {
        this.keydev.setmindispunit(dspu);
    }

    @Override
    @Command(name="readAll", description="get keyence head measurement")
    public double[] readAll() throws DriverException {
        double[] response = this.keydev.readAll();
        for (int i = 0; i < response.length; ++i) {
            this.last_read[i] = response[i];
        }
        return response;
    }

    @Override
    @Command(description="communications mode")
    public void commmode() throws DriverException {
        this.keydev.commmode();
    }

    @Override
    @Command(description="general mode")
    public void genmode() throws DriverException {
        this.keydev.genmode();
    }

    @Command(description="returns any axis fault messages")
    public String getError() throws DriverException {
        return "not implimented yet";
    }

    @Command(description="clears all fault mesdsages")
    public void reset() throws DriverException {
        this.keydev.reset();
    }

    @Override
    @Command(description="sets lasers on/off")
    public void laser(@Argument(name="laserstate", description="false for laser off / true for on") boolean laserstate) throws DriverException {
        this.keydev.laser(laserstate);
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        return new int[]{iType, 0};
    }

    @Override
    protected void initChannel(int chan, int type, int subtype) {
        try {
            this.log.debug((Object)("setting channel online - chan=" + chan));
            this.setOnline(true);
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    @Override
    protected double readChannel(int chan, int type) {
        double value = 0.0;
        try {
            if (chan == 0) {
                value = this.last_read[0];
            }
            if (chan == 1) {
                value = this.last_read[1];
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Override
    public double[] getLast_read() {
        return this.last_read;
    }

    @Command(name="setstate", description="set KeyenceG5001 device status")
    public void setState(int istate) {
        this.kstate = MetrologyState.pwrstates.values()[istate];
    }

    @Command(name="getstate", description="get KeyenceG5001 device status")
    public int getState() {
        return this.kstate.ordinal();
    }

    static {
        typeMap.put("POSITION", -1);
    }
}

