/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.metrology.AerotechDevice;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class AerotechP165Device
extends Device
implements AerotechDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private int last_state = -1;
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean open = false;
    private boolean isconnected = false;
    AerotechPro165 devaero = null;
    String aerotech_host = null;
    int aerotech_port = 8000;
    MetrologyState.pwrstates kstate = MetrologyState.pwrstates.NOTCONFIGURED;
    boolean failedToInitialize = false;
    private double lastPosx;
    private double lastPosy;
    private double lastPosz;
    private double xOffset = -300.0;
    private double yOffset = -200.0;
    private double zOffset = -100.0;

    @Override
    @Command
    public double getxOffset() {
        return this.xOffset;
    }

    @Override
    @Command
    public void setxOffset(double xOffset) {
        this.xOffset = xOffset;
    }

    @Override
    @Command
    public double getyOffset() {
        return this.yOffset;
    }

    @Override
    @Command
    public void setyOffset(double yOffset) {
        this.yOffset = yOffset;
    }

    @Override
    @Command
    public double getzOffset() {
        return this.zOffset;
    }

    @Override
    @Command
    public void setzOffset(double zOffset) {
        this.zOffset = zOffset;
    }

    public AerotechP165Device(String host, int port) throws DriverException {
        System.out.println("In Aerotech initialization class");
        this.isconnected = true;
        this.aerotech_host = host;
        this.aerotech_port = port;
        try {
            this.devaero = new AerotechPro165();
            this.devaero.opennet(host, port);
            System.out.println("Openned connection to Aerotech!");
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to AerotechP165 device!");
            this.isconnected = false;
        }
    }

    public AerotechP165Device() {
        try {
            this.devaero = new AerotechPro165();
        }
        catch (DriverException f) {
            System.out.println("Failed to create to AerotechP165 device instance!");
        }
    }

    @Override
    protected void configure(Monitor mon) {
        super.configure(mon);
        this.fullName = "AerotechP165 module";
    }

    @Override
    protected void close() {
        try {
            if (this.devaero != null) {
                this.devaero.close();
            }
            this.kstate = MetrologyState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)"AerotechP165 device failed to close!!!");
        }
    }

    @Override
    protected void initialize() {
        System.out.println("aerotechP165Device: initialize called");
        if (this.isconnected) {
            this.log.debug((Object)"AerotechP165 device is already initialized");
            this.log.info((Object)"Setting device online.");
            System.out.println("aerotech: setting device online");
            this.setOnline(true);
            this.kstate = MetrologyState.pwrstates.OK;
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected PDU device!");
            this.failedToInitialize = true;
        }
    }

    @Override
    @Command(description="return controller version")
    public String getVersion() throws DriverException {
        return this.devaero.getVersion();
    }

    @Override
    @Command(description="abort motion")
    public void abort() throws DriverException {
        this.devaero.abort();
    }

    @Override
    @Command(description="enable axes")
    public void enableAxes() throws DriverException {
        this.log.info((Object)"Enabling X axis");
        this.devaero.enableAxis('X');
        this.Sleep(1.0);
        this.log.info((Object)"Enabling Y axis");
        this.devaero.enableAxis('Y');
        this.Sleep(1.0);
        this.log.info((Object)"Enabling Z axis");
        this.devaero.enableAxis('Z');
    }

    @Override
    @Command(description="disable axes")
    public void disableAxes() throws DriverException {
        this.log.info((Object)"Disabling X axis");
        this.devaero.disableAxis('X');
        this.Sleep(1.0);
        this.log.info((Object)"Disabling Y axis");
        this.devaero.disableAxis('Y');
        this.Sleep(1.0);
        this.log.info((Object)"Disabling Z axis");
        this.devaero.disableAxis('Z');
    }

    public void Sleep(double secs) {
        try {
            long millis = (long)(secs * 1000.0);
            this.log.info((Object)("Sleeping for " + millis + " millis"));
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            this.log.error((Object)("Rude awakening!" + ex));
        }
    }

    @Override
    @Command(description="setSpeed")
    public void setSpeed(@Argument(name="velocity", description="step / s") double velocity) throws DriverException {
        this.devaero.setSpeed(velocity);
    }

    @Override
    @Command(description="rampRate")
    public void rampRate(@Argument(name="rate", description="step / s2") double rate) throws DriverException {
        this.devaero.rampMode("RATE");
        this.devaero.rampRate(rate);
    }

    @Override
    @Command(description="move incrementally in x")
    public void moveInc_x(@Argument(name="dx", description="amount to move in user units") double delta) throws DriverException {
        this.devaero.moveInc_x(delta);
    }

    @Override
    @Command(description="move incrementally in y")
    public void moveInc_y(@Argument(name="dy", description="amount to move in user units") double delta) throws DriverException {
        this.devaero.moveInc_y(delta);
    }

    @Override
    @Command(description="move incrementally in z")
    public void moveInc_z(@Argument(name="dz", description="amount to move in user units") double delta) throws DriverException {
        this.devaero.moveInc_z(delta);
    }

    @Override
    @Command(description="move incrementally in x and y")
    public void moveInc_xy(@Argument(name="x", description="amount to move in x in user units") double dx, @Argument(name="y", description="amount to move in y in user units") double dy) throws DriverException {
        this.devaero.moveInc(dx, dy);
    }

    @Override
    @Command(description="move incrementally in x, y and z")
    public void moveInc_xyz(@Argument(name="x", description="amount to move in x in user units") double dx, @Argument(name="y", description="amount to move in y in user units") double dy, @Argument(name="z", description="amount to move in z in user units") double dz) throws DriverException {
        this.devaero.moveInc(dx, dy, dz);
    }

    @Override
    @Command(description="move absolutely in x")
    public void moveAbs_x(@Argument(name="xpos", description="x position in user units") double xpos) throws DriverException {
        this.devaero.moveAbs_x(xpos);
    }

    @Override
    @Command(description="move absolutely in y")
    public void moveAbs_y(@Argument(name="y", description="position in y in user units") double ypos) throws DriverException {
        this.devaero.moveAbs_y(ypos);
    }

    @Override
    @Command(description="move absolutely in z")
    public void moveAbs_z(@Argument(name="z", description="position in z in user units") double zpos) throws DriverException {
        this.devaero.moveAbs_z(zpos);
    }

    @Override
    @Command(description="move absolutely in x and y")
    public void moveAbs_xy(@Argument(name="x", description="position in x in user units") double xpos, @Argument(name="y", description="position in y in user units") double ypos) throws DriverException {
        this.devaero.moveAbs(xpos, ypos);
    }

    @Override
    @Command(description="move absolutely in x, y and z")
    public void moveAbs_xyz(@Argument(name="x", description="position in x in user units") double xpos, @Argument(name="y", description="position in y in user units") double ypos, @Argument(name="z", description="position in z in user units") double zpos) throws DriverException {
        this.devaero.moveAbs(xpos, ypos, zpos);
    }

    @Override
    @Command(description="returns position in x, y and z")
    public double[] getPos_xyz() throws DriverException {
        double[] p = new double[]{this.getPos_x(), this.getPos_y(), this.getPos_z()};
        this.lastPosx = p[0];
        this.lastPosy = p[1];
        this.lastPosz = p[2];
        System.out.println("lastPosx = " + this.lastPosx);
        System.out.println("lastPosy = " + this.lastPosy);
        System.out.println("lastPosz = " + this.lastPosz);
        return p;
    }

    @Override
    @Command(description="returns position in x")
    public double getPos_x() throws DriverException {
        double xmeas = Double.NaN;
        while (Double.isNaN(xmeas)) {
            xmeas = this.devaero.getPos_x();
            if (!Double.isNaN(xmeas)) continue;
            this.log.info((Object)"Waiting for x position value to become available");
        }
        this.lastPosx = xmeas -= this.xOffset;
        System.out.println("lastPosx = " + this.lastPosx);
        return this.lastPosx;
    }

    @Override
    @Command(description="returns position in y")
    public double getPos_y() throws DriverException {
        double ymeas = Double.NaN;
        while (Double.isNaN(ymeas)) {
            ymeas = this.devaero.getPos_y();
            if (!Double.isNaN(ymeas)) continue;
            this.log.info((Object)"Waiting for y position value to become available");
        }
        this.lastPosy = ymeas -= this.yOffset;
        System.out.println("lastPosy = " + this.lastPosy);
        return this.lastPosy;
    }

    @Override
    @Command(description="returns position in z")
    public double getPos_z() throws DriverException {
        double zmeas = Double.NaN;
        while (Double.isNaN(zmeas)) {
            zmeas = this.devaero.getPos_z();
            if (!Double.isNaN(zmeas)) continue;
            this.log.info((Object)"Waiting for z position value to become available");
        }
        this.lastPosz = zmeas -= this.zOffset;
        System.out.println("lastPosz = " + this.lastPosz);
        return this.lastPosz;
    }

    @Override
    public double getLastPos_x() {
        return this.lastPosx;
    }

    @Override
    public double getLastPos_y() {
        return this.lastPosy;
    }

    @Override
    public double getLastPos_z() {
        return this.lastPosz;
    }

    @Override
    @Command(description="returns any axis fault messages")
    public String getError() throws DriverException {
        return this.devaero.getError();
    }

    @Override
    @Command(description="goes to home position")
    public void goHome() throws DriverException {
        this.devaero.goHome();
        double new_xOffset = this.xOffset;
        double new_yOffset = this.yOffset;
        double new_zOffset = this.zOffset;
        this.xOffset = new_xOffset;
        this.yOffset = new_yOffset;
        this.zOffset = new_zOffset;
        this.log.error((Object)("Offsets determined from home position are (" + this.xOffset + "," + this.yOffset + "," + this.zOffset + ")"));
    }

    @Override
    @Command(description="setup homing mode")
    public void setupHome(int mode) throws DriverException {
        this.devaero.setupHome(mode);
    }

    @Override
    @Command(description="setup low position limit")
    public void softLowLim(String axis, int param) throws DriverException {
        this.devaero.softLowLim(axis, param);
    }

    @Override
    @Command(description="setup high position limit")
    public void softHighLim(String axis, int param) throws DriverException {
        this.devaero.softHighLim(axis, param);
    }

    @Override
    @Command(description="clears all fault messages")
    public void reset() throws DriverException {
        this.devaero.reset();
    }

    @Override
    @Command(description="reset controller")
    public void fullreset() throws DriverException {
        this.devaero.fullreset();
        this.log.error((Object)"trying to reopen the connection");
        this.reconnect();
    }

    @Command(description="reconnect")
    public void reconnect() throws DriverException {
        this.log.error((Object)"trying to reopen the connection");
        try {
            this.devaero.opennet(this.aerotech_host, this.aerotech_port);
        }
        catch (DriverException ex) {
            this.log.error((Object)"failed attempt to reopen connection");
        }
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        return new int[]{iType, 0};
    }

    @Override
    protected void initChannel(int chan, int type, int subtype) {
        try {
            this.log.info((Object)("setting channel online - chan=" + chan));
            System.out.println("setting channel online - chan=" + chan);
            this.setOnline(true);
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    @Override
    protected double readChannel(int chan, int type) {
        double value = 0.0;
        switch (chan) {
            case 0: {
                value = this.lastPosx;
                break;
            }
            case 1: {
                value = this.lastPosy;
                break;
            }
            case 2: {
                value = this.lastPosz;
            }
        }
        return value;
    }

    @Command(name="setstate", description="set AerotechP165 device status")
    public void setState(int istate) {
        this.kstate = MetrologyState.pwrstates.values()[istate];
    }

    @Command(name="getstate", description="get AerotechP165 device status")
    public int getState() {
        return this.kstate.ordinal();
    }

    static {
        typeMap.put("POSITION", -1);
    }
}

