/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.function.Consumer;
import java.util.function.Function;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.TreeWalkerDiag;

public class TreeWalkerUtils {
    public static <A> void proceduralWalk(ComponentLookup lookup, String startingNodeName, Class<A> klass, Consumer<A> pre, Consumer<A> post) {
        TreeWalkerUtils.treeWalk(lookup, startingNodeName, klass, t -> {
            if (pre != null) {
                pre.accept(t);
            }
            return TreeWalkerDiag.GO;
        }, post);
    }

    public static void proceduralNodeWalk(ComponentLookup lookup, String startingNodeName, Consumer<ComponentNode> pre, Consumer<ComponentNode> post) {
        TreeWalkerUtils.treeNodeWalk(lookup, startingNodeName, node -> {
            if (pre != null) {
                pre.accept((ComponentNode)node);
            }
            return TreeWalkerDiag.GO;
        }, post);
    }

    public static <J> void treeWalk(ComponentLookup lookup, String startingNodeName, Class<J> klass, Function<J, TreeWalkerDiag> func, Consumer<J> post) {
        TreeWalkerUtils.treeNodeWalk(lookup, startingNodeName, node -> {
            Object obj;
            if (func != null && klass.isAssignableFrom((obj = node.getComponent()).getClass())) {
                return (TreeWalkerDiag)((Object)((Object)func.apply(obj)));
            }
            return TreeWalkerDiag.GO;
        }, node -> {
            Object obj;
            if (post != null && klass.isAssignableFrom((obj = node.getComponent()).getClass())) {
                post.accept(node.getComponent());
            }
        });
    }

    public static void treeNodeWalk(ComponentLookup lookup, String startingNodeName, Function<ComponentNode, TreeWalkerDiag> func, Consumer<ComponentNode> post) {
        ComponentNode startFromNode;
        ComponentNode componentNode = startFromNode = startingNodeName == null ? lookup.getTopComponentNode() : lookup.getNodeByName(startingNodeName);
        if (startFromNode != null) {
            TreeWalkerUtils.treeNodeWalkInternal(startFromNode, func, post);
        }
    }

    private static TreeWalkerDiag treeNodeWalkInternal(ComponentNode node, Function<ComponentNode, TreeWalkerDiag> func, Consumer<ComponentNode> post) {
        TreeWalkerDiag diag = TreeWalkerDiag.GO;
        if (func != null) {
            diag = func.apply(node);
        }
        switch (diag) {
            case STOP: {
                return diag;
            }
            case HANDLING_CHILDREN: {
                return diag;
            }
        }
        for (ComponentNode child : node.getChildren()) {
            TreeWalkerDiag childRes = TreeWalkerUtils.treeNodeWalkInternal(child, func, post);
            if (!childRes.equals((Object)TreeWalkerDiag.STOP)) continue;
            return childRes;
        }
        if (post != null) {
            post.accept(node);
        }
        return diag;
    }
}

