/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.ConfigurableComponent;

public class MetrologyConfigurable
extends ConfigurableComponent {
    private final Map<String, Integer> currentParms = new HashMap<String, Integer>();
    private int min;
    private int max;
    @ConfigurationParameter(name="rotation", category="MetrologyConfig")
    private double rotation;
    @ConfigurationParameter(name="startx", category="MetrologyConfig")
    private double startx;
    @ConfigurationParameter(name="stopx", category="MetrologyConfig")
    private double stopx;
    @ConfigurationParameter(name="dx", category="MetrologyConfig")
    private double dx;
    @ConfigurationParameter(name="starty", category="MetrologyConfig")
    private double starty;
    @ConfigurationParameter(name="stopy", category="MetrologyConfig")
    private double stopy;
    @ConfigurationParameter(name="dy", category="MetrologyConfig")
    private double dy;
    @ConfigurationParameter(name="cornerang", category="MetrologyConfig")
    private double cornerang;
    @ConfigurationParameter(name="nsamples", category="MetrologyConfig")
    private int nsamples;
    @ConfigurationParameter(name="measmode", category="MetrologyConfig")
    private int measmode;
    @ConfigurationParameter(name="acceleration", category="MetrologyConfig")
    private double acceleration;
    @ConfigurationParameter(name="speed", category="MetrologyConfig")
    private double speed;
    final double MIN_X = -150.0;
    final double MAX_X = 150.0;
    final double MIN_Y = -150.0;
    final double MAX_Y = 150.0;

    public MetrologyConfigurable(String name, double startx, double stopx, double dx, double starty, double stopy, double dy, double rotation, double cornerang, int nsamples, int measmode, double acceleration, double speed) {
        assert (startx > -150.0);
        assert (startx < 150.0);
        System.out.println("SETTING CONFIG PARAMETERS FOR " + name);
        this.startx = startx;
        this.stopx = stopx;
        this.starty = starty;
        this.stopy = stopy;
        this.cornerang = cornerang;
        this.rotation = rotation;
        this.nsamples = nsamples;
        this.measmode = measmode;
        this.acceleration = acceleration;
        this.speed = speed;
    }

    @ConfigurationParameterChanger(propertyName="startx")
    public void setStartX(Object StartX) {
        double tmp_startx = (Double)StartX;
        assert (tmp_startx > -150.0);
        assert (tmp_startx < 150.0);
        System.out.println("configuring startx setpoint to " + tmp_startx);
        this.startx = tmp_startx;
    }

    @ConfigurationParameterChanger(propertyName="stopx")
    public void setStopX(Object StopX) {
        double tmp_stopx = (Double)StopX;
        assert (tmp_stopx > -150.0);
        assert (tmp_stopx < 150.0);
        System.out.println("configuring stopx setpoint to " + tmp_stopx);
        this.stopx = tmp_stopx;
    }

    @ConfigurationParameterChanger(propertyName="dx")
    public void setdX(Object dX) {
        this.dx = (Double)dX;
        System.out.println("configuring dx setpoint to " + this.dx);
    }

    @ConfigurationParameterChanger(propertyName="starty")
    public void setStartY(Object StartY) {
        double tmp_starty = (Double)StartY;
        assert (tmp_starty > -150.0);
        assert (tmp_starty < 150.0);
        System.out.println("configuring starty setpoint to " + tmp_starty);
        this.starty = tmp_starty;
    }

    @ConfigurationParameterChanger(propertyName="stopy")
    public void setStopY(Object StopY) {
        double tmp_stopy = (Double)StopY;
        assert (tmp_stopy > -150.0);
        assert (tmp_stopy < 150.0);
        System.out.println("configuring stopy setpoint to " + tmp_stopy);
        this.stopy = tmp_stopy;
    }

    @ConfigurationParameterChanger(propertyName="dy")
    public void setdY(Object dY) {
        this.dy = (Double)dY;
        System.out.println("configuring dy setpoint to " + this.dy);
    }

    @ConfigurationParameterChanger(propertyName="nsamples")
    public void setNSamples(Object nSamples) {
        this.nsamples = (Integer)nSamples;
        System.out.println("configuring number of samples to " + this.nsamples);
    }

    @ConfigurationParameterChanger(propertyName="rotation")
    public void setRotation(Object rotation) {
        this.rotation = (Double)rotation;
    }

    @ConfigurationParameterChanger(propertyName="cornerang")
    public void setCornerang(Object cornerang) {
        this.cornerang = (Double)cornerang;
    }

    @ConfigurationParameterChanger(propertyName="measmode")
    public void setMeasmode(Object measmode) {
        this.measmode = (Integer)measmode;
    }

    @ConfigurationParameterChanger(propertyName="acceleration")
    public void setAcceleration(Object acceleration) {
        this.acceleration = (Double)acceleration;
    }

    @ConfigurationParameterChanger(propertyName="speed")
    public void setSpeed(Object speed) {
        this.speed = (Double)speed;
    }

    @ConfigurationParameterChanger
    public void setCurrentParms(Object currentParms) {
        Map map = (Map)currentParms;
        this.currentParms.putAll(map);
    }
}

