/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;
import org.lsst.ccs.utilities.logging.Logger;

public class MetrologyConfigCatcher
implements Serializable,
AgentPresenceListener,
StatusMessageListener {
    private static MetrologyConfig tsc = null;
    private AgentMessagingLayer agentMessagingLayer = null;
    private static final Logger LOGGER = Logger.getLogger((String)"org.lsst.ccs.subsystem.metrology.main");
    private static String DEST = "metrology";
    private ConcurrentMessagingUtils cmu;
    private boolean first = true;

    public MetrologyConfigCatcher() {
    }

    public MetrologyConfigCatcher(MetrologyConfig tsc) {
        MetrologyConfigCatcher.tsc = tsc;
    }

    public void initCatcher(ConfigurationInfo configInfo) {
        System.out.println("Initializing the configuration catcher");
        this.agentMessagingLayer = Agent.getEnvironmentMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        this.agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        BusMessageFilter filter = BusMessageFilter.messageOrigin((String)DEST).and(BusMessageFilter.messageClass(StatusSubsystemData.class));
        this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this, (Predicate)filter);
        this.updateConfig(configInfo);
    }

    public void onStatusMessage(StatusMessage msg) {
        if (msg == null) {
            return;
        }
        ConfigurationInfo configInfo = null;
        if (!(msg.getObject() instanceof ConfigurationInfo)) {
            return;
        }
        configInfo = (ConfigurationInfo)msg.getObject();
        this.updateConfig(configInfo);
    }

    public void updateConfig(ConfigurationInfo configInfo) {
        System.out.println("update config for " + configInfo.getConfigurationName());
        List listChanges = configInfo.getLatestChanges();
        if (this.first || configInfo.hasChanges()) {
            this.first = false;
            for (String componentName : MetrologyConfig.COMPONENT_NAMES) {
                Map configForComponent = configInfo.getCurrentValuesForComponent(componentName);
                if (configForComponent.isEmpty()) continue;
                System.out.println("config Map: " + configForComponent.toString());
                int istate = MetrologyConfig.configuration_states.valueOf((String)componentName).ordinal();
                System.out.println("istate = " + istate);
                System.out.println("getting startx");
                double startx = Double.valueOf((String)configForComponent.get(componentName + "//startx"));
                System.out.println("getting stopx");
                double stopx = Double.valueOf((String)configForComponent.get(componentName + "//stopx"));
                System.out.println("getting dx");
                double dx = Double.valueOf((String)configForComponent.get(componentName + "//dx"));
                System.out.println("getting starty");
                double starty = Double.valueOf((String)configForComponent.get(componentName + "//starty"));
                System.out.println("getting stopy");
                double stopy = Double.valueOf((String)configForComponent.get(componentName + "//stopy"));
                System.out.println("getting dy");
                double dy = Double.valueOf((String)configForComponent.get(componentName + "//dy"));
                System.out.println("getting rotation");
                double rotation = Double.valueOf((String)configForComponent.get(componentName + "//rotation"));
                System.out.println("getting cornerang");
                double cornerang = Double.valueOf((String)configForComponent.get(componentName + "//cornerang"));
                System.out.println("getting nsamps");
                int nsamps = Integer.valueOf((String)configForComponent.get(componentName + "//nsamps"));
                System.out.println("getting measmode");
                int measmode = Integer.valueOf((String)configForComponent.get(componentName + "//measmode"));
                System.out.println("getting acceleration");
                double acceleration = Double.valueOf((String)configForComponent.get(componentName + "//acceleration"));
                System.out.println("getting speed");
                double speed = Double.valueOf((String)configForComponent.get(componentName + "//speed"));
                tsc.update(istate, startx, stopx, dx, starty, stopy, dy, rotation, cornerang, nsamps, measmode, acceleration, speed);
            }
        }
    }

    public void connecting(AgentInfo agent) {
        System.out.println("Agent name = " + agent.getName());
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        if (!agent.getName().equals(DEST)) {
            return;
        }
        LOGGER.info((Object)"connecting");
        Future future = this.cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
        try {
            ConfigurationInfo configInfo = (ConfigurationInfo)future.get();
            this.updateConfig(configInfo);
            DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
            BusMessageFilter filter = BusMessageFilter.messageOrigin((String)DEST).and(BusMessageFilter.messageClass(StatusConfigurationInfo.class));
            this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this, (Predicate)filter);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"unable to retrieve configuration information", (Throwable)ex);
        }
    }

    public void disconnecting(AgentInfo agent) {
    }
}

