import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.startup.CCSBuilder;
import org.lsst.ccs.subsystem.metrology.MetrologySubSys;
import org.lsst.ccs.subsystem.metrology.MetrologyConfigurable;

import org.lsst.ccs.subsystem.metrology.AerotechP165Device;
import org.lsst.ccs.subsystem.metrology.KeyenceG5001Device;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;

import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;


String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ts5"]

builder.
    main (MetrologySubSys, argMap(aString("name","main"),
        anInt("tickMillis",5000), "metrology")) {

    Positioner (AerotechP165Device, argMap("130.199.47.180", 8000))

    Measurer (KeyenceG5001Device, argMap("/dev/ttyS1", 38400))
    
    //    AlarmHDW  (TSSubSys, argMap("OV", 0))
    AlarmHDW  (Alarm, argMap(null, MetrologyConfig.EVENT_ID.POSX.ordinal()))

    "RTM"(MetrologyConfigurable, argMap(
            aString('name','RTM'),
            aDbl('startx', -18.0),
            aDbl('stopx',  107.0),
            aDbl('dx',     4.0),
            aDbl('starty',-114.0),
            aDbl('stopy',  5.0),
            aDbl('dy',     4.0),
            aDbl('rotation',0.0),
            aDbl('cornerang',89.5),
            anInt('nsamps',     6),
            anInt('measmode',   0),
            aDbl('acceleration',1.0),
            aDbl('speed',20000.0)))

    "RTM_Explore"(MetrologyConfigurable, argMap(
            aString('name','RTM_Explore'),
            aDbl('startx', -18.0),
            aDbl('stopx',  42.0),
            aDbl('dx',     2.0),
            aDbl('starty',-55.0),
            aDbl('stopy',  5.0),
            aDbl('dy',     2.0),
            aDbl('rotation',0.0),
            aDbl('cornerang',89.5),
            anInt('nsamps',     6),
            anInt('measmode',   0),
            aDbl('acceleration',1.0),
            aDbl('speed',20000.0)))

    "SCAN3"(MetrologyConfigurable, argMap(
            aString('name','SCAN3'),
            aDbl('startx', -18.0),
            aDbl('stopx',  42.0),
            aDbl('dx',     2.0),
            aDbl('starty',-55.0),
            aDbl('stopy',  5.0),
            aDbl('dy',     2.0),
            aDbl('rotation',0.0),
            aDbl('cornerang',89.5),
            anInt('nsamps',     6),
            anInt('measmode',   0),
            aDbl('acceleration',1.0),
            aDbl('speed',20000.0)))

    "SCAN4"(MetrologyConfigurable, argMap(
            aString('name','SCAN4'),
            aDbl('startx', -18.0),
            aDbl('stopx',  42.0),
            aDbl('dx',     2.0),
            aDbl('starty',-55.0),
            aDbl('stopy',  5.0),
            aDbl('dy',     2.0),
            aDbl('rotation',0.0),
            aDbl('cornerang',89.5),
            anInt('nsamps',     6),
            anInt('measmode',   0),
            aDbl('acceleration',1.0),
            aDbl('speed',20000.0)))

    "BASEPLATE"(MetrologyConfigurable, argMap(
            aString('name','BASEPLATE'),
            aDbl('startx', 0.0),
            aDbl('stopx',  20.0),
            aDbl('dx',     4.0),
            aDbl('starty',-44.0),
            aDbl('stopy', -32.0),
            aDbl('dy',     4.0),
            aDbl('rotation',0.0),
            aDbl('cornerang',89.5),
            anInt('nsamps',     6),
            anInt('measmode',   0),
            aDbl('acceleration',1.0),
            aDbl('speed',20000.0)))


    /*
    CmpCCDBias  (MonChannel,
    argMap("CCD Bias Voltage", "V",
    "alarm", aDbl(limitLo, 0.0), 0.0,
    "alarm", aDbl(limitHi, 0.0), 0.0,
    "Bias", 0, "VOLT", "B", 0, 0.0, 1.0))
     */      
    /*
    Its name, used to identify it in databases, plots, etc.
    Its longer, more descriptive, name.
    The units the value is expressed in, e.g. "Volts".
    The device used for obtaining its value.
    The hardware channel number on the device.
    The channel type, e.g. temperature, pressure, etc, which is needed by some devices.
    The subtype, which supplies hardware configuration information.
    The offset and scale values needed for converting a raw hardware value to a physical one.
    Parameters used for checking the value against a limit.  There is one set for the low limit and one for the high one:
    The checking option: NONE, FLAG or ALARM
    The limit value.
    The alarm to be activated upon status transitions when ALARM is specified.
    The deadband value which delays a potential alarm action during a transition back to good status.
    Its id, which is its index in the list of all channels.

    The limit values are maintained by the configuration system and can be changed while running.  Any such change causes a status message to be broadcast, which can be used to update the trending database or to update any console displays.
     */
    posX  (Channel,
                    argMap("posX", "mm",
                           "Positioner", 0, "POSITION", "P", 0.0, 1.0,
                           "flag", aDbl(limitLo, -1000.0), 0.0, null,
                           "flag", aDbl(limitHi, 1000.0), 0.0, null))

    posY  (Channel,
                    argMap("posY", "mm",
                           "Positioner", 1, "POSITION", "P", 0.0, 1.0,
                           "flag", aDbl(limitLo, -1000.0), 0.0, null,
                           "flag", aDbl(limitHi, 1000.0), 0.0, null))

    posZ  (Channel,
                    argMap("posZ", "mm",
                           "Positioner", 2, "POSITION", "P", 0.0, 1.0,
                           "flag", aDbl(limitLo, -1000.0), 0.0, null,
                           "flag", aDbl(limitHi, 1000.0), 0.0, null))

    displacement  (Channel,
                    argMap("displacement", "mm",
                           "Measurer", 0, "POSITION", "A", 0.0, 1.0,
                           "flag", aDbl(limitLo, -1000.0), 0.0, null,
                           "flag", aDbl(limitHi, 1000.0), 0.0, null))


}
