package org.lsst.ccs.subsystem.metrology;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.framework.annotations.ConfigChanger;
//import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;
//import java.util.logging.Level;
//import java.util.logging.Logger;
/**
 *
 * @author The LSST CCS Team
 */
public class MetrologyConfigurable extends ConfigurableComponent {

    private final Map<String, Integer> currentParms = new HashMap<>();
    private int min;
    private int max;
//    private MetrologyConfig tsc = null;
    private double rotation;

    private double startx;           // x start
    private double stopx;           // x stop
    private double dx;
    private double starty;            // y start
    private double stopy;          // y stop
    private double dy;
    private double cornerang;         // trapezium angle 1
    private int    nsamples;
    private int    measmode;
    private double acceleration;
    private double speed;

    final double MIN_X = -150.,
            MAX_X = 150.;
    final double MIN_Y = -150.,
            MAX_Y = 150.;
    
    public MetrologyConfigurable(String name, double startx, double stopx, double dx, double starty,
            double stopy, double dy, double rotation, double cornerang, int nsamples,
            int measmode, double acceleration, double speed) {

//        System.out.println("MetrologyConfigurable name = "+this.toString());
        assert (startx > MIN_X);
        assert (startx < MAX_X);

        this.startx = startx;
        this.stopx = stopx;
        this.starty = starty;
        this.stopy = stopy;
        this.cornerang = cornerang;
        this.rotation = rotation;
        this.nsamples = nsamples;
        this.measmode = measmode;
        this.acceleration = acceleration;
        this.speed = speed;

//        int istate = MetrologyConfig.operating_states.valueOf(name).ordinal();
//        tsc.update(istate, startx, stopx, rotation, starty, stopy);
    }

    
    @ConfigChanger(propertyName = "startx")
    public void setStartX(Object StartX) {
        double tmp_startx = (double) StartX;
        assert (tmp_startx > MIN_X);
        assert (tmp_startx < MAX_X);
        System.out.println("configuring startx setpoint to "+tmp_startx);
        this.startx = tmp_startx;
    }

    @ConfigChanger(propertyName = "stopx")
    public void setStopX(Object StopX) {
        double tmp_stopx = (double) StopX;
        assert (tmp_stopx > MIN_X);
        assert (tmp_stopx < MAX_X);
        System.out.println("configuring stopx setpoint to "+tmp_stopx);
        this.stopx = tmp_stopx;
    }

    @ConfigChanger(propertyName = "dx")
    public void setdX(Object dX) {
        dx = (double) dX;
 
        System.out.println("configuring dx setpoint to "+dx);
    }

        @ConfigChanger(propertyName = "starty")
    public void setStartY(Object StartY) {
        double tmp_starty = (double) StartY;
        assert (tmp_starty > MIN_Y);
        assert (tmp_starty < MAX_Y);
        System.out.println("configuring starty setpoint to "+tmp_starty);
        starty = tmp_starty;
    }

    @ConfigChanger(propertyName = "stopy")
    public void setStopY(Object StopY) {
        double tmp_stopy = (double) StopY;
        assert (tmp_stopy > MIN_Y);
        assert (tmp_stopy < MAX_Y);
        System.out.println("configuring stopy setpoint to "+tmp_stopy);
        stopy = tmp_stopy;
    }

    @ConfigChanger(propertyName = "dy")
    public void setdY(Object dY) {
        this.dy = (double) dY;
 
        System.out.println("configuring dy setpoint to "+dy);
    }

    @ConfigChanger(propertyName = "nsamples")
    public void setNSamples(Object nSamples) {
        this.nsamples = (int) nSamples;
 
        System.out.println("configuring number of samples to "+nsamples);
    }
    
    @ConfigChanger(propertyName = "rotation")
    public void setRotation(Object rotation) {
        this.rotation = (double) rotation;
    }
    
    @ConfigChanger(propertyName = "cornerang")
    public void setCornerang(Object cornerang) {
        this.cornerang = (double) cornerang;
    }
    
    @ConfigChanger(propertyName = "measmode")
    public void setMeasmode(Object measmode) {
        this.measmode = (int) measmode;
    }

    @ConfigChanger(propertyName = "acceleration")
    public void setAcceleration(Object acceleration) {
        this.acceleration = (double) acceleration;
    }
    
    @ConfigChanger(propertyName = "speed")
    public void setSpeed(Object speed) {
        this.speed = (double) speed;
    }

}
