package org.lsst.ccs.subsystem.metrology.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.subsystem.metrology.data.MetrologyAgentProperties;
import org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI;

/**
 *
 * @author homer
 */
@org.lsst.ccs.gconsole.annotations.Plugin(name="Metrology Plugin",
        description="Metrology plugin")
public class MetrologyJasPlugin extends ConsolePlugin {


    private final OptionalPage metrologyOptionalPage = new MetrologyJasPlugin.MetrologyOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().addOptionalPage(metrologyOptionalPage);
    }

    static class MetrologyOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPath() {
            return "CCS Subsystems/Metrology/Controls";
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(MetrologyAgentProperties.METROLOGY_TYPE_AGENT_PROPERTY) ) {
                return "Metrology GUI ("+agent.getName()+")";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            MetrologyGUI gui;
            gui = new MetrologyGUI(Console.getConsole().getMessagingAccess());
            gui.initGui();        
            return gui.getPanel();
        }

    }
}
