package org.lsst.ccs.subsystem.metrology.ui.jas;

import javax.swing.JComponent;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.subsystem.metrology.data.MetrologyAgentProperties;
import org.lsst.ccs.subsystem.metrology.ui.MetrologyConfigurableSubsystemGUI;
import org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI;

/**
 *
 * @author homer
 */
@org.lsst.ccs.gconsole.annotations.Plugin(name="Configurable Metrology Plugin",
        description="Configurable Metrology plugin")
public class MetrologyConfigurablePlugin extends ConsolePlugin {

    
    private final OptionalPage metrologyConfigOptionalPage = new MetrologyConfigurablePlugin.MetrologyConfigOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().addOptionalPage(metrologyConfigOptionalPage);
    }

    static class MetrologyConfigOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPath() {
            return "CCS Subsystems/Metrology/Configuration";
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(MetrologyAgentProperties.METROLOGY_TYPE_AGENT_PROPERTY) ) {
                return "Metrology Config ("+agent.getName()+")";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            MetrologyConfigurableSubsystemGUI gui;
            gui = new MetrologyConfigurableSubsystemGUI(Console.getConsole().getMessagingAccess());
            return (JComponent)gui.getGuiLayout();
        }

    }
    
}
