package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
//import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;
//import org.lsst.gruth.jutils.Constraints;

/**
 *
 * @author The LSST CCS Team
 */
public class MetrologyConfigurableSubsystemMainPanel extends JPanel {

    private static final long serialVersionUID = 1L;
    private static final Map<String, MetrologyConfigurablePanel> panelMap = new TreeMap<>();
    private static AgentMessagingLayer agentMessagingLayer;
    private final JLabel descriptionNameLbl = new JLabel();
    private static String metrology_dest = "metrology";
    private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI");

    static {
//        for (String componentName : MetrologyConfig.COMPONENT_NAMES) {
        for (MetrologyConfig.configuration_states componentState : MetrologyConfig.configuration_states.values()) {
            String componentName = componentState.name();
            panelMap.put(componentName, new MetrologyConfigurablePanel(componentName));
        }
    }

    public MetrologyConfigurableSubsystemMainPanel(AgentMessagingLayer aml, String DEST) {
        agentMessagingLayer = aml;
        metrology_dest = DEST;
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(descriptionNameLbl);
        for (MetrologyConfigurablePanel panel : panelMap.values()) {
            add(panel);
        }

    }

    public void updateWithConfigInfo(ConfigurationInfo configurationInfo) {
        log.info("updating config info");
        for (Map.Entry<String, MetrologyConfigurablePanel> entry : panelMap.entrySet()) {
//            Map<String, String> configForComponent = configurationInfo.getCurrentValuesForComponent(entry.getKey());
            Map<String, String> configForComponent = configurationInfo.getCurrentValuesFor(entry.getKey());
            log.info("updating for "+entry.getKey());
            if (!configForComponent.isEmpty()) {
                entry.getValue().updateWithConfigInfo(configForComponent);
            }
        }
        log.info("Done updating config info");
    }

    public void setDescriptionName(String descriptionName) {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                descriptionNameLbl.setText(descriptionName);
            }
        });
    }

    private static class MetrologyConfigurablePanel extends JPanel {

        private static final long serialVersionUID = 1L;
        private final String componentName;

        final private NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
        final private NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.##"));
        final private NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.####E00"));

        private final JLabel stateLbl = new JLabel();
//        private final JLabel startxLbl = new JLabel();
        private final JFormattedTextField startxLbl = new JFormattedTextField(fmt5d);
//        private final JLabel stopxLbl = new JLabel();
        private final JFormattedTextField stopxLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField widthxLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField dxLbl = new JFormattedTextField(fmt5d);
//        private final JLabel startyLbl = new JLabel();
        private final JFormattedTextField startyLbl = new JFormattedTextField(fmt5d);
//        private final JLabel stopyLbl = new JLabel();
        private final JFormattedTextField stopyLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField heightyLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField dyLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField zLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField rotationLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField cornerangLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField nsampsLbl = new JFormattedTextField(fmt5);
        private final JFormattedTextField measmodeLbl = new JFormattedTextField(fmt5);
        private final JFormattedTextField accelerationLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField speedLbl = new JFormattedTextField(fmt5d);
//        private final JLabel rotationLbl = new JLabel();
//        private final JLabel cornerangLbl = new JLabel();
        private static final JButton btsavechanges = new JButton("Save Changes");

        private MetrologyConfigurablePanel(String componentName) {
            super(new GridBagLayout());
            this.componentName = componentName;
            setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = GridBagConstraints.WEST;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0;
            gbc.weighty = 0;
            gbc.fill = GridBagConstraints.NONE;

            add(new JLabel("State : "), gbc);

            gbc.gridy = 1;
            add(new JLabel("Scan X start : "), gbc);

            gbc.gridy = 2;
            add(new JLabel("Scan X stop : "), gbc);

            gbc.gridy++;
            gbc.gridx++;
            add(new JLabel("Scan X width : "), gbc);
            gbc.gridx--;

            gbc.gridy++;
            add(new JLabel("Scan dX : "), gbc);

            gbc.gridy++;
            add(new JLabel("Scan Y start : "), gbc);

            gbc.gridy++;
            add(new JLabel("Scan Y stop : "), gbc);

            gbc.gridy++;
            gbc.gridx++;
            add(new JLabel("Scan Y height : "), gbc);
            gbc.gridx--;

            gbc.gridy++;
            add(new JLabel("Scan dY : "), gbc);

            gbc.gridy++;
            add(new JLabel("Scan Z : "), gbc);

            gbc.gridy++;
            add(new JLabel("Rotation : "), gbc);

            gbc.gridy++;
            add(new JLabel("Corner Angle : "), gbc);

            gbc.gridy++;
            add(new JLabel("Cycle Mode : "), gbc);

            gbc.gridy++;
            add(new JLabel("Surface Mode : "), gbc);

            gbc.gridy++;
            add(new JLabel("Acceleration : "), gbc);

            gbc.gridy++;
            add(new JLabel("Speed : "), gbc);

            gbc.gridx += 3;
            add(btsavechanges, gbc);
            btsavechanges.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Saving all changes");
                    sendSyncMetrologyCommand(null, "saveAllChanges");
                }
            });

            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1;
            add(stateLbl, gbc);

            Dimension d = startxLbl.getPreferredSize();
            d.width = 100;
            d.height = 20;
            startxLbl.setPreferredSize(d);
            stopxLbl.setPreferredSize(d);
            widthxLbl.setPreferredSize(d);
            startyLbl.setPreferredSize(d);
            stopyLbl.setPreferredSize(d);
            heightyLbl.setPreferredSize(d);
            cornerangLbl.setPreferredSize(d);
            rotationLbl.setPreferredSize(d);
            dxLbl.setPreferredSize(d);
            dyLbl.setPreferredSize(d);
            zLbl.setPreferredSize(d);
            nsampsLbl.setPreferredSize(d);
            measmodeLbl.setPreferredSize(d);
            accelerationLbl.setPreferredSize(d);
            speedLbl.setPreferredSize(d);

            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            add(startxLbl, gbc);

            gbc.gridy = 2;
            gbc.gridwidth = 1;
            add(stopxLbl, gbc);

            gbc.gridy++;
            gbc.gridx++;
            add(widthxLbl, gbc);
            gbc.gridx--;

            gbc.gridy++;
            gbc.gridwidth = 1;
            add(dxLbl, gbc);

            gbc.gridy++;
            gbc.gridwidth = 1;
            add(startyLbl, gbc);

            gbc.gridy++;
            add(stopyLbl, gbc);

            gbc.gridy++;
            gbc.gridx++;
            add(heightyLbl, gbc);
            gbc.gridx--;

            gbc.gridy++;
            add(dyLbl, gbc);

            gbc.gridy++;
            add(zLbl, gbc);

            gbc.gridy++;
            add(rotationLbl, gbc);

            gbc.gridy++;
            add(cornerangLbl, gbc);

            gbc.gridy++;
            add(nsampsLbl, gbc);

            gbc.gridy++;
            add(measmodeLbl, gbc);

            gbc.gridy++;
            add(accelerationLbl, gbc);

            gbc.gridy++;
            add(speedLbl, gbc);

            startxLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing startx value");
                    sendSyncMetrologyCommand(componentName, "change", "startx", startxLbl.getText());
                    Double new_stopx = Double.valueOf(widthxLbl.getText()) + Double.valueOf(startxLbl.getText());
                    stopxLbl.setText(Double.toString(new_stopx));
                    sendSyncMetrologyCommand(componentName, "change", "stopx", Double.toString(new_stopx));
                }
            });
            stopxLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "stopx", stopxLbl.getText());
                    widthxLbl.setText(Double.toString(Double.valueOf(stopxLbl.getText()) - Double.valueOf(startxLbl.getText())));
                }
            });
            widthxLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    Double new_stopx = Double.valueOf(widthxLbl.getText()) + Double.valueOf(startxLbl.getText());
                    stopxLbl.setText(Double.toString(new_stopx));
                    sendSyncMetrologyCommand(componentName, "change", "stopx", stopxLbl.getText());
                }
            });
            dxLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "dx", dxLbl.getText());
                }
            });
            startyLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "starty", startyLbl.getText());
                    Double new_stopy = Double.valueOf(heightyLbl.getText()) + Double.valueOf(startyLbl.getText());
                    stopyLbl.setText(Double.toString(new_stopy));
                    sendSyncMetrologyCommand(componentName, "change", "stopy", stopyLbl.getText());
                }
            }
            );

            stopyLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "stopy", stopyLbl.getText());
                    heightyLbl.setText(Double.toString(Double.valueOf(stopyLbl.getText()) - Double.valueOf(startyLbl.getText())));
                }
            }
            );

            heightyLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    Double new_stopy = Double.valueOf(heightyLbl.getText()) + Double.valueOf(startyLbl.getText());
                    stopyLbl.setText(Double.toString(new_stopy));
                    sendSyncMetrologyCommand(componentName, "change", "stopy", stopyLbl.getText());
                }
            }
            );

            dyLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "dy", dyLbl.getText());
                }
            }
            );

            zLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "z", zLbl.getText());
                }
            }
            );

            rotationLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "rotation", rotationLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setDy", Double.valueOf(rotationLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            cornerangLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "cornerang", cornerangLbl.getText());
                }
            }
            );

            nsampsLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "nsamples", nsampsLbl.getText());
                }
            }
            );

            measmodeLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "measmode", measmodeLbl.getText());
                }
            }
            );

            accelerationLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "acceleration", accelerationLbl.getText());
                }
            }
            );

            speedLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "speed", speedLbl.getText());
                }
            }
            );

        }

        private void updateWithConfigInfo(Map<String, String> configForComponent) {
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    stateLbl.setText(configForComponent.get("state"));
                    startxLbl.setText(configForComponent.get("startx"));
                    stopxLbl.setText(configForComponent.get("stopx"));
                    dxLbl.setText(configForComponent.get("dx"));
                    startyLbl.setText(configForComponent.get("starty"));
                    stopyLbl.setText(configForComponent.get("stopy"));
                    dyLbl.setText(configForComponent.get("dy"));
                    zLbl.setText(configForComponent.get("z"));
                    rotationLbl.setText(configForComponent.get("rotation"));
                    cornerangLbl.setText(configForComponent.get("cornerang"));
                    nsampsLbl.setText(configForComponent.get("nsamples"));
                    measmodeLbl.setText(configForComponent.get("measmode"));
                    accelerationLbl.setText(configForComponent.get("acceleration"));
                    speedLbl.setText(configForComponent.get("speed"));
//                    Map<String, Integer> currentMap = (Map<String, Integer>) Constraints.check("java.util.Map", configForComponent.get(componentName+"//currentParms"), null);
//                    Lbl.setText(String.valueOf(currentMap.get("continuousLimit")));
//                    outputLimitLbl.setText(String.valueOf(currentMap.get("outputLimit")));
//                    maxSpeedLbl.setText(String.valueOf(currentMap.get("maxSpeed")));
                    widthxLbl.setText(Double.toString(Double.valueOf(stopxLbl.getText()) - Double.valueOf(startxLbl.getText())));
                    heightyLbl.setText(Double.toString(Double.valueOf(stopyLbl.getText()) - Double.valueOf(startyLbl.getText())));
                }
            });
        }

        protected Object sendSyncMetrologyCommand(String target, String name, Object... params) {
            String dest = target == null ? metrology_dest : metrology_dest + "/" + target;
            ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
            CommandRequest cmd = new CommandRequest(dest, name, params);
            try {
//                return cmu.sendSynchronousCommand(cmd, 1440000);
                return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(1440000));
            } catch (Exception e) {
//            throw new RuntimeException("error invoking synchronous command", e);
                log.warning("Unable to perform jgroup communication with destination "
                        + dest + " - Exception " + e);
                return null;
            }
        }
    }
}
