/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPageDialog;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public abstract class AbstractMonitorView1
implements MonitorView {
    protected AgentChannelsFilter filter;
    protected MonitorFormat formatter;
    protected Descriptor descriptor;
    private boolean fixedDisplayList;
    private Set<String> displayChannels;

    @Override
    public AgentChannelsFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        this.filter = filter;
        this.fixedDisplayList = filter != null && filter.getDisplayChannels() != null;
    }

    @Override
    public MonitorFormat getFormater() {
        return this.formatter;
    }

    @Override
    public void setFormatter(MonitorFormat formatter) {
        this.formatter = formatter;
    }

    protected boolean isChannelListFixed() {
        return this.fixedDisplayList;
    }

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.connect(event.getSource()));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        if (this.displayChannels == null) {
            List<String> fixed = this.filter.getDisplayChannels();
            if (fixed == null) {
                this.fixedDisplayList = false;
                this.displayChannels = Collections.emptySet();
            } else {
                this.fixedDisplayList = true;
                this.displayChannels = new HashSet<String>(fixed);
                SwingUtilities.invokeLater(() -> this.addChannels(event.getSource(), fixed.stream().collect(Collectors.toMap(dp -> dp, dp -> null))));
            }
        }
        this.update(event);
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        this.update(event);
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        this.update(event);
        SwingUtilities.invokeLater(() -> this.disconnect(event.getSource()));
    }

    /*
     * WARNING - void declaration
     */
    private void update(AgentStatusEvent event) {
        if (this.fixedDisplayList) {
            LinkedHashMap<String, Map.Entry> changedChannels = new LinkedHashMap<String, Map.Entry>();
            for (AgentChannel agentChannel : event.getAddedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, new AbstractMap.SimpleEntry<AgentChannel, Object>(agentChannel, null));
                }
            }
            for (AgentChannel agentChannel : event.getRemovedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, null);
                }
            }
            for (Map.Entry entry : event.getStatusChanges().entrySet()) {
                for (String string : this.filter.getDisplayPath((AgentChannel)entry.getKey())) {
                    if (!this.displayChannels.contains(string)) continue;
                    changedChannels.put(string, entry);
                }
            }
            SwingUtilities.invokeLater(() -> this.updateChannels(event.getSource(), changedChannels));
        } else {
            void var4_14;
            LinkedHashMap<String, AgentChannel> addedChannels = null;
            for (AgentChannel agentChannel : event.getAddedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (addedChannels == null) {
                        addedChannels = new LinkedHashMap<String, AgentChannel>();
                    }
                    addedChannels.put(string, agentChannel);
                }
            }
            ArrayList<String> removedChannels = null;
            for (AgentChannel agentChannel : event.getRemovedChannels()) {
                for (String string : this.filter.getDisplayPath(agentChannel)) {
                    if (removedChannels == null) {
                        removedChannels = new ArrayList<String>(event.getRemovedChannels().size());
                    }
                    removedChannels.add(string);
                }
            }
            Object var4_13 = null;
            for (Map.Entry<AgentChannel, List<String>> entry : event.getStatusChanges().entrySet()) {
                for (String displayPath : this.filter.getDisplayPath(entry.getKey())) {
                    if (var4_14 == null) {
                        LinkedHashMap linkedHashMap = new LinkedHashMap();
                    }
                    var4_14.put(displayPath, entry);
                }
            }
            LinkedHashMap<String, AgentChannel> linkedHashMap = addedChannels;
            ArrayList<String> arrayList = removedChannels;
            void var7_40 = var4_14;
            SwingUtilities.invokeLater(() -> this.lambda$update$6(linkedHashMap, event, arrayList, (Map)var7_40));
        }
    }

    protected void connect(AgentInfo agent) {
    }

    protected void disconnect(AgentInfo agent) {
    }

    protected abstract void addChannels(AgentInfo var1, Map<String, AgentChannel> var2);

    protected abstract void removeChannels(AgentInfo var1, List<String> var2);

    protected abstract void updateChannels(AgentInfo var1, Map<String, Map.Entry<AgentChannel, List<String>>> var2);

    @Override
    public Descriptor save() {
        return this.descriptor;
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        }
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    public static class Descriptor
    implements MonitorView.Descriptor {
        private MonitorPageDialog.Descriptor creator;
        private String name;

        @Override
        public Serializable getCreator() {
            return this.creator;
        }

        @Override
        public void setCreator(Serializable creator) {
            if (creator instanceof MonitorPageDialog.Descriptor) {
                this.creator = (MonitorPageDialog.Descriptor)creator;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }
    }
}

