package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author homer
 */
public class PointSetConfigurableSubsystemGUI implements AgentPresenceListener,
        StatusMessageListener {

    private static final Logger LOGGER = Logger.getLogger("org.lsst.ccs.subsystem.metrology.gui");
    private static String DEST = "metrology";
    private final PointSetConfigurableSubsystemMainPanel mainPanel;
    private final AgentMessagingLayer aml;
    private final ConcurrentMessagingUtils cmu;
    boolean online = false;
//    private BusMessageFilter filterConfig;
    Predicate<BusMessage<? extends Serializable, ?>> filterConfig;

    public PointSetConfigurableSubsystemGUI(AgentMessagingLayer aml) {
        this.aml = aml;
        cmu = new ConcurrentMessagingUtils(aml);
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");

        mainPanel = new PointSetConfigurableSubsystemMainPanel(aml, DEST);
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        if (msg == null || !msg.getOriginAgentInfo().getName().equals(DEST)) {
            return;
        }
        //                 System.out.println("msg type = "+(msg.getObject()).toString());                         
        ConfigurationInfo configInfo = null;
        if (msg.getObject() instanceof ConfigurationInfo) {
            configInfo = (ConfigurationInfo) msg.getObject();
        } else {
            if (!online) {
                Future<Object> future = cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
                try {
                    configInfo = (ConfigurationInfo) future.get();
                    LOGGER.info("Updating config info");
                    mainPanel.updateWithConfigInfo(configInfo);
                    LOGGER.info("Setting description name");
                    mainPanel.setDescriptionName(configInfo.getDescriptionName());
                    LOGGER.info("Updating config info");
                    mainPanel.updateWithConfigInfo(configInfo);
                    online = true;
                } catch (Exception ex) {
                    LOGGER.warn("unable to retrieve configuration information", ex);
                }
            }
            return;
        }
//        ConfigurationInfo configInfo = (ConfigurationInfo) msg.getObject();
        List<ConfigurationParameterInfo> listChanges = configInfo.getLatestChanges();
        LOGGER.info("Updating config info");
        mainPanel.updateWithConfigInfo(configInfo);
    }

    public Component getGuiLayout() {
        return new JScrollPane(mainPanel);
    }

    public void initGui() {
        aml.getAgentPresenceManager().addAgentPresenceListener(this);
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
//        filterConfig = BusMessageFilter.messageOrigin(DEST).and(BusMessageFilter.messageClass(StatusConfigurationInfo.class));
        filterConfig = BusMessageFilterFactory.messageOrigin(DEST).and(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class));

    }

    public void connecting(AgentInfo agent) {
        LOGGER.info("Metrology GUI connecting to the bus");
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        LOGGER.info("DEST = " + DEST);

        if (!agent.getName().equals(DEST)) {
            return;
        }
        try {
            LOGGER.info("Adding status message listner");
            aml.addStatusMessageListener(this, filterConfig);
//            online = true;
        } catch (Exception ex) {
            LOGGER.warn("unable to register as a listner", ex);
        }
    }

    public void disconnecting(AgentInfo agent) {
        aml.removeStatusMessageListener(this);
    }

}
