/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.optpage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.ConsoleService;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.services.optpage.OptionalPageHandler;

@Plugin(name="Optional Page Service Plugin", id="opt-page", description="Support for optional pages utility.")
public class LsstOptionalPageService
extends ConsolePlugin
implements ConsoleService {
    private final ArrayList<OptionalPageHandler> optionalPages = new ArrayList(0);

    public void add(OptionalPage descriptor) {
        if (SwingUtilities.isEventDispatchThread()) {
            OptionalPageHandler handler = new OptionalPageHandler(descriptor);
            this.optionalPages.add(handler);
            this.optionalPages.trimToSize();
            handler.start();
        } else {
            SwingUtilities.invokeLater(() -> this.add(descriptor));
        }
    }

    @Deprecated
    public void remove(String path) {
        if (SwingUtilities.isEventDispatchThread()) {
            Iterator<OptionalPageHandler> it = this.optionalPages.iterator();
            while (it.hasNext()) {
                OptionalPageHandler handler = it.next();
                if (!handler.getDescriptor().getPath().equals(path)) continue;
                it.remove();
                handler.stop();
                break;
            }
        } else {
            SwingUtilities.invokeLater(() -> this.remove(path));
        }
    }

    public void remove(OptionalPage descriptor) {
        if (SwingUtilities.isEventDispatchThread()) {
            Iterator<OptionalPageHandler> it = this.optionalPages.iterator();
            while (it.hasNext()) {
                OptionalPageHandler handler = it.next();
                if (handler.getDescriptor() != descriptor) continue;
                it.remove();
                handler.stop();
                break;
            }
        } else {
            SwingUtilities.invokeLater(() -> this.remove(descriptor));
        }
    }

    public void setOpen(OptionalPage descriptor, AgentInfo agent, boolean isOpen) {
        OptionalPageHandler h = this.getHandler(descriptor);
        if (h != null) {
            h.setOpen(agent, isOpen);
        }
    }

    public HashMap<String, Boolean> save(OptionalPage descriptor) {
        OptionalPageHandler h = this.getHandler(descriptor);
        if (h != null) {
            return h.save();
        }
        return null;
    }

    public void restore(OptionalPage descriptor, HashMap<String, Boolean> storageBean) {
        OptionalPageHandler h = this.getHandler(descriptor);
        if (h != null) {
            h.restore(storageBean);
        }
    }

    @Override
    public ComponentDescriptor save() {
        HashMap<String, Boolean> open = new HashMap<String, Boolean>();
        this.optionalPages.forEach(h -> {
            if (h.getDescriptor().isAutoSave()) {
                open.putAll(h.save());
            }
        });
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        desc.setOpen(open);
        return desc;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        try {
            Descriptor desc = (Descriptor)storageBean;
            HashMap<String, Boolean> open = desc.getOpen();
            this.optionalPages.forEach(h -> {
                if (h.getDescriptor().isAutoSave()) {
                    h.restore(open);
                }
            });
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        return true;
    }

    OptionalPageHandler getHandler(OptionalPage descriptor) {
        for (OptionalPageHandler h : this.optionalPages) {
            OptionalPage d = h.getDescriptor();
            if (d != descriptor) continue;
            return h;
        }
        return null;
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private HashMap<String, Boolean> open;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public HashMap<String, Boolean> getOpen() {
            return this.open;
        }

        public void setOpen(HashMap<String, Boolean> open) {
            this.open = open;
        }
    }
}

