package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
//import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;
//import org.lsst.gruth.jutils.Constraints;

/**
 *
 * @author The LSST CCS Team
 */
public class PointSetConfigurableSubsystemMainPanel extends JPanel {

    private static final long serialVersionUID = 1L;
    private static final Map<String, MetrologyConfigurablePanel> panelMap = new TreeMap<>();
    private static AgentMessagingLayer agentMessagingLayer;
    private final JLabel descriptionNameLbl = new JLabel();
    private static String metrology_dest = "metrology";
    private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI");

    static {
//        for (String componentName : MetrologyConfig.COMPONENT_NAMES) {
        for (MetrologyConfig.pointset_states componentState : MetrologyConfig.pointset_states.values()) {
            String componentName = componentState.name();
            panelMap.put(componentName, new MetrologyConfigurablePanel(componentName));
        }
    }

    public PointSetConfigurableSubsystemMainPanel(AgentMessagingLayer aml, String DEST) {
        agentMessagingLayer = aml;
        metrology_dest = DEST;
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(descriptionNameLbl);
        for (MetrologyConfigurablePanel panel : panelMap.values()) {
            add(panel);
        }

    }

    public void updateWithConfigInfo(ConfigurationInfo configurationInfo) {
        log.info("updating config info");
        for (Map.Entry<String, MetrologyConfigurablePanel> entry : panelMap.entrySet()) {
//            Map<String, String> configForComponent = configurationInfo.getCurrentValuesForComponent(entry.getKey());
            Map<String, String> configForComponent = configurationInfo.getCurrentValuesFor(entry.getKey());
            log.info("updating for "+entry.getKey());
            if (!configForComponent.isEmpty()) {
                entry.getValue().updateWithConfigInfo(configForComponent);
            }
        }
        log.info("Done updating config info");
    }

    public void setDescriptionName(String descriptionName) {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                descriptionNameLbl.setText(descriptionName);
            }
        });
    }

    private static class MetrologyConfigurablePanel extends JPanel {

        private static final long serialVersionUID = 1L;
        private final String componentName;

        final private NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
        final private NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.##"));
        final private NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.####E00"));

        private final JLabel stateLbl = new JLabel();
//        private final JLabel startxLbl = new JLabel();
        private final JFormattedTextField PointXLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField PointYLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField PointZLbl = new JFormattedTextField(fmt5d);
        private static final JButton btsavechanges = new JButton("Save Changes");

        private MetrologyConfigurablePanel(String componentName) {
            super(new GridBagLayout());
            this.componentName = componentName;
            setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = GridBagConstraints.WEST;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0;
            gbc.weighty = 0;
            gbc.fill = GridBagConstraints.NONE;

            add(new JLabel("X : "), gbc);

            gbc.gridy++;
            add(new JLabel("Y : "), gbc);

            gbc.gridy++;
            add(new JLabel("Z : "), gbc);

            gbc.gridy+=4;
            add(btsavechanges, gbc);
            
            btsavechanges.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Saving all changes");
                    sendSyncMetrologyCommand(null, "saveAllChanges");
                }
            });

            Dimension d = PointXLbl.getPreferredSize();
            d.width = 100;
            d.height = 20;
            PointXLbl.setPreferredSize(d);
            PointYLbl.setPreferredSize(d);
            PointZLbl.setPreferredSize(d);

            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            add(PointXLbl, gbc);

            gbc.gridy++;
            gbc.gridwidth = 1;
            add(PointYLbl, gbc);


            gbc.gridy++;
            gbc.gridwidth = 1;
            add(PointZLbl, gbc);

            PointXLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing PointX value");
                    sendSyncMetrologyCommand(componentName, "change", "PointX", PointXLbl.getText());
                }
            });

            PointYLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing PointY value");
                    sendSyncMetrologyCommand(componentName, "change", "PointY", PointYLbl.getText());
                }
            });

            PointZLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing PointZ value");
                    sendSyncMetrologyCommand(componentName, "change", "PointZ", PointZLbl.getText());
                }
            });

        }

        private void updateWithConfigInfo(Map<String, String> configForComponent) {
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    PointXLbl.setText(configForComponent.get("PointX"));
                    PointYLbl.setText(configForComponent.get("PointY"));
                    PointZLbl.setText(configForComponent.get("PointZ"));
                }
            });
        }

        protected Object sendSyncMetrologyCommand(String target, String name, Object... params) {
            String dest = target == null ? metrology_dest : metrology_dest + "/" + target;
            ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
            CommandRequest cmd = new CommandRequest(dest, name, params);
            try {
//                return cmu.sendSynchronousCommand(cmd, 1440000);
                return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(1440000));
            } catch (Exception e) {
//            throw new RuntimeException("error invoking synchronous command", e);
                log.warning("Unable to perform jgroup communication with destination "
                        + dest + " - Exception " + e);
                return null;
            }
        }
    }
}
