/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;
import org.lsst.ccs.subsystem.metrology.data.MetrologyFullState;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;

public class MetrologyGUI
implements StatusMessageListener,
AgentPresenceListener {
    private String metrology_dest = "metrology";
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    private boolean enabled = false;
    private String out_fln = "/home/ts5prod/scans/Metrology_Scan_Data_${TIMESTAMP}.csv";
    private static final long serialVersionUID = -8352262068369045572L;
    private static final Map<Integer, String> pStateMap = new HashMap<Integer, String>();
    private static final String NB_SPACE = "\u00a0";
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    static final Font f = new Font("Tahoma", 1, 14);
    static final Font bigf = new Font("Tahoma", 1, 16);
    private static final JLabel lbmetrology = new JLabel("Subsystem Status");
    private static final JLabel lbmetrologystate = new JLabel("STATE");
    private static final JLabel lbmetrologyerr = new JLabel("ERRORS");
    private static final JButton btmetrologycfg = new JButton("RTM");
    private static final JButton btmetrologylaser = new JButton("LASER ON");
    private static final JButton btmetrologyabrt = new JButton("ABORT SCAN!");
    private static final JButton btmetrologyack = new JButton("ACKNWLDG ERRS");
    private static final JButton btmetrologyenableaxes = new JButton("ENABLE AXES");
    private static final JLabel lbmetrologyscantyp = new JLabel("SCAN TYPE");
    private static final JLabel lbPosition = new JLabel("Aerotech");
    private static final JLabel lbPosState = new JLabel("State");
    private static final JLabel lbPosX = new JLabel("X (mm)");
    private static final JLabel lbPosY = new JLabel("Y (mm)");
    private static final JLabel lbPosZ = new JLabel("Z (mm)");
    private static final JLabel lbPosXSet = new JLabel("Set X (mm)");
    private static final JLabel lbPosYSet = new JLabel("Set Y (mm)");
    private static final JLabel lbPosZSet = new JLabel("Set Z (mm)");
    private static final JLabel lbPosSpeed = new JLabel("Set Speed");
    private static final JLabel lbKey = new JLabel("Keyence");
    private static final JLabel lbKeyState = new JLabel("State");
    private static final JLabel lbKey1 = new JLabel("Head1 (mm)");
    private static final JLabel lbKey2 = new JLabel("Head2 (mm)");
    private static final JLabel lbKeynsamp = new JLabel("Cycle Mode");
    private static final JLabel lbKeymode = new JLabel("Surface Mode");
    private static final JLabel lbJoySpeed = new JLabel("Speed");
    private static final JLabel lbJoy = new JLabel("step (mm):");
    private static final JButton btKeyDSP = new JButton("DispSumMode");
    private static final JButton btKeySS = new JButton("StepScanMode");
    private static final JButton btJoyFL1 = new JButton("up");
    private static final JButton btJoyFL2 = new JButton("down");
    private static final JButton btJoyFL3 = new JButton("left");
    private static final JButton btJoyFL4 = new JButton("right");
    private static final JButton btJoyFL5 = new JButton("left 5 steps");
    private static final JButton btJoyFL6 = new JButton("right 5 steps");
    private static final JButton btJoyFL7 = new JButton("up 5 steps");
    private static final JButton btJoyFL8 = new JButton("down 5 steps");
    private static final JButton btJoyFL9 = new JButton("home");
    private static final JButton btJoyFL10 = new JButton("step in");
    private static final JButton btJoyFL11 = new JButton("step out");
    private static final JButton btacqimage = new JButton("PERFORM SURFACE SCAN");
    private static final JButton btreps = new JButton("do reps");
    private static final JButton btplot = new JButton("plot");
    private static final JLabel lbfln = new JLabel("filename:");
    private final JFormattedTextField tffln = new JFormattedTextField();
    private static final JLabel lbconfig = new JLabel("Configuration");
    private final JLabel lbMessage = new JLabel("\u00a0");
    private final JPanel panel = new JPanel();
    private final JPanel metrologyPanel = new JPanel();
    private final JPanel posPanel = new JPanel();
    private final JPanel dispPanel = new JPanel();
    private final JPanel joyPanel = new JPanel();
    private final JPanel extPanel = new JPanel();
    private final NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
    private final NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.0##"));
    private final NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.0###E00"));
    private final JFormattedTextField tfState = new JFormattedTextField();
    private final JFormattedTextField tfErr = new JFormattedTextField();
    private final JFormattedTextField tfAcqTyp = new JFormattedTextField();
    private final JFormattedTextField tfPosXState = new JFormattedTextField();
    private final JFormattedTextField tfPosX = new JFormattedTextField();
    private final JFormattedTextField tfPosY = new JFormattedTextField();
    private final JFormattedTextField tfPosZ = new JFormattedTextField();
    private final JFormattedTextField tfJoy = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfPosXSet = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfPosYSet = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfPosZSet = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfJoySpeed = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfPDI = new JFormattedTextField(this.fmt5e);
    private final JFormattedTextField tfKeyState = new JFormattedTextField();
    private final JFormattedTextField tfKey1 = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfKey2 = new JFormattedTextField(this.fmt5d);
    private final JFormattedTextField tfKeynsamp = new JFormattedTextField(this.fmt5);
    private final JFormattedTextField tfKeymode = new JFormattedTextField(this.fmt5);
    private final JFormattedTextField tfKeyTacq = new JFormattedTextField(this.fmt5d);
    JFormattedTextField tfnreps = new JFormattedTextField(this.fmt5);
    JFormattedTextField tfperiod = new JFormattedTextField(this.fmt5d);
    JFormattedTextField tfrepfln = new JFormattedTextField();
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    static final Color BLUE = new Color(0, 0, 150);
    static final Color WHITE = new Color(150, 150, 150);
    static final Color YELLOW = new Color(200, 200, 0);
    static final Color BLACK = new Color(0, 0, 0);
    static final Color GREY = new Color(80, 80, 80);
    private static final Map<String, Color> typeMap = new HashMap<String, Color>();
    private JFrame pl = null;
    private JFrame plcfg = null;
    private JFrame frmreps = null;
    MetrologyConfig.ScanMode SSmode = MetrologyConfig.ScanMode.StepScan;
    private int DSPmode = MetrologyConfig.Displacement_Summing_Modes.NormalDispSum.ordinal();
    private long fltimestamp = 0L;
    private double stepScale = 1.0;
    private int cfgstate = MetrologyConfig.configuration_states.RTM.ordinal();
    private int nreps = 100;
    private double period = 1.0;
    private String RepFln = "/home/ts5prod/repetitions.dat";
    private boolean laserstate = true;
    boolean shstate = false;
    String lastpath = "";
    private boolean first = true;
    private final AgentMessagingLayer agentMessagingLayer;
    private final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI");

    public MetrologyGUI(AgentMessagingLayer agentMessagingLayer) {
        System.out.println("MetrologyGUI: Retrieving metrology name on the bus from property lsst.ccs.metrology.metrologyguidest");
        this.metrology_dest = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        this.agentMessagingLayer = agentMessagingLayer;
    }

    public void main(String[] args) throws ClassNotFoundException {
        System.out.println("starting MetrologyGUI main");
        this.metrology_dest = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        this.initGui();
        System.out.println("past initGui");
        JPanel xpane = new JPanel();
        xpane.setLayout(new BorderLayout());
        xpane.add((Component)this.getPanel(), "Center");
        JFrame f = new JFrame("Metrology Console");
        f.setContentPane(xpane);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    public void initGui() {
        System.out.println("initGui: Retrieving metrology name on the bus from property lsst.ccs.metrology.metrologyguidest");
        this.metrology_dest = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        System.out.println("metrology_dest = " + this.metrology_dest);
        this.initComponents();
        this.agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    private void enableComponents(boolean enable) {
        this.tfState.setEnabled(enable);
        this.tfErr.setEnabled(enable);
        this.tfAcqTyp.setEnabled(enable);
        this.tfPosXState.setEnabled(enable);
        this.tfPosX.setEnabled(enable);
        this.tfPosY.setEnabled(enable);
        this.tfPosZ.setEnabled(enable);
        this.tfJoy.setEnabled(enable);
        this.tfPosXSet.setEnabled(enable);
        this.tfPosYSet.setEnabled(enable);
        this.tfPosZSet.setEnabled(enable);
        this.tfJoySpeed.setEnabled(enable);
        this.tfPDI.setEnabled(enable);
        this.tfKeyState.setEnabled(enable);
        this.tfKey1.setEnabled(enable);
        this.tfKey2.setEnabled(enable);
        this.tfKeynsamp.setEnabled(enable);
        this.tfKeymode.setEnabled(enable);
        this.tfKeyTacq.setEnabled(enable);
    }

    public void connecting(AgentInfo agent) {
        if (agent.getName().equals(this.metrology_dest)) {
            SwingUtilities.invokeLater(() -> this.initConfigs());
            SwingUtilities.invokeLater(() -> this.enableComponents(true));
            Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.metrology_dest).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
            this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this, filter);
        }
    }

    public void disconnecting(AgentInfo agent) {
        SwingUtilities.invokeLater(() -> this.tfState.setText(MetrologyConfig.operating_states.DOWN.name()));
        this.agentMessagingLayer.removeStatusMessageListener((StatusMessageListener)this);
        SwingUtilities.invokeLater(() -> this.enableComponents(false));
    }

    private CommandOriginator getCommandOriginator() {
        CommandOriginator originator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processNack(CommandNack nack) {
            }

            public void processResult(CommandResult result) {
                MetrologyFullState r = (MetrologyFullState)result.getReply();
                MetrologyGUI.this.log.fine("MetrologyGUI received MetrologyFullState reply");
                MetrologyGUI.this.UpdateMetrologyStatus(r.getMetrologyState());
                MetrologyGUI.this.enabled = true;
            }
        };
        return originator;
    }

    public void UpdateMetrologyStatus(MetrologyState rs) {
        System.out.println("UpdateMetrologyStatus called");
        if (rs != null) {
            int st = rs.getSystemState();
            this.tfState.setText(MetrologyConfig.operating_states.values()[rs.getOperState()].name());
            this.tfAcqTyp.setText(MetrologyConfig.configuration_states.values()[this.cfgstate].name());
            double posx = rs.getPosx();
            System.out.println("in updatemetrologystatus: posx =" + posx);
            this.tfPosX.setValue(posx);
            this.tfPosX.setEditable(false);
            if (this.tfPosXSet.getText() == null || this.tfPosXSet.getText().isEmpty()) {
                this.tfPosXSet.setValue(posx);
            }
            double posy = rs.getPosy();
            this.tfPosY.setValue(posy);
            this.tfPosY.setEditable(false);
            if (this.tfPosYSet.getText() == null || this.tfPosYSet.getText().isEmpty()) {
                this.tfPosYSet.setValue(posy);
            }
            double posz = rs.getPosz();
            this.tfPosZ.setValue(posz);
            this.tfPosZ.setEditable(false);
            if (this.tfPosZSet.getText() == null || this.tfPosZSet.getText().isEmpty()) {
                this.tfPosZSet.setValue(posz);
            }
            Color biasbgclr = Color.GREEN;
            double displacement1 = rs.getDisplacement1();
            this.tfKey1.setValue(displacement1);
            this.tfKey1.setEditable(false);
            double displacement2 = rs.getDisplacement2();
            this.tfKey2.setValue(displacement2);
            this.tfKey2.setEditable(false);
            if (this.first) {
                double nsamps = rs.getNsamples();
                this.tfKeynsamp.setValue(nsamps);
                this.tfKeynsamp.setEditable(true);
                double measmode = rs.getMeasmode();
                this.tfKeymode.setValue(measmode);
                this.tfKeymode.setEditable(true);
                double speed = rs.getSpeed();
                this.tfJoySpeed.setValue(speed);
                this.tfJoySpeed.setEditable(true);
            }
            this.display("MODES: 0:Normal, 1:TranslucentObject, 2:TransparentObject, 3:TransparentObject2 4:SemiOpaque - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(this.lastHeartBeat)));
            this.first = false;
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData ssd = (StatusSubsystemData)msg;
        KeyValueData msgObject = ssd.getSubsystemData();
        if (msgObject instanceof KeyValueData) {
            KeyValueData d = msgObject;
            System.out.println("MetrologyGUI: In onDataArrival method. KEY=" + d.getKey());
            if (d.getKey().equals("MetrologyState")) {
                System.out.println("MetrologyGui received MetrologyState message");
                SwingUtilities.invokeLater(() -> this.UpdateMetrologyStatus((MetrologyState)d.getValue()));
            }
        }
        this.lastHeartBeat = msg.getTimeStamp();
    }

    private void display(String message) {
        this.lbMessage.setFont(f);
        this.lbMessage.setForeground(YELLOW);
        this.lbMessage.setText(message);
    }

    private void initConfigs() {
        System.out.println("Now in initConfigs");
        btmetrologycfg.setText("cfg:" + MetrologyConfig.configuration_states.values()[this.cfgstate].name());
        boolean do_update = false;
        Object response = this.sendSyncMetrologyCommand(null, "getDisp_mode", new Object[0]);
        if (response != null) {
            this.DSPmode = (Integer)response;
            btKeyDSP.setText(MetrologyConfig.Displacement_Summing_Modes.values()[this.DSPmode].toString());
        }
    }

    private void initComponents() {
        lbmetrology.setFont(bigf);
        lbmetrologystate.setFont(f);
        lbmetrologyerr.setFont(f);
        btmetrologycfg.setFont(f);
        lbmetrologyscantyp.setFont(f);
        btmetrologyabrt.setFont(f);
        btmetrologyabrt.setForeground(RED);
        btmetrologyabrt.setBackground(BLACK);
        lbPosition.setFont(bigf);
        lbPosState.setFont(f);
        lbPosX.setFont(f);
        lbPosX.setOpaque(true);
        lbPosY.setFont(f);
        lbPosY.setOpaque(true);
        lbPosZ.setFont(f);
        lbPosZ.setOpaque(true);
        lbKey.setFont(bigf);
        lbKey.setOpaque(true);
        lbKeyState.setFont(f);
        lbKey1.setFont(f);
        lbKey2.setFont(f);
        lbKeynsamp.setFont(f);
        lbKeymode.setFont(f);
        btKeySS.setFont(f);
        btKeyDSP.setFont(f);
        this.metrologyPanel.setBorder(BorderFactory.createTitledBorder("LSST TESTSTAND 5 METROLOGY SUBSYSTEM V1.0"));
        this.metrologyPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcMetrology = new GridBagConstraints();
        gbcMetrology.insets = new Insets(4, 4, 4, 4);
        gbcMetrology.anchor = 11;
        gbcMetrology.gridx = 0;
        gbcMetrology.gridy = 0;
        ++gbcMetrology.gridy;
        BufferedImage img = null;
        try {
            img = ImageIO.read(BootstrapResourceUtils.getBootstrapResource((String)"LSST-logo2.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Image dimg = img.getScaledInstance(150, 60, 4);
        gbcMetrology.gridheight = 3;
        this.metrologyPanel.add((Component)new JLabel(new ImageIcon(dimg)), gbcMetrology);
        gbcMetrology.gridy += gbcMetrology.gridheight;
        gbcMetrology.gridheight = 1;
        this.metrologyPanel.add((Component)new JLabel("Metrology"), gbcMetrology);
        ++gbcMetrology.gridy;
        this.metrologyPanel.add((Component)new JLabel("Camera Ctrl Software"), gbcMetrology);
        ++gbcMetrology.gridy;
        this.metrologyPanel.add((Component)new JLabel("ccs@kipac.stanford.edu"), gbcMetrology);
        gbcMetrology.gridy = 0;
        ++gbcMetrology.gridx;
        this.metrologyPanel.add((Component)lbmetrology, gbcMetrology);
        ++gbcMetrology.gridy;
        this.metrologyPanel.add((Component)lbmetrologystate, gbcMetrology);
        ++gbcMetrology.gridy;
        Dimension d = this.tfState.getPreferredSize();
        d.width = 200;
        d.height = 30;
        this.tfState.setPreferredSize(d);
        this.tfState.setValue("STARTING");
        this.tfState.setFont(bigf);
        this.tfState.setEditable(false);
        this.metrologyPanel.add((Component)this.tfState, gbcMetrology);
        ++gbcMetrology.gridy;
        this.metrologyPanel.add((Component)lbmetrologyerr, gbcMetrology);
        ++gbcMetrology.gridy;
        d = this.tfErr.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfErr.setPreferredSize(d);
        this.tfErr.setValue("NONE");
        this.tfErr.setEditable(false);
        this.tfErr.setForeground(Color.BLACK);
        this.tfErr.setOpaque(true);
        this.metrologyPanel.add((Component)this.tfErr, gbcMetrology);
        ++gbcMetrology.gridy;
        this.metrologyPanel.add((Component)lbmetrologyscantyp, gbcMetrology);
        ++gbcMetrology.gridy;
        d = this.tfAcqTyp.getPreferredSize();
        d.width = 100;
        d.height = 30;
        this.tfAcqTyp.setPreferredSize(d);
        this.tfAcqTyp.setValue("UNKNOWN");
        this.tfAcqTyp.setEditable(false);
        this.metrologyPanel.add((Component)this.tfAcqTyp, gbcMetrology);
        gbcMetrology.gridy -= 4;
        ++gbcMetrology.gridx;
        this.metrologyPanel.add((Component)btmetrologylaser, gbcMetrology);
        btmetrologylaser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MetrologyGUI.this.laserstate) {
                    MetrologyGUI.this.sendSyncMetrologyCommand("Measurer", "laser", false);
                    btmetrologylaser.setText("LASER OFF");
                } else {
                    MetrologyGUI.this.sendSyncMetrologyCommand("Measurer", "laser", true);
                    btmetrologylaser.setText("LASER ON");
                }
                MetrologyGUI.this.laserstate = !MetrologyGUI.this.laserstate;
            }
        });
        ++gbcMetrology.gridy;
        this.metrologyPanel.add((Component)btmetrologyabrt, gbcMetrology);
        btmetrologyabrt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btmetrologyabrt.setForeground(BLACK);
                btmetrologyabrt.setBackground(RED);
                MetrologyGUI.this.sendSyncMetrologyCommand(null, "abortMotion", new Object[0]);
            }
        });
        ++gbcMetrology.gridy;
        this.metrologyPanel.add((Component)btmetrologyack, gbcMetrology);
        btmetrologyack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btmetrologyack.setBackground(GREEN);
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "reset", new Object[0]);
            }
        });
        ++gbcMetrology.gridy;
        this.metrologyPanel.add((Component)btmetrologyenableaxes, gbcMetrology);
        btmetrologyenableaxes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btmetrologyenableaxes.setBackground(GREEN);
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "enableAxes", new Object[0]);
            }
        });
        this.posPanel.setBorder(BorderFactory.createTitledBorder("POSITION and DISPLACEMENT"));
        this.posPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcBss = new GridBagConstraints();
        gbcBss.insets = new Insets(4, 4, 4, 4);
        gbcBss.anchor = 11;
        gbcBss.gridx = 0;
        gbcBss.gridy = 0;
        this.posPanel.add((Component)lbPosition, gbcBss);
        ++gbcBss.gridy;
        this.posPanel.add((Component)lbPosX, gbcBss);
        ++gbcBss.gridy;
        d = this.tfPosX.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfPosX.setPreferredSize(d);
        this.tfPosX.setValue("0.0");
        this.tfPosX.setEditable(false);
        this.posPanel.add((Component)this.tfPosX, gbcBss);
        ++gbcBss.gridy;
        this.posPanel.add((Component)lbPosXSet, gbcBss);
        ++gbcBss.gridy;
        d = this.tfPosXSet.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfPosXSet.setPreferredSize(d);
        this.posPanel.add((Component)this.tfPosXSet, gbcBss);
        this.tfPosXSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveAbs_x", MetrologyGUI.this.tfPosXSet.getValue());
            }
        });
        gbcBss.gridy -= 3;
        ++gbcBss.gridx;
        this.posPanel.add((Component)lbPosY, gbcBss);
        ++gbcBss.gridy;
        d = this.tfPosY.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfPosY.setPreferredSize(d);
        this.tfPosY.setValue("0.0");
        this.tfPosY.setEditable(false);
        this.posPanel.add((Component)this.tfPosY, gbcBss);
        ++gbcBss.gridy;
        this.posPanel.add((Component)lbPosYSet, gbcBss);
        ++gbcBss.gridy;
        d = this.tfPosYSet.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfPosYSet.setPreferredSize(d);
        this.posPanel.add((Component)this.tfPosYSet, gbcBss);
        this.tfPosYSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveAbs_y", MetrologyGUI.this.tfPosYSet.getValue());
            }
        });
        gbcBss.gridy -= 3;
        ++gbcBss.gridx;
        this.posPanel.add((Component)lbPosZ, gbcBss);
        ++gbcBss.gridy;
        d = this.tfPosZ.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfPosZ.setPreferredSize(d);
        this.tfPosZ.setValue("0.0");
        this.tfPosZ.setEditable(false);
        this.posPanel.add((Component)this.tfPosZ, gbcBss);
        ++gbcBss.gridy;
        this.posPanel.add((Component)lbPosZSet, gbcBss);
        ++gbcBss.gridy;
        d = this.tfPosZSet.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfPosZSet.setPreferredSize(d);
        this.posPanel.add((Component)this.tfPosZSet, gbcBss);
        this.tfPosZSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveAbs_z", MetrologyGUI.this.tfPosZSet.getValue());
            }
        });
        GridBagConstraints gbcDisp = new GridBagConstraints();
        gbcDisp.insets = new Insets(4, 4, 4, 4);
        gbcDisp.anchor = 11;
        gbcDisp.gridx = 0;
        gbcDisp.gridy = gbcBss.gridy + 1;
        this.posPanel.add((Component)lbKey, gbcDisp);
        ++gbcDisp.gridy;
        this.posPanel.add((Component)lbKey1, gbcDisp);
        ++gbcDisp.gridy;
        d = this.tfKey1.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfKey1.setPreferredSize(d);
        this.tfKey1.setValue(0.0);
        this.tfKey1.setEditable(false);
        this.posPanel.add((Component)this.tfKey1, gbcDisp);
        --gbcDisp.gridy;
        ++gbcDisp.gridx;
        this.posPanel.add((Component)lbKey2, gbcDisp);
        ++gbcDisp.gridy;
        d = this.tfKey2.getPreferredSize();
        d.width = 100;
        d.height = 15;
        this.tfKey2.setPreferredSize(d);
        this.tfKey2.setValue(0.0);
        this.tfKey2.setEditable(false);
        this.posPanel.add((Component)this.tfKey2, gbcDisp);
        gbcDisp.gridy -= 2;
        ++gbcDisp.gridx;
        this.posPanel.add((Component)lbKeynsamp, gbcDisp);
        ++gbcDisp.gridy;
        d = this.tfKeynsamp.getPreferredSize();
        d.width = 60;
        d.height = 15;
        this.tfKeynsamp.setPreferredSize(d);
        this.tfKeynsamp.setEditable(true);
        this.posPanel.add((Component)this.tfKeynsamp, gbcDisp);
        this.tfKeynsamp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Measurer", "setcycles", Integer.parseInt(MetrologyGUI.this.tfKeynsamp.getText()));
            }
        });
        ++gbcDisp.gridy;
        this.posPanel.add((Component)lbKeymode, gbcDisp);
        ++gbcDisp.gridy;
        d = this.tfKeymode.getPreferredSize();
        d.width = 60;
        d.height = 15;
        this.tfKeymode.setPreferredSize(d);
        this.tfKeymode.setEditable(true);
        this.posPanel.add((Component)this.tfKeymode, gbcDisp);
        this.tfKeymode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Measurer", "setmeasmode", Integer.parseInt(MetrologyGUI.this.tfKeymode.getText()));
            }
        });
        ++gbcDisp.gridx;
        this.posPanel.add((Component)btKeySS, gbcDisp);
        btKeySS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.SSmode = MetrologyConfig.ScanMode.values()[(MetrologyGUI.this.SSmode.ordinal() + 1) % 3];
                btKeySS.setText(MetrologyGUI.this.SSmode.name());
            }
        });
        --gbcDisp.gridy;
        this.posPanel.add((Component)btKeyDSP, gbcDisp);
        btKeyDSP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.DSPmode = (MetrologyGUI.this.DSPmode + 1) % 4;
                MetrologyGUI.this.sendSyncMetrologyCommand(null, "setDisp_mode", Integer.toString(MetrologyGUI.this.DSPmode));
                btKeyDSP.setText(MetrologyConfig.Displacement_Summing_Modes.values()[MetrologyGUI.this.DSPmode].toString());
            }
        });
        ++gbcDisp.gridy;
        gbcDisp.gridx -= 2;
        btreps.setForeground(BLUE);
        btreps.setBackground(WHITE);
        this.posPanel.add((Component)btreps, gbcDisp);
        d = this.tfnreps.getPreferredSize();
        d.width = 100;
        d.height = 30;
        this.tfnreps.setPreferredSize(d);
        this.tfnreps.setValue(this.nreps);
        d = this.tfperiod.getPreferredSize();
        d.width = 100;
        d.height = 30;
        this.tfperiod.setPreferredSize(d);
        this.tfperiod.setValue(this.period);
        d = this.tfrepfln.getPreferredSize();
        d.width = 350;
        d.height = 30;
        this.tfrepfln.setPreferredSize(d);
        this.tfrepfln.setText(this.RepFln);
        btreps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.frmreps = new JFrame("Repetitions:");
                JPanel pnlreps = new JPanel();
                MetrologyGUI.this.frmreps.setContentPane(pnlreps);
                MetrologyGUI.this.frmreps.setDefaultCloseOperation(2);
                MetrologyGUI.this.frmreps.setTitle("Do Keyence Repeat Readings");
                MetrologyGUI.this.frmreps.setSize(1200, 300);
                MetrologyGUI.this.frmreps.setLocationRelativeTo(null);
                GridBagConstraints gbcRep = new GridBagConstraints();
                gbcRep.insets = new Insets(4, 4, 4, 4);
                gbcRep.anchor = 11;
                gbcRep.gridx = 0;
                gbcRep.gridy = 0;
                pnlreps.add((Component)new JLabel("Number of repetitions:"), gbcRep);
                ++gbcRep.gridy;
                pnlreps.add((Component)MetrologyGUI.this.tfnreps, gbcRep);
                MetrologyGUI.this.tfnreps.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MetrologyGUI.this.nreps = Integer.parseInt(MetrologyGUI.this.tfnreps.getText());
                        MetrologyGUI.this.log.info("setting nreps to " + MetrologyGUI.this.nreps);
                    }
                });
                ++gbcRep.gridy;
                pnlreps.add((Component)new JLabel("Period between readings:"), gbcRep);
                ++gbcRep.gridy;
                pnlreps.add((Component)MetrologyGUI.this.tfperiod, gbcRep);
                MetrologyGUI.this.tfperiod.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MetrologyGUI.this.period = Double.parseDouble(MetrologyGUI.this.tfperiod.getText());
                        MetrologyGUI.this.log.info("setting period to " + MetrologyGUI.this.period + " seconds");
                    }
                });
                ++gbcRep.gridy;
                pnlreps.add((Component)new JLabel("Filename:"), gbcRep);
                ++gbcRep.gridy;
                pnlreps.add((Component)MetrologyGUI.this.tfrepfln, gbcRep);
                MetrologyGUI.this.tfrepfln.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MetrologyGUI.this.RepFln = MetrologyGUI.this.tfrepfln.getText();
                    }
                });
                ++gbcRep.gridy;
                final JButton goreps = new JButton("GO");
                pnlreps.add((Component)goreps, gbcRep);
                goreps.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        goreps.setText("running w/ n=" + MetrologyGUI.this.nreps + ",t=" + MetrologyGUI.this.period + "s");
                        MetrologyGUI.this.sendASyncMetrologyCommand(null, "doreps", MetrologyGUI.this.RepFln, MetrologyGUI.this.nreps, MetrologyGUI.this.period);
                    }
                });
                MetrologyGUI.this.frmreps.setVisible(true);
            }
        });
        this.joyPanel.setBorder(BorderFactory.createTitledBorder("POSITIONING"));
        this.joyPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcJoy = new GridBagConstraints();
        gbcJoy.insets = new Insets(4, 4, 4, 4);
        gbcJoy.anchor = 11;
        gbcJoy.gridx = 0;
        gbcJoy.gridy = 0;
        this.joyPanel.add((Component)lbJoy, gbcJoy);
        ++gbcJoy.gridy;
        d = this.tfJoy.getPreferredSize();
        d.width = 60;
        d.height = 15;
        this.tfJoy.setPreferredSize(d);
        this.tfJoy.setText(Double.toString(this.stepScale));
        this.joyPanel.add((Component)this.tfJoy, gbcJoy);
        this.tfJoy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.stepScale = Double.parseDouble(MetrologyGUI.this.tfJoy.getText());
                System.out.println("setting stepScale = " + MetrologyGUI.this.stepScale);
            }
        });
        gbcJoy.gridx += 2;
        this.joyPanel.add((Component)btJoyFL1, gbcJoy);
        --gbcJoy.gridy;
        this.joyPanel.add((Component)btJoyFL7, gbcJoy);
        ++gbcJoy.gridy;
        ++gbcJoy.gridy;
        --gbcJoy.gridx;
        this.joyPanel.add((Component)btJoyFL3, gbcJoy);
        gbcJoy.gridx += 2;
        this.joyPanel.add((Component)btJoyFL4, gbcJoy);
        ++gbcJoy.gridy;
        --gbcJoy.gridx;
        this.joyPanel.add((Component)btJoyFL2, gbcJoy);
        ++gbcJoy.gridy;
        this.joyPanel.add((Component)btJoyFL8, gbcJoy);
        gbcJoy.gridy -= 2;
        this.joyPanel.add((Component)btJoyFL9, gbcJoy);
        gbcJoy.gridx -= 2;
        this.joyPanel.add((Component)btJoyFL5, gbcJoy);
        ++gbcJoy.gridy;
        this.joyPanel.add((Component)lbJoySpeed, gbcJoy);
        ++gbcJoy.gridy;
        d = this.tfJoySpeed.getPreferredSize();
        d.width = 60;
        d.height = 15;
        this.tfJoySpeed.setPreferredSize(d);
        this.joyPanel.add((Component)this.tfJoySpeed, gbcJoy);
        this.tfJoySpeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "setSpeed", Double.parseDouble(MetrologyGUI.this.tfJoySpeed.getText()));
            }
        });
        gbcJoy.gridy -= 2;
        gbcJoy.gridx += 4;
        this.joyPanel.add((Component)btJoyFL6, gbcJoy);
        gbcJoy.gridy -= 2;
        this.joyPanel.add((Component)btJoyFL10, gbcJoy);
        ++gbcJoy.gridy;
        this.joyPanel.add((Component)btJoyFL11, gbcJoy);
        btJoyFL1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_y", MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_y", -MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_x", -MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_x", MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_x", -5.0 * MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_x", 5.0 * MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_y", 5.0 * MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_y", -5.0 * MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "goHome", new Object[0]);
            }
        });
        btJoyFL10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_z", -MetrologyGUI.this.stepScale);
            }
        });
        btJoyFL11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand("Positioner", "moveInc_z", MetrologyGUI.this.stepScale);
            }
        });
        this.extPanel.setBorder(BorderFactory.createTitledBorder("Scanning"));
        this.extPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcExt = new GridBagConstraints();
        gbcExt.insets = new Insets(4, 4, 4, 4);
        gbcExt.anchor = 11;
        gbcExt.gridx = 0;
        gbcExt.gridy = 0;
        this.initConfigs();
        ++gbcExt.gridy;
        btacqimage.setForeground(BLUE);
        btacqimage.setBackground(GREEN);
        this.extPanel.add((Component)btacqimage, gbcExt);
        btacqimage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.sendSyncMetrologyCommand(null, "setCfgState", MetrologyGUI.this.cfgstate);
                MetrologyGUI.this.fltimestamp = System.currentTimeMillis();
                if (MetrologyGUI.this.SSmode == MetrologyConfig.ScanMode.StepScan) {
                    MetrologyGUI.this.sendASyncMetrologyCommand(null, "scanfl", MetrologyGUI.this.fields(MetrologyGUI.this.out_fln, MetrologyGUI.this.fltimestamp));
                }
                if (MetrologyGUI.this.SSmode == MetrologyConfig.ScanMode.NoStepScan) {
                    MetrologyGUI.this.sendASyncMetrologyCommand(null, "noStepScan", MetrologyGUI.this.fields(MetrologyGUI.this.out_fln, MetrologyGUI.this.fltimestamp));
                }
                if (MetrologyGUI.this.SSmode == MetrologyConfig.ScanMode.PointList) {
                    MetrologyGUI.this.sendASyncMetrologyCommand(null, "scanPL", MetrologyGUI.this.fields(MetrologyGUI.this.out_fln, MetrologyGUI.this.fltimestamp));
                }
            }
        });
        ++gbcExt.gridy;
        this.extPanel.add((Component)lbfln, gbcExt);
        ++gbcExt.gridy;
        d = this.tffln.getPreferredSize();
        d.width = 400;
        d.height = 20;
        this.tffln.setPreferredSize(d);
        this.tffln.setText(this.out_fln);
        this.tffln.setEditable(true);
        this.extPanel.add((Component)this.tffln, gbcExt);
        this.tffln.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetrologyGUI.this.out_fln = MetrologyGUI.this.tffln.getText();
            }
        });
        ++gbcExt.gridy;
        btplot.setForeground(BLUE);
        btplot.setBackground(WHITE);
        this.extPanel.add((Component)btplot, gbcExt);
        btplot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MetrologyGUI.this.sendSyncMetrologyCommand(null, "plotscan", new Object[0]);
                }
                catch (Exception ex) {
                    MetrologyGUI.this.log.info("plotscan failed on error: " + ex);
                }
                MetrologyGUI.this.dopyplot();
            }
        });
        ++gbcExt.gridy;
        this.extPanel.add((Component)lbconfig, gbcExt);
        ++gbcExt.gridy;
        this.extPanel.add((Component)btmetrologycfg, gbcExt);
        btmetrologycfg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] states = new String[MetrologyConfig.configuration_states.values().length];
                for (MetrologyConfig.configuration_states iwstate : MetrologyConfig.configuration_states.values()) {
                    states[iwstate.ordinal()] = iwstate.name();
                }
                if (states != null) {
                    DefaultListModel<String> listModel = new DefaultListModel<String>();
                    for (String state : states) {
                        listModel.addElement(state);
                    }
                    final JList stateList = new JList(listModel);
                    stateList.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (!e.getValueIsAdjusting()) {
                                List selectedValuesList = stateList.getSelectedValuesList();
                                System.out.println(selectedValuesList);
                                String selectedstate = (String)selectedValuesList.get(0);
                                try {
                                    MetrologyGUI.this.log.info("Switching to " + selectedstate);
                                    MetrologyGUI.this.cfgstate = MetrologyConfig.configuration_states.valueOf((String)selectedstate).ordinal();
                                    btmetrologycfg.setText("cfg:" + MetrologyConfig.configuration_states.values()[MetrologyGUI.this.cfgstate].name());
                                    MetrologyGUI.this.plcfg.dispose();
                                }
                                catch (Exception g) {
                                    MetrologyGUI.this.log.info("State change failed");
                                }
                            }
                        }
                    });
                    MetrologyGUI.this.plcfg = new JFrame("Select a state:");
                    MetrologyGUI.this.plcfg.add(stateList);
                    MetrologyGUI.this.plcfg.setDefaultCloseOperation(2);
                    MetrologyGUI.this.plcfg.setTitle("Config State");
                    MetrologyGUI.this.plcfg.setSize(200, 200);
                    MetrologyGUI.this.plcfg.setLocationRelativeTo(null);
                    MetrologyGUI.this.plcfg.add(new JScrollPane(stateList));
                    stateList.setSelectionMode(0);
                    MetrologyGUI.this.plcfg.setVisible(true);
                }
            }
        });
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.panel.setBackground(new Color(20, 20, 20));
        this.panel.add((Component)this.metrologyPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.posPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.panel.add((Component)this.joyPanel, gbc);
        ++gbc.gridx;
        this.panel.add((Component)this.extPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.anchor = 11;
        this.panel.add((Component)this.lbMessage, gbc);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JComponent getGuiLayout() {
        return this.panel;
    }

    public void resetGui() {
    }

    protected Object sendSyncMetrologyCommand(String target, String name, Object ... params) {
        String dest = target == null ? this.metrology_dest : this.metrology_dest + "/" + target;
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(dest, name, params);
        try {
            return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(1440000L));
        }
        catch (Exception e) {
            this.log.warning("Unable to perform jgroup communication with destination + " + dest + " - Exception " + e);
            return null;
        }
    }

    protected Object sendASyncMetrologyCommand(String target, String name, Object ... params) {
        String dest = target == null ? this.metrology_dest : this.metrology_dest + "/" + target;
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(dest, name, params);
        try {
            return cmu.sendAsynchronousCommand(cmd);
        }
        catch (Exception e) {
            this.log.warning("Unable to perform jgroup communication with destination + " + dest + " - Exception " + e);
            return null;
        }
    }

    void updateConfig() {
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Failed to launch the link, your computer is likely misconfigured.", "Cannot Launch Link", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Java is not able to launch links on your computer.", "Cannot Launch Link", 2);
        }
    }

    private String fields(String fitsFileName, Long timestamp) {
        return fitsFileName.replace("${timestamp}", String.valueOf(timestamp)).replace("${TIMESTAMP}", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(timestamp)));
    }

    void dopyplot() {
        String surfpath = "/opt/lsst/redhat6-x86_64-64bit-gcc44/lsst-utils/ts5/ts5_plot.sh " + this.fields(this.out_fln, this.fltimestamp);
        this.log.info("Executing: plot_surf " + surfpath);
        try {
            Runtime.getRuntime().exec(surfpath);
        }
        catch (IOException ex) {
            Logger.getLogger(MetrologyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        typeMap.put("red", RED);
        typeMap.put("green", GREEN);
        typeMap.put("blue", BLUE);
        typeMap.put("yellow", YELLOW);
        typeMap.put("empty", WHITE);
        typeMap.put("RED", RED);
        typeMap.put("GREEN", GREEN);
        typeMap.put("BLUE", BLUE);
        typeMap.put("YELLOW", YELLOW);
        typeMap.put("EMPTY", WHITE);
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

