package org.lsst.ccs.subsystem.metrology.ui;

import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import java.io.IOException;
import java.io.FilenameFilter;

//import org.lsst.ccs.bus.Command;
//import org.lsst.ccs.bus.TrendingStatus;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Toolkit;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;

import org.lsst.ccs.bus.data.KeyValueData;
//import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
//import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;

import org.lsst.ccs.subsystem.metrology.data.MetrologyFullState;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;

import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
//import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
//import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;

import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

/**
 ***************************************************************************
 **
 ** GUI for the Metrology subsystem
 *
 * @author Homer Neal
 * **************************************************************************
 */
public class MetrologyGUI implements StatusMessageListener, AgentPresenceListener {

    private String metrology_dest = "metrology";
//    private PrintWriter out = new PrintWriter(System.out, true);
    private MonitorTrendingTable table;
    private long lastHeartBeat = 0, lastStateRequest = 0;
    private boolean enabled = false;
//    String stateCorrelId;
    private String out_fln = "/home/ts5prod/scans/Metrology_Scan_Data_${TIMESTAMP}.csv";
    private static final long serialVersionUID = -8352262068369045572L;
    private static final Map<Integer, String> pStateMap = new HashMap<>();

    private static final String NB_SPACE = "\u00a0";

    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    final static Font f = new java.awt.Font("Tahoma", 1, 14);
    final static Font bigf = new java.awt.Font("Tahoma", 1, 16);

//    private static final JLabel lbext = new JLabel("External Functions");
    private static final JLabel lbmetrology = new JLabel("Subsystem Status");
    private static final JLabel lbmetrologystate = new JLabel("STATE");
    private static final JLabel lbmetrologyerr = new JLabel("ERRORS");
    private static final JButton btmetrologycfg = new JButton("RTM");
    private static final JButton btmetrologylaser = new JButton("LASER ON");
    private static final JButton btmetrologyabrt = new JButton("ABORT SCAN!");
    private static final JButton btmetrologyack = new JButton("ACKNWLDG ERRS");
    private static final JButton btmetrologyenableaxes = new JButton("ENABLE AXES");
    private static final JLabel lbmetrologyscantyp = new JLabel("SCAN TYPE");

    private static final JLabel lbPosition = new JLabel("Aerotech");
    private static final JLabel lbPosState = new JLabel("State");
    private static final JLabel lbPosX = new JLabel("X (mm)");
    private static final JLabel lbPosY = new JLabel("Y (mm)");
    private static final JLabel lbPosZ = new JLabel("Z (mm)");
    private static final JLabel lbPosXSet = new JLabel("Set X (mm)");
    private static final JLabel lbPosYSet = new JLabel("Set Y (mm)");
    private static final JLabel lbPosZSet = new JLabel("Set Z (mm)");
    private static final JLabel lbPosSpeed = new JLabel("Set Speed");

    private static final JLabel lbKey = new JLabel("Keyence");
    private static final JLabel lbKeyState = new JLabel("State");
    private static final JLabel lbKey1 = new JLabel("Head1 (mm)");
    private static final JLabel lbKey2 = new JLabel("Head2 (mm)");
    private static final JLabel lbKeynsamp = new JLabel("Cycle Mode");
    private static final JLabel lbKeymode = new JLabel("Surface Mode");
    private static final JLabel lbJoySpeed = new JLabel("Speed");
//    private static final JLabel lbKeyTacq = new JLabel("Acq. DispT Set Point");

    private static final JLabel lbJoy = new JLabel("step (mm):");

    private static final JButton btKeyDSP = new JButton("DispSumMode");
    private static final JButton btKeySS = new JButton("StepScanMode");
    private static final JButton btJoyFL1 = new JButton("up");
    private static final JButton btJoyFL2 = new JButton("down");
    private static final JButton btJoyFL3 = new JButton("left");
    private static final JButton btJoyFL4 = new JButton("right");
    private static final JButton btJoyFL5 = new JButton("left 5 steps");
    private static final JButton btJoyFL6 = new JButton("right 5 steps");
    private static final JButton btJoyFL7 = new JButton("up 5 steps");
    private static final JButton btJoyFL8 = new JButton("down 5 steps");
    private static final JButton btJoyFL9 = new JButton("home");
    private static final JButton btJoyFL10 = new JButton("step in");
    private static final JButton btJoyFL11 = new JButton("step out");
    private static final JButton btacqimage = new JButton("PERFORM SURFACE SCAN");
    private static final JButton btreps = new JButton("do reps");
    private static final JButton btplot = new JButton("plot");
    private static final JLabel lbfln = new JLabel("filename:");
    final private JFormattedTextField tffln = new JFormattedTextField();

//    private static final JButton btetrv = new JButton("eTraveler");
    private static final JLabel lbconfig = new JLabel("Configuration");
//    private static final JButton btSaveConfig = new JButton("Save Config");
    final private JLabel lbMessage = new JLabel(NB_SPACE);
//    private SynchronousCommandAgent ca;
    final private JPanel panel = new JPanel();
    final private JPanel metrologyPanel = new JPanel();
    final private JPanel posPanel = new JPanel();
    final private JPanel dispPanel = new JPanel();
    final private JPanel joyPanel = new JPanel();
    final private JPanel extPanel = new JPanel();

    final private NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
    final private NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.0##"));
    final private NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.0###E00"));
    final private JFormattedTextField tfState = new JFormattedTextField();
    final private JFormattedTextField tfErr = new JFormattedTextField();
    final private JFormattedTextField tfAcqTyp = new JFormattedTextField();
    final private JFormattedTextField tfPosXState = new JFormattedTextField();
    final private JFormattedTextField tfPosX = new JFormattedTextField();
    final private JFormattedTextField tfPosY = new JFormattedTextField();
    final private JFormattedTextField tfPosZ = new JFormattedTextField();
//    final private JFormattedTextField tfPosXV = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfJoy = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfPosXSet = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfPosYSet = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfPosZSet = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfJoySpeed = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfPDI = new JFormattedTextField(fmt5e);
    final private JFormattedTextField tfKeyState = new JFormattedTextField();
    final private JFormattedTextField tfKey1 = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfKey2 = new JFormattedTextField(fmt5d);
    final private JFormattedTextField tfKeynsamp = new JFormattedTextField(fmt5);
    final private JFormattedTextField tfKeymode = new JFormattedTextField(fmt5);
    final private JFormattedTextField tfKeyTacq = new JFormattedTextField(fmt5d);

    JFormattedTextField tfnreps = new JFormattedTextField(fmt5);
    JFormattedTextField tfperiod = new JFormattedTextField(fmt5d);
    JFormattedTextField tfrepfln = new JFormattedTextField();

//    private final MonitorAssembly mon;
    final static Color RED = new Color(150, 0, 0), GREEN = new Color(0, 150, 0),
            BLUE = new Color(0, 0, 150), WHITE = new Color(150, 150, 150),
            YELLOW = new Color(200, 200, 0),
            BLACK = new Color(0, 0, 0), GREY = new Color(80, 80, 80);

    private final static Map<String, Color> typeMap = new HashMap<>();

    private JFrame pl = null;
    private JFrame plcfg = null;
    private JFrame frmreps = null;

//    private boolean SSmode = true;
    MetrologyConfig.ScanMode SSmode = MetrologyConfig.ScanMode.StepScan;
    private int DSPmode = MetrologyConfig.Displacement_Summing_Modes.NormalDispSum.ordinal(); // displacement summing mode

    static {
        typeMap.put("red", RED);
        typeMap.put("green", GREEN);
        typeMap.put("blue", BLUE);
        typeMap.put("yellow", YELLOW);
        typeMap.put("empty", WHITE);
        typeMap.put("RED", RED);
        typeMap.put("GREEN", GREEN);
        typeMap.put("BLUE", BLUE);
        typeMap.put("YELLOW", YELLOW);
        typeMap.put("EMPTY", WHITE);
    }
    private long fltimestamp = 0;

    public enum onOff {

        OFF, ON;
    }

    private double stepScale = 1.0;
    private int cfgstate = MetrologyConfig.configuration_states.RTM.ordinal();
    private int nreps = 100; // number of readings for the stability test
    private double period = 1.0; // period between readings
    private String RepFln = "/home/ts5prod/repetitions.dat";

    private boolean laserstate = true;
    boolean shstate = false;
    String lastpath = "";
    private boolean first = true;

    private final AgentMessagingLayer agentMessagingLayer;
    private final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI");

    /**
     ***************************************************************************
     **
     ** Constructor *
     * **************************************************************************
     */
    public MetrologyGUI(AgentMessagingLayer agentMessagingLayer) {
        System.out.println("MetrologyGUI: Retrieving metrology name on the bus from property lsst.ccs.metrology.metrologyguidest");
        metrology_dest = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        this.agentMessagingLayer = agentMessagingLayer;
//        mon = new MonitorAssembly(this);
    }

    public void main(String[] args) throws ClassNotFoundException {
        System.out.println("starting MetrologyGUI main");

        metrology_dest = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");

        initGui();
        System.out.println("past initGui");

        JPanel xpane = new JPanel();
        xpane.setLayout(new BorderLayout());
        xpane.add(getPanel(), BorderLayout.CENTER);

        final JFrame f = new JFrame("Metrology Console");
        f.setContentPane(xpane);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        f.pack();
        f.setVisible(true);

    }

    public void initGui() {
        System.out.println("initGui: Retrieving metrology name on the bus from property lsst.ccs.metrology.metrologyguidest");
        metrology_dest = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        System.out.println("metrology_dest = " + metrology_dest);
//        mon.setSubsystems(metrology_dest);

        initComponents();

//        table = new MonitorTrendingTable(this);
//        agentMessagingLayer.addStatusMessageListener(guiStatusListener);
        // register ourselves as a status listener of StatusSubsystemData coming from metrology_dest only
//        BusMessageFilter filterConfig = BusMessageFilter.messageOrigin(metrology_dest).and(BusMessageFilter.messageClass(StatusConfigurationInfo.class));
        agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener(this);
        Predicate<BusMessage<? extends Serializable, ?>> filter = BusMessageFilterFactory.messageOrigin(metrology_dest).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        agentMessagingLayer.addStatusMessageListener(this, filter);

    }

    @Override
    public void connecting(AgentInfo agent) {
        //Initialize the GUI when the metrology subsystem connects to the buses
        if (agent.getName().equals(metrology_dest)) {
            initConfigs();
        }
    }

    @Override
    public void disconnecting(AgentInfo agent) {
        tfState.setText(MetrologyConfig.operating_states.DOWN.name());
        //Put code here to reset the GUI when the metrology subsystem disconnects from the buses
    }

    private CommandOriginator getCommandOriginator() {
        CommandOriginator originator = new CommandOriginator() {

            @Override
            public void processAck(CommandAck ack) {
            }

//            @Override
//            public void processError(CommandError nack) {
//            }
            @Override
            public void processNack(CommandNack nack) {
            }

            @Override
            public void processResult(CommandResult result) {
                MetrologyFullState r = (MetrologyFullState) result.getReply();
                log.fine("MetrologyGUI received MetrologyFullState reply");
                UpdateMetrologyStatus(r.getMetrologyState());
//        panel.updateTime();
                enabled = true;
            }

        };
        return originator;
    }

//    public void sendCommandx(String dest, String target, String cmnd,
//            Object... args) {
//        stateCorrelId = sendCommand(dest, target, cmnd,
//                args);
//    }
//    @Override
//    public void sendCommand(String target, Command cmd) {
//        String dest = target == null ? metrology_dest : metrology_dest + "/" + target;
//        cmd.setDestination(dest);
////        Command cmd = new ModuleInvokerCommand("", 0, dest, cmnd, args);
//        updateCurrentSubsystem();
//        fac.sendCommand(cmd);
//        stateCorrelId = cmd.getCorrelId();
//    }
    public void UpdateMetrologyStatus(MetrologyState rs) {
        System.out.println("UpdateMetrologyStatus called");
        if (rs != null) {
            int st = rs.getSystemState();

            tfState.setText(MetrologyConfig.operating_states.values()[rs.getOperState()].name());
            tfAcqTyp.setText(MetrologyConfig.configuration_states.values()[cfgstate].name());
            double posx = rs.getPosx();
            System.out.println("in updatemetrologystatus: posx =" + posx);
            tfPosX.setValue(posx);
            tfPosX.setEditable(false);
            double posy = rs.getPosy();
            tfPosY.setValue(posy);
            tfPosY.setEditable(false);
            double posz = rs.getPosz();
            tfPosZ.setValue(posz);
            tfPosZ.setEditable(false);
            Color biasbgclr = Color.GREEN;

            double displacement1 = rs.getDisplacement1();
            tfKey1.setValue(displacement1);
            tfKey1.setEditable(false);

            double displacement2 = rs.getDisplacement2();
            tfKey2.setValue(displacement2);
            tfKey2.setEditable(false);

            if (first) {
                double nsamps = rs.getNsamples();
                tfKeynsamp.setValue(nsamps);
                tfKeynsamp.setEditable(true);

                double measmode = rs.getMeasmode();
                tfKeymode.setValue(measmode);
                tfKeymode.setEditable(true);

                double speed = rs.getSpeed();
                tfJoySpeed.setValue(speed);
                tfJoySpeed.setEditable(true);
            }
//            display("<html>Last heart beat at - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(lastHeartBeat)) + "<br>"
//                    + last_warning + "</html>");
            display("MODES: 0:Normal, 1:TranslucentObject, 2:TransparentObject, "
                    + "3:TransparentObject2 4:SemiOpaque - " + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(lastHeartBeat)));

            first = false;
        }
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
//        System.out.println("GUI: In onDataArrival method and the source is "+source);

        StatusSubsystemData ssd = (StatusSubsystemData) msg;
        Object msgObject = ssd.getSubsystemData();
        if (msgObject instanceof KeyValueData) {
            KeyValueData d = (KeyValueData) msgObject;
            System.out.println("MetrologyGUI: In onDataArrival method. KEY=" + d.getKey());
            if (d.getKey().equals(MetrologyState.KEY)) {
                System.out.println("MetrologyGui received MetrologyState message");
//            UpdateMetrologyStatus(((MetrologyStateStatus) d).getMetrologyState());
                UpdateMetrologyStatus((MetrologyState) d.getValue());
            }

        }

//        mon.handleData(metrology_dest, ssd.getDataKey(), ssd.getSubsystemData());
        lastHeartBeat = msg.getTimeStamp();
    }

    private void display(String message) {
        lbMessage.setFont(f);
        lbMessage.setForeground(YELLOW);
        lbMessage.setText(message);
    }

    private void initConfigs() {
        System.out.println("Now in initConfigs");
        btmetrologycfg.setText("cfg:" + MetrologyConfig.configuration_states.values()[cfgstate].name());

        boolean do_update = false;

        Object response = sendSyncMetrologyCommand("Positioner", "getPos_x");
        double runPosX = 0.0;
        if (response != null) {
            runPosX = (double) response;
        }
        tfPosXSet.setValue(runPosX);

        response = sendSyncMetrologyCommand("Positioner", "getPos_y");
        double runPosY = 0.0;
        if (response != null) {
            runPosY = (double) response;
        }
        tfPosYSet.setValue(runPosY);

        response = sendSyncMetrologyCommand("Positioner", "getPos_z");
        double runPosZ = 0.0;
        if (response != null) {
            runPosZ = (double) response;
        }
        tfPosZSet.setValue(runPosZ);

        response = sendSyncMetrologyCommand(null, "getDisp_mode");
        if (response != null) {
            DSPmode = (int) response;
            btKeyDSP.setText(MetrologyConfig.Displacement_Summing_Modes.values()[DSPmode].toString());

        }

    }

    private void initComponents() {

        lbmetrology.setFont(bigf);
        lbmetrologystate.setFont(f);
        lbmetrologyerr.setFont(f);
        btmetrologycfg.setFont(f);
        lbmetrologyscantyp.setFont(f);
//        btmetrologycfg.setForeground(BLACK);
//        btmetrologycfg.setBackground(WHITE);
        btmetrologyabrt.setFont(f);
        btmetrologyabrt.setForeground(RED);
        btmetrologyabrt.setBackground(BLACK);

        lbPosition.setFont(bigf);
        lbPosState.setFont(f);
        lbPosX.setFont(f);
        lbPosX.setOpaque(true);
        lbPosY.setFont(f);
        lbPosY.setOpaque(true);
        lbPosZ.setFont(f);
        lbPosZ.setOpaque(true);

        lbKey.setFont(bigf);
        lbKey.setOpaque(true);
        lbKeyState.setFont(f);
        lbKey1.setFont(f);
        lbKey2.setFont(f);
        lbKeynsamp.setFont(f);
        lbKeymode.setFont(f);
        btKeySS.setFont(f);
        btKeyDSP.setFont(f);


        /*
         **  Metrology overall state sub-panel
         */
        metrologyPanel.setBorder(BorderFactory.createTitledBorder("LSST TESTSTAND 5 METROLOGY SUBSYSTEM V1.0"));
        metrologyPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcMetrology = new GridBagConstraints();
        gbcMetrology.insets = new Insets(4, 4, 4, 4);
        gbcMetrology.anchor = GridBagConstraints.NORTH;
        gbcMetrology.gridx = 0;
        gbcMetrology.gridy = 0;

        gbcMetrology.gridy++;

        BufferedImage img = null;
        try {
            img = ImageIO.read(BootstrapResourceUtils.getBootstrapResource("LSST-logo2.png"));
        } catch (IOException e) {
            e.printStackTrace();
        }

        Image dimg = img.getScaledInstance(150, 60, Image.SCALE_SMOOTH);
        gbcMetrology.gridheight = 3;
        metrologyPanel.add(new JLabel(new ImageIcon(dimg)), gbcMetrology);
        gbcMetrology.gridy += gbcMetrology.gridheight;
        gbcMetrology.gridheight = 1;
        metrologyPanel.add(new JLabel("Metrology"), gbcMetrology);
        gbcMetrology.gridy++;
        metrologyPanel.add(new JLabel("Camera Ctrl Software"), gbcMetrology);
        gbcMetrology.gridy++;
        metrologyPanel.add(new JLabel("ccs@kipac.stanford.edu"), gbcMetrology);

        gbcMetrology.gridy = 0;
        gbcMetrology.gridx++;

        metrologyPanel.add(lbmetrology, gbcMetrology);

        /* ******* Metrology state ******* */
        gbcMetrology.gridy++;
        metrologyPanel.add(lbmetrologystate, gbcMetrology);
        gbcMetrology.gridy++;
        Dimension d = tfState.getPreferredSize();
        d.width = 200;
        d.height = 30;
        tfState.setPreferredSize(d);
        tfState.setValue("STARTING");
        tfState.setFont(bigf);
        tfState.setEditable(false);
        metrologyPanel.add(tfState, gbcMetrology);

        gbcMetrology.gridy++;

        /* ******* Metrology error ******* */
//        gbcMetrology.gridy++;
        metrologyPanel.add(lbmetrologyerr, gbcMetrology);
        gbcMetrology.gridy++;
        d = tfErr.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfErr.setPreferredSize(d);
        tfErr.setValue("NONE");
        tfErr.setEditable(false);
        tfErr.setForeground(Color.BLACK);
        tfErr.setOpaque(true);

        metrologyPanel.add(tfErr, gbcMetrology);

        /* ******* Metrology ACQ Type ******* */
        gbcMetrology.gridy++;
        metrologyPanel.add(lbmetrologyscantyp, gbcMetrology);
        gbcMetrology.gridy++;
        d = tfAcqTyp.getPreferredSize();
        d.width = 100;
        d.height = 30;
        tfAcqTyp.setPreferredSize(d);
        tfAcqTyp.setValue("UNKNOWN");
        tfAcqTyp.setEditable(false);
        metrologyPanel.add(tfAcqTyp, gbcMetrology);

        /* ******* Metrology Laser on/off button ***** */
        gbcMetrology.gridy -= 4;
        gbcMetrology.gridx++;
        metrologyPanel.add(btmetrologylaser, gbcMetrology);
        btmetrologylaser.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (laserstate) {
                    sendSyncMetrologyCommand("Measurer", "laser", false);
                    btmetrologylaser.setText("LASER OFF");
                } else {
                    sendSyncMetrologyCommand("Measurer", "laser", true);
                    btmetrologylaser.setText("LASER ON");
                }

                laserstate = !laserstate;

            }
        });

        /* ******* Metrology abort button ***** */
        gbcMetrology.gridy++;
        metrologyPanel.add(btmetrologyabrt, gbcMetrology);
        btmetrologyabrt.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                btmetrologyabrt.setForeground(BLACK);
                btmetrologyabrt.setBackground(RED);
                sendSyncMetrologyCommand(null, "abortMotion");
            }
        });

        gbcMetrology.gridy++;
        metrologyPanel.add(btmetrologyack, gbcMetrology);
        btmetrologyack.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                btmetrologyack.setBackground(GREEN);
                sendSyncMetrologyCommand("Positioner", "reset");
            }
        });

        gbcMetrology.gridy++;
        metrologyPanel.add(btmetrologyenableaxes, gbcMetrology);
        btmetrologyenableaxes.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                btmetrologyenableaxes.setBackground(GREEN);
                sendSyncMetrologyCommand("Positioner", "enableAxes");
            }
        });

        /*
         **  position sub-panel
         */
        posPanel.setBorder(BorderFactory.createTitledBorder("POSITION and DISPLACEMENT"));
        posPanel.setLayout(new GridBagLayout());

        GridBagConstraints gbcBss = new GridBagConstraints();
        gbcBss.insets = new Insets(4, 4, 4, 4);
        gbcBss.anchor = GridBagConstraints.NORTH;
        gbcBss.gridx = 0;
        gbcBss.gridy = 0;

        posPanel.add(lbPosition, gbcBss);

        /* ******* PosX  ******* */
        gbcBss.gridy++;
        posPanel.add(lbPosX, gbcBss);
        gbcBss.gridy++;
        d = tfPosX.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfPosX.setPreferredSize(d);
        //       tfPosXV.setColumns(10);
        tfPosX.setValue("0.0");
        tfPosX.setEditable(false);
        posPanel.add(tfPosX, gbcBss);

        /* ******* PosX set point ******* */
        gbcBss.gridy++;
        posPanel.add(lbPosXSet, gbcBss);
        gbcBss.gridy++;
        d = tfPosXSet.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfPosXSet.setPreferredSize(d);
        posPanel.add(tfPosXSet, gbcBss);
        tfPosXSet.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sendSyncMetrologyCommand("Positioner", "moveAbs_x", tfPosXSet.getValue());
//                initConfigs();
//                SetPosXSet();
//                cfgTTY();
            }
        });

        /* ******* PosY ******* */
        gbcBss.gridy -= 3;
        gbcBss.gridx++;
        posPanel.add(lbPosY, gbcBss);
        gbcBss.gridy++;
        d = tfPosY.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfPosY.setPreferredSize(d);
        //       tfPosXV.setColumns(10);
        tfPosY.setValue("0.0");
        tfPosY.setEditable(false);
        posPanel.add(tfPosY, gbcBss);

        /* ******* PosY set point ******* */
        gbcBss.gridy++;
        posPanel.add(lbPosYSet, gbcBss);
        gbcBss.gridy++;
        d = tfPosYSet.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfPosYSet.setPreferredSize(d);
        posPanel.add(tfPosYSet, gbcBss);
        tfPosYSet.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sendSyncMetrologyCommand("Positioner", "moveAbs_y", tfPosYSet.getValue());
//                initConfigs();
//                SetPosXSet();
//                cfgTTY();
            }
        });

        /* ******* PosZ  ******* */
        gbcBss.gridy -= 3;
        gbcBss.gridx++;
        posPanel.add(lbPosZ, gbcBss);
        gbcBss.gridy++;
        d = tfPosZ.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfPosZ.setPreferredSize(d);
        //       tfPosXV.setColumns(10);
        tfPosZ.setValue("0.0");
        tfPosZ.setEditable(false);
        posPanel.add(tfPosZ, gbcBss);


        /* ******* PosZ set point ******* */
        gbcBss.gridy++;
        posPanel.add(lbPosZSet, gbcBss);
        gbcBss.gridy++;
        d = tfPosZSet.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfPosZSet.setPreferredSize(d);
        posPanel.add(tfPosZSet, gbcBss);
        tfPosZSet.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sendSyncMetrologyCommand("Positioner", "moveAbs_z", tfPosZSet.getValue());
//                initConfigs();
//                SetPosXSet();
//                cfgTTY();
            }
        });

        /* ----- displacement section ------*/
//        dispPanel.setBorder(BorderFactory.createTitledBorder("DISPLACEMENT"));
//        dispPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcDisp = new GridBagConstraints();
        gbcDisp.insets = new Insets(4, 4, 4, 4);
        gbcDisp.anchor = GridBagConstraints.NORTH;

// switched to using same panel area as for position measurements
//        gbcDisp.gridx = 0;
//        gbcDisp.gridy = 0;
        gbcDisp.gridx = 0;
        gbcDisp.gridy = gbcBss.gridy + 1;

        posPanel.add(lbKey, gbcDisp);

        /* ******* show displacement measurement state ******* */
 /*
        gbcDisp.gridy++;
        posPanel.add(lbKeyState, gbcDisp);
        gbcDisp.gridy++;
        d = tfKeyState.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfKeyState.setPreferredSize(d);
        tfKeyState.setValue("DISCONNECTED");
        tfKeyState.setEditable(false);
        posPanel.add(tfKeyState, gbcDisp);
         */

 /* ******* show displacement 1 ******* */
        gbcDisp.gridy++;
        posPanel.add(lbKey1, gbcDisp);
        gbcDisp.gridy++;
        d = tfKey1.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfKey1.setPreferredSize(d);
        tfKey1.setValue(0.0);
        tfKey1.setEditable(false);
        posPanel.add(tfKey1, gbcDisp);

        /* ******* show displacement 2 ******* */
        gbcDisp.gridy--;
        gbcDisp.gridx++;
        posPanel.add(lbKey2, gbcDisp);
        gbcDisp.gridy++;
        d = tfKey2.getPreferredSize();
        d.width = 100;
        d.height = 15;
        tfKey2.setPreferredSize(d);
        tfKey2.setValue(0.0);
        tfKey2.setEditable(false);
        posPanel.add(tfKey2, gbcDisp);

        /* ******* # samples ******* */
        gbcDisp.gridy -= 2;
        gbcDisp.gridx++;
        posPanel.add(lbKeynsamp, gbcDisp);
        gbcDisp.gridy++;
        d = tfKeynsamp.getPreferredSize();
        d.width = 60;
        d.height = 15;
        tfKeynsamp.setPreferredSize(d);
//        tfKeynsamp.setValue(1);
        tfKeynsamp.setEditable(true);
        posPanel.add(tfKeynsamp, gbcDisp);
        tfKeynsamp.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sendSyncMetrologyCommand("Measurer", "setcycles", Integer.parseInt(tfKeynsamp.getText()));
            }
        });

        /* ******* mode ******* */
        gbcDisp.gridy++;
        posPanel.add(lbKeymode, gbcDisp);
        gbcDisp.gridy++;
        d = tfKeymode.getPreferredSize();
        d.width = 60;
        d.height = 15;
        tfKeymode.setPreferredSize(d);
//        tfKeymode.setValue(1);
        tfKeymode.setEditable(true);
        posPanel.add(tfKeymode, gbcDisp);
        tfKeymode.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                sendSyncMetrologyCommand("Measurer", "setmeasmode", Integer.parseInt(tfKeymode.getText()));
            }
        });

        /* ******* Step Scan/Smooth Scan mode ******* */
        gbcDisp.gridx++;
        posPanel.add(btKeySS, gbcDisp);
        btKeySS.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
//                SSmode = !SSmode;
                SSmode = MetrologyConfig.ScanMode.values()[(SSmode.ordinal() + 1) % 3];
                btKeySS.setText(SSmode.name());
            }
        }
        );

        /* ******* Set Displacement Summing Mode ******* */
        gbcDisp.gridy--;
        posPanel.add(btKeyDSP, gbcDisp);

        btKeyDSP.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                DSPmode = (DSPmode + 1) % 4;
                sendSyncMetrologyCommand(null, "setDisp_mode", Integer.toString(DSPmode));
                btKeyDSP.setText(MetrologyConfig.Displacement_Summing_Modes.values()[DSPmode].toString());
            }
        }
        );

        // ++++++++++++++++++++++++++++++++++++++
        /* ******* do reps ***** */
        gbcDisp.gridy++;
        gbcDisp.gridx -= 2;

        btreps.setForeground(BLUE);

        btreps.setBackground(WHITE);

        posPanel.add(btreps, gbcDisp);

        d = tfnreps.getPreferredSize();
        d.width = 100;
        d.height = 30;

        tfnreps.setPreferredSize(d);

        tfnreps.setValue(nreps);
        d = tfperiod.getPreferredSize();
        d.width = 100;
        d.height = 30;

        tfperiod.setPreferredSize(d);

        tfperiod.setValue(period);

        d = tfrepfln.getPreferredSize();
        d.width = 350;
        d.height = 30;

        tfrepfln.setPreferredSize(d);

        tfrepfln.setText(RepFln);

        btreps.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                frmreps = new JFrame("Repetitions:");
                JPanel pnlreps = new JPanel();
                frmreps.setContentPane(pnlreps);

                frmreps.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                frmreps.setTitle("Do Keyence Repeat Readings");
                frmreps.setSize(1200, 300);
                frmreps.setLocationRelativeTo(null);
                GridBagConstraints gbcRep = new GridBagConstraints();
                gbcRep.insets = new Insets(4, 4, 4, 4);
                gbcRep.anchor = GridBagConstraints.NORTH;

                gbcRep.gridx = 0;
                gbcRep.gridy = 0;
                pnlreps.add(new JLabel("Number of repetitions:"), gbcRep);
                gbcRep.gridy++;
                pnlreps.add(tfnreps, gbcRep);
                tfnreps.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        nreps = Integer.parseInt(tfnreps.getText());
                        log.info("setting nreps to " + nreps);
                    }
                });
                gbcRep.gridy++;
                pnlreps.add(new JLabel("Period between readings:"), gbcRep);
                gbcRep.gridy++;
                pnlreps.add(tfperiod, gbcRep);
                tfperiod.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        period = Double.parseDouble(tfperiod.getText());
                        log.info("setting period to " + period + " seconds");
                    }
                });
                gbcRep.gridy++;
                pnlreps.add(new JLabel("Filename:"), gbcRep);
                gbcRep.gridy++;
                pnlreps.add(tfrepfln, gbcRep);
                tfrepfln.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RepFln = tfrepfln.getText();
                    }
                });
                gbcRep.gridy++;
                JButton goreps = new JButton("GO");
                pnlreps.add(goreps, gbcRep);
                goreps.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        goreps.setText("running w/ n=" + nreps + ",t=" + period + "s");
                        sendASyncMetrologyCommand(null, "doreps", RepFln, nreps, period);
                        //                  goreps.setText("DONE");
                    }
                });

                frmreps.setVisible(true);
            }
        }
        );

// +++++++++++++++++++++++++++++++++++
        /* ----- Position control section ------*/
        joyPanel.setBorder(BorderFactory.createTitledBorder("POSITIONING"));
        joyPanel.setLayout(
                new GridBagLayout());

        GridBagConstraints gbcJoy = new GridBagConstraints();
        gbcJoy.insets = new Insets(4, 4, 4, 4);
        gbcJoy.anchor = GridBagConstraints.NORTH;
        gbcJoy.gridx = 0;
        gbcJoy.gridy = 0;

        joyPanel.add(lbJoy, gbcJoy);

        /* ******* position button step size ******* */
        gbcJoy.gridy++;
        d = tfJoy.getPreferredSize();
        d.width = 60;
        d.height = 15;

        tfJoy.setPreferredSize(d);

        tfJoy.setText(Double.toString(stepScale));
        joyPanel.add(tfJoy, gbcJoy);

        tfJoy.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
//                sendSyncMetrologyCommand("Positioner", "setStep", tfJoy.getValue());
                stepScale = Double.parseDouble(tfJoy.getText());
                System.out.println("setting stepScale = " + stepScale);
                //Double.parseDouble((String)tfJoy.getValue());
            }
        }
        );

        // The buttons
//        gbcJoy.gridy++;
        gbcJoy.gridx += 2;

        joyPanel.add(btJoyFL1, gbcJoy); // up

        gbcJoy.gridy--;
        joyPanel.add(btJoyFL7, gbcJoy); // big up step
        gbcJoy.gridy++;

        gbcJoy.gridy++;
        gbcJoy.gridx--;
        joyPanel.add(btJoyFL3, gbcJoy); // left

//         gbcJoy.gridy++;
        gbcJoy.gridx += 2;

        joyPanel.add(btJoyFL4, gbcJoy); // right
        gbcJoy.gridy++;
        gbcJoy.gridx--;
        joyPanel.add(btJoyFL2, gbcJoy); // down

        gbcJoy.gridy++;
        joyPanel.add(btJoyFL8, gbcJoy); // big down step
        gbcJoy.gridy -= 2;

        joyPanel.add(btJoyFL9, gbcJoy); // home

        gbcJoy.gridx -= 2;

        joyPanel.add(btJoyFL5, gbcJoy); // big left step

        gbcJoy.gridy += 1;

        joyPanel.add(lbJoySpeed, gbcJoy); // speed
        gbcJoy.gridy++;
        d = tfJoySpeed.getPreferredSize();
        d.width = 60;
        d.height = 15;

        tfJoySpeed.setPreferredSize(d);
//        tfJoySpeed.setText(Double.toString(stepScale));

        joyPanel.add(tfJoySpeed, gbcJoy);

        tfJoySpeed.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
//                sendSyncMetrologyCommand("Positioner", "rampRate", Double.parseDouble(tfJoySpeed.getText()));
                sendSyncMetrologyCommand("Positioner", "setSpeed", Double.parseDouble(tfJoySpeed.getText()));
            }
        }
        );
        gbcJoy.gridy -= 2;

        gbcJoy.gridx += 4;

        joyPanel.add(btJoyFL6, gbcJoy); // big right step

        gbcJoy.gridy -= 2;

        joyPanel.add(btJoyFL10, gbcJoy); // step in
        gbcJoy.gridy++;
        joyPanel.add(btJoyFL11, gbcJoy); // step out

        // Their actions
        btJoyFL1.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_y", stepScale);
            }
        }
        );

        btJoyFL2.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_y", -stepScale);
            }
        }
        );

        btJoyFL3.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_x", -stepScale);
            }
        }
        );

        btJoyFL4.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_x", stepScale);
            }
        }
        );

        btJoyFL5.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_x", -5.0 * stepScale);
            }
        }
        );

        btJoyFL6.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_x", 5.0 * stepScale);
            }
        }
        );

        btJoyFL7.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_y", 5.0 * stepScale);
            }
        }
        );

        btJoyFL8.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_y", -5.0 * stepScale);
            }
        }
        );

        btJoyFL9.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "goHome");
            }
        }
        );

        btJoyFL10.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_z", -stepScale);
            }
        }
        );

        btJoyFL11.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                sendSyncMetrologyCommand("Positioner", "moveInc_z", stepScale);
            }
        }
        );

        /*
         **  Metrology Other sub-panel
         */
        extPanel.setBorder(BorderFactory.createTitledBorder("Scanning"));
        extPanel.setLayout(
                new GridBagLayout());

        GridBagConstraints gbcExt = new GridBagConstraints();
        gbcExt.insets = new Insets(4, 4, 4, 4);
        gbcExt.anchor = GridBagConstraints.NORTH;
//        gbcExt.gridwidth = 2;
        gbcExt.gridx = 0;
        gbcExt.gridy = 0;

        initConfigs(); // initialize configurable values
// ----------------------------------------------
        /* ******* open eTraveler ***** */
//         final URI uri;
        /*
         btetrv.setForeground(GREEN);
         btetrv.setBackground(WHITE);
         extPanel.add(btetrv, gbcExt);
         btetrv.addActionListener(new ActionListener() {
         @Override
         public void actionPerformed(ActionEvent e) {
         try {
         //                    log.info("Executing: firefox for eTrav ");
         java.lang.Runtime.getRuntime().exec("firefox -new-window http://lsst-camera.slac.stanford.edu/eTraveler/listTravelerTypes.jsp");
         } catch (Exception g) {
         log.warning("eTraveler startup failed");
         }
         }
         });
         */
// -------------------------------------------
//        gbcExt.gridy++;
//        extPanel.add(lbext, gbcExt);

        /* ******* perform scan ***** */
        gbcExt.gridy++;
        btacqimage.setForeground(BLUE);

        btacqimage.setBackground(GREEN);

        extPanel.add(btacqimage, gbcExt);

        btacqimage.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
//                cfgCnx();
//                sendSyncMetrologyCommand(null, "scan", -8., 8., 0.4, -8., 8., 0.4, "");
                sendSyncMetrologyCommand(null, "setCfgState", cfgstate);
                fltimestamp = System.currentTimeMillis();
                if (SSmode == MetrologyConfig.ScanMode.StepScan) {
                    sendASyncMetrologyCommand(null, "scanfl", fields(out_fln, fltimestamp));
                }
                if (SSmode == MetrologyConfig.ScanMode.NoStepScan) {
                    sendASyncMetrologyCommand(null, "noStepScan", fields(out_fln, fltimestamp));
                }
                if (SSmode == MetrologyConfig.ScanMode.PointList) {
                    sendASyncMetrologyCommand(null, "scanPL", fields(out_fln, fltimestamp));
                }
//                dopyplot();
            }
        }
        );

        gbcExt.gridy++;
        extPanel.add(lbfln, gbcExt);
        gbcExt.gridy++;
        d = tffln.getPreferredSize();
        d.width = 400;
        d.height = 20;

        tffln.setPreferredSize(d);

        tffln.setText(out_fln);

        tffln.setEditable(
                true);
        extPanel.add(tffln, gbcExt);

        tffln.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
                out_fln = tffln.getText();
            }
        }
        );

        /* ******* display image ***** */
        gbcExt.gridy++;
        btplot.setForeground(BLUE);

        btplot.setBackground(WHITE);

        extPanel.add(btplot, gbcExt);

        btplot.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {
//                cfgCnx();
//                sendSyncMetrologyCommand("Positioner", "plotscan", 80.0, 180., 90.);
                try {
                    sendSyncMetrologyCommand(null, "plotscan");
                } catch (Exception ex) {
                    log.info("plotscan failed on error: " + ex);
                }
                dopyplot();
            }
        }
        );

        gbcExt.gridy++;
        extPanel.add(lbconfig, gbcExt);

        /* ******* Metrology change state button ***** */
        gbcExt.gridy++;
        extPanel.add(btmetrologycfg, gbcExt);

        btmetrologycfg.addActionListener(
                new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e
            ) {

                String[] states = new String[MetrologyConfig.configuration_states.values().length];
                for (MetrologyConfig.configuration_states iwstate : MetrologyConfig.configuration_states.values()) {
                    states[iwstate.ordinal()] = iwstate.name();
                }
//                Long highindex = -1L;

                // for each name in the path array
                if (states != null) {
                    JList<String> stateList;
                    DefaultListModel<String> listModel = new DefaultListModel<>();
                    for (String state : states) {
                        listModel.addElement(state);
                    }

                    //create the list
                    stateList = new JList<>(listModel);
                    stateList.addListSelectionListener(new ListSelectionListener() {
                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (!e.getValueIsAdjusting()) {
                                final List<String> selectedValuesList = stateList.getSelectedValuesList();
                                System.out.println(selectedValuesList);
                                String selectedstate = selectedValuesList.get(0);
                                try {
                                    log.info("Switching to " + selectedstate);
                                    cfgstate = MetrologyConfig.configuration_states.valueOf(selectedstate).ordinal();
//                                    initConfigs();
                                    btmetrologycfg.setText("cfg:" + MetrologyConfig.configuration_states.values()[cfgstate].name());

                                    plcfg.dispose();
                                } catch (Exception g) {
                                    log.info("State change failed");
                                }

                            }
                        }
                    });

                    plcfg = new JFrame("Select a state:");
                    plcfg.add(stateList);

                    plcfg.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    plcfg.setTitle("Config State");
                    plcfg.setSize(200, 200);
                    plcfg.setLocationRelativeTo(null);
                    plcfg.add(new JScrollPane(stateList));
                    stateList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
                    plcfg.setVisible(true);
                }

            }
        }
        );

        /* -------------------------------------------------------------------- */

 /*
         **  Main panel
         */
        panel.setLayout(
                new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridx = 0;
        gbc.gridy = 0;

        panel.setBackground(
                new Color(20, 20, 20));

        panel.add(metrologyPanel, gbc);
        gbc.gridx++;
        panel.add(posPanel, gbc);
//        gbc.gridx++;
//        panel.add(dispPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy++;
        panel.add(joyPanel, gbc);
        gbc.gridx++;
        panel.add(extPanel, gbc);

        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.NORTH;

        panel.add(lbMessage, gbc);
    }

    public JPanel getPanel() {
        return panel;
    }

    public JComponent getGuiLayout() {
        return panel;
    }

    public void resetGui() {
    }

    protected Object sendSyncMetrologyCommand(String target, String name, Object... params) {
        String dest = target == null ? metrology_dest : metrology_dest + "/" + target;
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(dest, name, params);
        try {
            return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(1440000));

        } catch (Exception e) {
//            throw new RuntimeException("error invoking synchronous command", e);
            log.warning("Unable to perform jgroup communication with destination + "
                    + dest + " - Exception " + e);
            return null;
        }
    }

    protected Object sendASyncMetrologyCommand(String target, String name, Object... params) {
        String dest = target == null ? metrology_dest : metrology_dest + "/" + target;
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(dest, name, params);
        try {
            return cmu.sendAsynchronousCommand(cmd);
        } catch (Exception e) {
//            throw new RuntimeException("error invoking synchronous command", e);
            log.warning("Unable to perform jgroup communication with destination + "
                    + dest + " - Exception " + e);
            return null;
        }
    }

    /**
     * ******************************************************
     **
     **
     ** read text fields and send updates to the subsystem *
     * ***********************************************************
     */
    void updateConfig() {
        /*
         sendSyncMetrologyCommand("PosX", "setrunbias", tfPosXSet.getValue());
         sendSyncMetrologyCommand("Disp", "setruntemp", tfKeyTacq.getValue());
         sendSyncMetrologyCommand("VacuumGauge", "setrunvac", tfVacPacq.getValue());
         sendSyncMetrologyCommand("Monochromator", "setrunwave" + tfMonoWL.getValue());
         */
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            } catch (IOException e) {
                JOptionPane.showMessageDialog(null,
                        "Failed to launch the link, "
                        + "your computer is likely misconfigured.",
                        "Cannot Launch Link", JOptionPane.WARNING_MESSAGE);
            }
        } else {
            JOptionPane.showMessageDialog(null,
                    "Java is not able to launch links on your computer.",
                    "Cannot Launch Link", JOptionPane.WARNING_MESSAGE);
        }
    }

    private String fields(String fitsFileName, Long timestamp) {
        return fitsFileName.replace("${timestamp}", String.valueOf(timestamp))
                .replace(
                        "${TIMESTAMP}",
                        new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(
                                timestamp)));
    }

    void dopyplot() {
        String surfpath = "/opt/lsst/redhat6-x86_64-64bit-gcc44/lsst-utils/ts5/ts5_plot.sh " + fields(out_fln, fltimestamp);
        log.info("Executing: plot_surf " + surfpath);
        try {
            java.lang.Runtime.getRuntime().exec(surfpath);
        } catch (IOException ex) {
            Logger.getLogger(MetrologyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

}
