/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.CalcDevice;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Page;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.utilities.logging.Logger;

public class Monitor {
    private static final int DEFAULT_UPDATE_PERIOD = 1000;
    private static final int DEFAULT_CHECK_PERIOD = 10000;
    static final String CALC_DEVICE_NAME = "Calc";
    static final String LIMITS = "Limits";
    private final Module module;
    private final Map<String, Device> devcMap;
    private final Map<String, Channel> chanMap;
    private final Map<String, Alarm> alarmMap;
    private final Map<String, Line> lineMap;
    private final Map<String, Page> pageMap;
    private final List<Device> devcList = new ArrayList<Device>();
    private final List<Alarm> alarmList = new ArrayList<Alarm>();
    private final BitSet goodChans = new BitSet();
    private final BitSet onlineChans = new BitSet();
    private final CalcDevice calcDevc = new CalcDevice();
    final AlarmHandler alarmH;
    final Logger log;
    final Subsystem subsys;
    final BitSet loLimChange = new BitSet();
    final BitSet hiLimChange = new BitSet();
    private int numChans;
    private Channel[] chanData;
    private boolean doPublishData;

    public Monitor(Module mod, AlarmHandler alarmHand, Logger logger) {
        this.module = mod;
        this.alarmH = alarmHand;
        this.log = logger;
        this.subsys = this.module.getSubsystem();
        this.devcMap = this.module.getChildren(Device.class);
        this.chanMap = this.module.getChildren(Channel.class);
        this.alarmMap = this.module.getChildren(Alarm.class);
        this.lineMap = this.module.getChildren(Line.class);
        this.pageMap = this.module.getChildren(Page.class);
    }

    public void initConfiguration() {
        this.devcMap.put(CALC_DEVICE_NAME, this.calcDevc);
        for (Device devc : this.devcMap.values()) {
            this.devcList.add(devc);
            devc.configure(this);
        }
        for (Line line : this.lineMap.values()) {
            line.configure(this);
        }
        for (Alarm alarm : this.alarmMap.values()) {
            this.alarmList.add(alarm);
            alarm.configure(this);
        }
        this.chanData = new Channel[this.chanMap.size()];
        int id = 0;
        for (Channel ch : this.chanMap.values()) {
            ch.configure(this, id);
            this.chanData[id++] = ch;
        }
    }

    public void initSensors() {
        this.initSensors(10000);
    }

    public void initSensors(int checkPeriod) {
        if (checkPeriod <= 0) {
            checkPeriod = 10000;
        }
        for (Device devc : this.devcList) {
            if (devc.disabled) continue;
            devc.initialize();
        }
        for (Alarm alarm : this.alarmList) {
            alarm.initialize();
        }
        new Timer("CheckDevices", true).schedule((TimerTask)new CheckDevices(), 0L, (long)checkPeriod);
    }

    public void readSensors() {
        for (Device devc : this.devcList) {
            devc.readSensors();
        }
    }

    public void start() {
        this.start(1000);
    }

    public void start(int period) {
        new Timer("UpdateState", true).schedule((TimerTask)new UpdateState(), 0L, (long)period);
    }

    public MonitorFullState getFullState() {
        MonitorFullState state = new MonitorFullState();
        for (Alarm alarm : this.alarmList) {
            state.addAlarm(alarm.getName(), alarm.getDescription());
        }
        for (Page page : this.pageMap.values()) {
            state.addPage(Integer.valueOf(page.getId()), page.getLabel());
        }
        for (Iterator<ConfigurableComponent> iterator : this.chanData) {
            state.addChannel(new MonitorChan(iterator.getName(), ((Channel)((Object)iterator)).getDescription(), ((Channel)((Object)iterator)).getFormat(), ((Channel)((Object)iterator)).getUnits(), ((Channel)((Object)iterator)).getPageId(), ((Channel)((Object)iterator)).getLimitLo(), 0.0, ((Channel)((Object)iterator)).getAlarmNameLo(), ((Channel)((Object)iterator)).getLimitHi(), 0.0, ((Channel)((Object)iterator)).getAlarmNameHi(), ((Channel)((Object)iterator)).getValue()));
        }
        state.setMonitorState(new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange));
        return state;
    }

    public void publishState() {
        MonitorState state = new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange);
        KeyValueData data = new KeyValueData("MonitorState", (Serializable)state);
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    public void publishData() {
        KeyValueDataList dataList = new KeyValueDataList();
        for (Channel ch : this.chanData) {
            if (ch.getState() == -1) continue;
            dataList.addData(ch.getName(), (Serializable)Double.valueOf(ch.getValue()), ch.getTimestamp());
        }
        if (!dataList.getListOfKeyValueData().isEmpty()) {
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
        }
    }

    public void publishLimits() {
        for (Channel ch : this.chanData) {
            KeyValueDataList data = new KeyValueDataList(ch.getName());
            data.addData("alarmLow", (Serializable)((Object)String.valueOf(ch.getLimitLo())), KeyValueData.KeyValueDataType.KeyValueMetaData);
            data.addData("alarmHigh", (Serializable)((Object)String.valueOf(ch.getLimitHi())), KeyValueData.KeyValueDataType.KeyValueMetaData);
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
        }
    }

    public void updateState() {
        BitSet goodState = new BitSet(this.numChans);
        BitSet onlineState = new BitSet(this.numChans);
        for (Channel ch : this.chanData) {
            ch.checkLimits(goodState);
            ch.checkOnline(onlineState);
        }
        for (Alarm alarm : this.alarmList) {
            alarm.setState();
        }
        goodState.xor(this.goodChans);
        this.goodChans.xor(goodState);
        onlineState.xor(this.onlineChans);
        this.onlineChans.xor(onlineState);
        if (!goodState.isEmpty() || !onlineState.isEmpty()) {
            this.publishState();
        }
        if (!goodState.isEmpty() || this.doPublishData) {
            this.publishData();
            this.doPublishData = false;
        }
    }

    @Deprecated
    public void checkLimits() {
        this.updateState();
    }

    public void setPublishData() {
        this.doPublishData = true;
    }

    public void clearLimitChanges() {
        this.loLimChange.clear();
        this.hiLimChange.clear();
    }

    public Device getDevice(String name) {
        return this.devcMap.get(name);
    }

    public List<String> getDeviceNames() {
        return new ArrayList<String>(this.devcMap.keySet());
    }

    public Map<String, Object> getConfigurationMap() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Device devc : this.devcList) {
            values.putAll(devc.getConfigValues());
        }
        return values;
    }

    public Line getLine(String name) {
        return this.lineMap.get(name);
    }

    public Alarm getAlarm(String name) {
        return this.alarmMap.get(name);
    }

    public Channel getChannel(String name) {
        return this.chanMap.get(name);
    }

    public Channel getChannel(int id) {
        return this.chanData[id];
    }

    public int getChannelId(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? -1 : chan.getId();
    }

    public void setOnline(BitSet mask, boolean online) {
        BitSet prevOnline = (BitSet)this.onlineChans.clone();
        if (online) {
            this.onlineChans.or(mask);
        } else {
            this.onlineChans.andNot(mask);
        }
        if (!this.onlineChans.equals(prevOnline)) {
            this.publishState();
        }
    }

    public int getNumChans() {
        return this.numChans;
    }

    public List<String> getChannelNames() {
        return new ArrayList<String>(this.chanMap.keySet());
    }

    public Double getChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.getValue());
    }

    public Double readChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.readValue());
    }

    public Module getModule() {
        return this.module;
    }

    public void saveLimits() {
        this.module.getEnvironment().saveChangesForCategories(LIMITS);
        this.clearLimitChanges();
        this.publishState();
    }

    public void reportError(String cName, String pName, Object pValue) throws Exception {
        this.log.error((Object)("Invalid " + pName + " (" + pValue + ") for " + cName));
        throw new Exception();
    }

    public void reportError(String cName, String pName) throws Exception {
        this.log.error((Object)("Missing " + pName + " for " + cName));
        throw new Exception();
    }

    public void reportConfigError(String cName, String pName, String message) {
        this.log.error((Object)("Configuration parameter " + pName + " for " + cName + " " + message));
        throw new RuntimeException("Fatal configuration error");
    }

    private class CheckDevices
    extends TimerTask {
        private CheckDevices() {
        }

        @Override
        public void run() {
            for (Device devc : Monitor.this.devcList) {
                devc.checkOnline();
            }
        }
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            Monitor.this.readSensors();
            Monitor.this.updateState();
        }
    }

    public static interface AlarmHandler {
        public void processAlarm(int var1, int var2);
    }
}

