/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public class Module
extends Observable
implements HasLifecycle,
ConfigurationBulkChangeHandler,
Observer,
Configurable,
SignalHandler {
    private static Logger log = Logger.getLogger((String)"org.lsst.ccs.framework");
    @Deprecated
    protected String name;
    private List<Observable> observables = new ArrayList<Observable>();
    protected int nObserverThreads = 1;
    private PeriodicTask tickPeriodicTask;
    private final Object tickPeriodicTaskLock = new Object();
    @ConfigurationParameter
    protected int tickMillis = -1;

    public Module() {
    }

    public Module(int tickMillis) {
        this.tickMillis = tickMillis;
    }

    @Deprecated
    public Module(String name, int tickMillis) {
        this.name = name;
        this.tickMillis = tickMillis;
    }

    @Deprecated
    public Module(String name) {
        this(name, -1);
    }

    public void setObservables(List<Observable> l) {
        for (Observable o : l) {
            this.observables.add(o);
            o.addObserver(this);
        }
    }

    public void listens(Observable ... observs) {
        this.setObservables(Arrays.asList(observs));
    }

    public List<Observable> getObservables() {
        return Collections.unmodifiableList(this.observables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="tickMillis")
    public void setTickMillis(int tickMillis) {
        Object object = this.tickPeriodicTaskLock;
        synchronized (object) {
            if (this.tickMillis != tickMillis) {
                this.tickMillis = tickMillis;
                if (this.tickPeriodicTask != null) {
                    this.tickPeriodicTask.stop();
                    if (tickMillis > 0) {
                        this.tickPeriodicTask.setPeriod((long)tickMillis, TimeUnit.MILLISECONDS);
                        this.tickPeriodicTask.start();
                    }
                }
            }
        }
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    @Deprecated
    public void setNObserverThreads(int observerThreads) {
        this.nObserverThreads = observerThreads;
    }

    @Deprecated
    public int getNObserverThreads() {
        return this.nObserverThreads;
    }

    @Override
    public final void init() {
        this.initModule();
    }

    public void initModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startTicking() {
        Object object = this.tickPeriodicTaskLock;
        synchronized (object) {
            this.tickPeriodicTask = new PeriodicTask(this.getSubsystem().getScheduler(), () -> this.tick(), true, "tick", Level.SEVERE, (long)this.tickMillis, TimeUnit.MILLISECONDS);
            if (this.tickMillis > 0) {
                this.tickPeriodicTask.start();
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof ValueUpdate)) {
            log.error((Object)("update called with arg not a ValueUpdate: " + arg));
            return;
        }
        this.getSubsystem().getScheduler().schedule(() -> this.processUpdate(o, (ValueUpdate)arg), 0L, TimeUnit.SECONDS);
    }

    public void processUpdate(Observable source, ValueUpdate update) {
    }

    public void tick() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow() {
        Object object = this.tickPeriodicTaskLock;
        synchronized (object) {
            if (this.tickPeriodicTask != null) {
                this.tickPeriodicTask.stop();
            }
        }
    }

    @Override
    public TreeWalkerDiag signal(Signal sig) {
        return TreeWalkerDiag.GO;
    }

    @Command(description="will propagate signal to Module and its children ", type=Command.CommandType.SIGNAL)
    public void sendSignal(String signalString) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel);
        this.sendSignalInternal(signal);
    }

    @Command(description="will propagate signal to Module and its children with  an expected maximum delay", type=Command.CommandType.SIGNAL)
    public void sendSignalWithTimeLimit(String signalString, long expectedMaxDelay) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel, expectedMaxDelay);
        this.sendSignalInternal(signal);
    }

    private void sendSignalInternal(Signal signal) {
        TreeWalkerUtils.treeWalk(this.getSubsystem().getComponentLookup(), this.getName(), SignalHandler.class, sh -> sh.signal(signal), null);
    }

    public class ValueUpdate {
        String name;
        Object value;
        long timeStamp = System.currentTimeMillis();

        public ValueUpdate(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public ValueUpdate(String name, Object value, long tStamp) {
            this.name = name;
            this.value = value;
            this.timeStamp = tStamp;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

