/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.PresetList;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.PresetsDialog;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowPanel;

public final class TimeWindowSelector
extends JComboBox {
    private final String CUSTOM_BUTTON = "Choose...";
    private final String PRESETS_BUTTON = "Presets...";
    private final String DEFAULT_NAME = "custom";
    private final String[] STANDARD_WINDOWS = new String[]{"Last Hour", "Last 6 Hours", "Last 24 Hours"};
    private final int MAX_PRESETS = 10;
    private final PresetList timeWindowList;
    private volatile TimeWindow selection;

    public TimeWindowSelector(Studio application) {
        this.timeWindowList = new PresetList(application);
        this.setRenderer(new Renderer(this.getRenderer()));
        this.setMaximumRowCount(15);
        Model model = new Model(this.timeWindowList);
        this.setModel(model);
        this.setSelectedIndex(1);
        this.selection = model.getSelectedItem();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindow ts = TimeWindowSelector.this.myModel().getSelectedItem();
                switch (ts.getName()) {
                    case "Choose...": {
                        ts = TimeWindowPanel.editTimeWindow(TimeWindowSelector.this, null);
                        if (ts == null) {
                            TimeWindowSelector.this.setSelectedItem(TimeWindowSelector.this.selection);
                            break;
                        }
                        if (ts.getName().isEmpty()) {
                            ts.setName("custom");
                            if ("custom".equals(TimeWindowSelector.this.selection.getName())) {
                                TimeWindowSelector.this.myModel().removeElementAt(4);
                            }
                            TimeWindowSelector.this.myModel().insertElementAt(ts, 4);
                            TimeWindowSelector.this.setSelectedIndex(4);
                        } else {
                            TimeWindowSelector.this.timeWindowList.insert(ts);
                            Model model = new Model(TimeWindowSelector.this.timeWindowList);
                            model.setSelectedItem(ts);
                            TimeWindowSelector.this.setModel(model);
                        }
                        TimeWindowSelector.this.selection = ts;
                        break;
                    }
                    case "Presets...": {
                        ts = PresetsDialog.managePresets(TimeWindowSelector.this, TimeWindowSelector.this.timeWindowList);
                        if (ts == null) {
                            ts = TimeWindowSelector.this.selection;
                        }
                        ts.touch();
                        Model model = new Model(TimeWindowSelector.this.timeWindowList);
                        int index = model.getIndexOf(ts);
                        if (index == -1) {
                            index = 1;
                        }
                        TimeWindowSelector.this.selection = (TimeWindow)model.getElementAt(index);
                        model.setSelectedItem(TimeWindowSelector.this.selection);
                        TimeWindowSelector.this.setModel(model);
                        break;
                    }
                    default: {
                        if (!"custom".equals(ts.getName())) {
                            ts.touch();
                            if ("custom".equals(TimeWindowSelector.this.selection.getName())) {
                                TimeWindowSelector.this.myModel().removeElementAt(4);
                            }
                        }
                        TimeWindowSelector.this.selection = ts;
                    }
                }
            }
        });
    }

    public TimeWindow getSelectedTimeWindow() {
        return this.selection;
    }

    public void setSelectedTimeWindow(TimeWindow timeWindow) {
        String name = timeWindow.getName();
        if (name == null || name.equals("")) {
            this.myModel().setSelectedItem(this.myModel().getElementAt(0));
        } else {
            int i = this.myModel().getIndexOf(timeWindow);
            if (i >= 0) {
                this.myModel().setSelectedItem(timeWindow);
            } else {
                timeWindow.touch();
                Model model = new Model(this.timeWindowList);
                model.setSelectedItem(timeWindow);
                this.setModel(model);
            }
        }
        this.selection = timeWindow;
    }

    public PresetList getPresetList() {
        return this.timeWindowList;
    }

    public TimeWindow getTimeWindow(String name) {
        for (int i = 0; i < this.STANDARD_WINDOWS.length; ++i) {
            if (!this.STANDARD_WINDOWS[i].equals(name)) continue;
            return (TimeWindow)this.myModel().getElementAt(i + 1);
        }
        TimeWindow timeWindow = this.timeWindowList.get(name);
        if (timeWindow == null) {
            try {
                timeWindow = TimeWindow.parseCompressedString(name);
                name = timeWindow.getName();
                if (name != null && !name.equals("")) {
                    this.timeWindowList.insert(timeWindow);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return timeWindow;
    }

    private Model myModel() {
        return (Model)super.getModel();
    }

    private class Model
    extends DefaultComboBoxModel<TimeWindow> {
        Model(PresetList tsList) {
            this.addElement(new TimeWindow("Choose..."));
            TimeWindow selectedItem = new TimeWindow(TimeWindowSelector.this.STANDARD_WINDOWS[0], "now-3600", "now", false);
            this.addElement(selectedItem);
            this.addElement(new TimeWindow(TimeWindowSelector.this.STANDARD_WINDOWS[1], "now-21600", "now", false));
            this.addElement(new TimeWindow(TimeWindowSelector.this.STANDARD_WINDOWS[2], "now-86400", "now", false));
            List<TimeWindow> customRanges = tsList.getRecent(10);
            for (TimeWindow ts : customRanges) {
                this.addElement(ts);
            }
            this.addElement(new TimeWindow("Presets..."));
            this.setSelectedItem(selectedItem);
        }

        @Override
        public TimeWindow getSelectedItem() {
            return (TimeWindow)super.getSelectedItem();
        }
    }

    private class Renderer
    implements ListCellRenderer {
        private final ListCellRenderer horse;
        private final JPanel separatorPanel = new JPanel(new BorderLayout());
        private final JSeparator separator = new JSeparator();

        Renderer(ListCellRenderer renderer) {
            this.horse = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.horse.getListCellRendererComponent(list, ((TimeWindow)value).getName(), index, isSelected, cellHasFocus);
            if (index == 0 || index == 3) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "South");
                comp = this.separatorPanel;
            } else if (index > 4 && index == TimeWindowSelector.this.getItemCount() - 1) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "North");
                comp = this.separatorPanel;
            }
            return comp;
        }
    }
}

