package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
//import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;
import org.lsst.gruth.jutils.Constraints;

/**
 *
 * @author The LSST CCS Team
 */
public class MetrologyConfigurableSubsystemMainPanel extends JPanel {

    private static final long serialVersionUID = 1L;
    private static final Map<String, MetrologyConfigurablePanel> panelMap = new TreeMap<>();
    private static AgentMessagingLayer agentMessagingLayer;
    private final JLabel descriptionNameLbl = new JLabel();
    private static String metrology_dest = "metrology";
    private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI");

    static {
        for (String componentName : MetrologyConfig.COMPONENT_NAMES) {
            panelMap.put(componentName, new MetrologyConfigurablePanel(componentName));
        }
    }

    public MetrologyConfigurableSubsystemMainPanel(AgentMessagingLayer aml, String DEST) {
        agentMessagingLayer = aml;
        metrology_dest = DEST;
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(descriptionNameLbl);
        for (MetrologyConfigurablePanel panel : panelMap.values()) {
            add(panel);
        }

    }

    public void updateWithConfigInfo(ConfigurationInfo configurationInfo) {
        for (Map.Entry<String, MetrologyConfigurablePanel> entry : panelMap.entrySet()) {
            Map<String, String> configForComponent = configurationInfo.getCurrentValuesForComponent(entry.getKey());
            if (!configForComponent.isEmpty()) {
                entry.getValue().updateWithConfigInfo(configForComponent);
            }
        }
    }

    public void setDescriptionName(String descriptionName) {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                descriptionNameLbl.setText(descriptionName);
            }
        });
    }

    private static class MetrologyConfigurablePanel extends JPanel {

        private static final long serialVersionUID = 1L;
        private final String componentName;

        final private NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
        final private NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.##"));
        final private NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.####E00"));

        private final JLabel stateLbl = new JLabel();
//        private final JLabel startxLbl = new JLabel();
        private final JFormattedTextField startxLbl = new JFormattedTextField(fmt5d);
//        private final JLabel stopxLbl = new JLabel();
        private final JFormattedTextField stopxLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField dxLbl = new JFormattedTextField(fmt5d);
//        private final JLabel startyLbl = new JLabel();
        private final JFormattedTextField startyLbl = new JFormattedTextField(fmt5d);
//        private final JLabel stopyLbl = new JLabel();
        private final JFormattedTextField stopyLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField dyLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField rotationLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField cornerangLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField nsampsLbl = new JFormattedTextField(fmt5);
        private final JFormattedTextField measmodeLbl = new JFormattedTextField(fmt5);
        private final JFormattedTextField accelerationLbl = new JFormattedTextField(fmt5d);
        private final JFormattedTextField speedLbl = new JFormattedTextField(fmt5d);
//        private final JLabel rotationLbl = new JLabel();
//        private final JLabel cornerangLbl = new JLabel();
        private static final JButton btsavechanges = new JButton("Save Changes");

        private MetrologyConfigurablePanel(String componentName) {
            super(new GridBagLayout());
            this.componentName = componentName;
            setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = GridBagConstraints.WEST;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0;
            gbc.weighty = 0;
            gbc.fill = GridBagConstraints.NONE;

            add(new JLabel("State : "), gbc);

            gbc.gridy = 1;
            add(new JLabel("Scan X start : "), gbc);

            gbc.gridy = 2;
            add(new JLabel("Scan X stop : "), gbc);

            gbc.gridy = 3;
            add(new JLabel("Scan dX : "), gbc);

            gbc.gridy = 4;
            add(new JLabel("Scan Y start : "), gbc);

            gbc.gridy = 5;
            add(new JLabel("Scan Y stop : "), gbc);

            gbc.gridy = 6;
            add(new JLabel("Scan dY : "), gbc);

            gbc.gridy = 7;
            add(new JLabel("Rotation : "), gbc);

            gbc.gridy = 8;
            add(new JLabel("Corner Angle : "), gbc);

            gbc.gridy = 9;
            add(new JLabel("Cycle Mode : "), gbc);

            gbc.gridy = 10;
            add(new JLabel("Surface Mode : "), gbc);

            gbc.gridy = 11;
            add(new JLabel("Acceleration : "), gbc);

            gbc.gridy = 12;
            add(new JLabel("Speed : "), gbc);

            gbc.gridx += 3;
            add(btsavechanges, gbc);
            btsavechanges.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Saving all changes");
                    sendSyncMetrologyCommand(null, "saveAllChanges");
                }
            });

            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1;
            add(stateLbl, gbc);

            Dimension d = startxLbl.getPreferredSize();
            d.width = 100;
            d.height = 20;
            startxLbl.setPreferredSize(d);
            stopxLbl.setPreferredSize(d);
            startyLbl.setPreferredSize(d);
            stopyLbl.setPreferredSize(d);
            cornerangLbl.setPreferredSize(d);
            rotationLbl.setPreferredSize(d);
            dxLbl.setPreferredSize(d);
            dyLbl.setPreferredSize(d);
            nsampsLbl.setPreferredSize(d);
            measmodeLbl.setPreferredSize(d);
            accelerationLbl.setPreferredSize(d);
            speedLbl.setPreferredSize(d);

            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            add(startxLbl, gbc);

            gbc.gridy = 2;
            gbc.gridwidth = 1;
            add(stopxLbl, gbc);

            gbc.gridy = 3;
            gbc.gridwidth = 1;
            add(dxLbl, gbc);

            gbc.gridy = 4;
            gbc.gridwidth = 1;
            add(startyLbl, gbc);

            gbc.gridy = 5;
            add(stopyLbl, gbc);

            gbc.gridy = 6;
            add(dyLbl, gbc);

            gbc.gridy = 7;
            add(rotationLbl, gbc);

            gbc.gridy = 8;
            add(cornerangLbl, gbc);

            gbc.gridy = 9;
            add(nsampsLbl, gbc);

            gbc.gridy = 10;
            add(measmodeLbl, gbc);

            gbc.gridy = 11;
            add(accelerationLbl, gbc);

            gbc.gridy = 12;
            add(speedLbl, gbc);

            startxLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing startx value");
                    sendSyncMetrologyCommand(componentName, "change", "startx", startxLbl.getText());
//                    sendSyncMetrologyCommand("Positioner", "setStartx", Double.valueOf(startxLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            });
            stopxLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "stopx", stopxLbl.getText());
//                    sendSyncMetrologyCommand("Positioner", "setStopx", Double.valueOf(stopxLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            });
            dxLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "dx", dxLbl.getText());
//                    sendSyncMetrologyCommand("Positioner", "setDx", Double.valueOf(dxLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            });
            startyLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "starty", startyLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setStarty", Double.valueOf(startyLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            stopyLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "stopy", stopyLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setStopy", Double.valueOf(startyLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            dyLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "dy", dyLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setDy", Double.valueOf(dyLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            rotationLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "rotation", rotationLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setDy", Double.valueOf(rotationLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            cornerangLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "cornerang", cornerangLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setDy", Double.valueOf(cornerangLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            nsampsLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "nsamps", nsampsLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setDy", Double.valueOf(nsampsLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            measmodeLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "measmode", measmodeLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setDy", Double.valueOf(measmodeLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            accelerationLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "acceleration", accelerationLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setDy", Double.valueOf(accelerationLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

            speedLbl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendSyncMetrologyCommand(componentName, "change", "speed", speedLbl.getText());
//                  sendSyncMetrologyCommand("Positioner", "setDy", Double.valueOf(speedLbl.getText()), MetrologyConfig.configuration_states.valueOf(componentName));
                }
            }
            );

        }

        private void updateWithConfigInfo(Map<String, String> configForComponent) {
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    stateLbl.setText(configForComponent.get(componentName + "//state"));
                    startxLbl.setText(configForComponent.get(componentName + "//startx"));
                    stopxLbl.setText(configForComponent.get(componentName + "//stopx"));
                    dxLbl.setText(configForComponent.get(componentName + "//dx"));
                    startyLbl.setText(configForComponent.get(componentName + "//starty"));
                    stopyLbl.setText(configForComponent.get(componentName + "//stopy"));
                    dyLbl.setText(configForComponent.get(componentName + "//dy"));
                    rotationLbl.setText(configForComponent.get(componentName + "//rotation"));
                    cornerangLbl.setText(configForComponent.get(componentName + "//cornerang"));
                    nsampsLbl.setText(configForComponent.get(componentName + "//nsamps"));
                    measmodeLbl.setText(configForComponent.get(componentName + "//measmode"));
                    accelerationLbl.setText(configForComponent.get(componentName + "//acceleration"));
                    speedLbl.setText(configForComponent.get(componentName + "//speed"));
//                    Map<String, Integer> currentMap = (Map<String, Integer>) Constraints.check("java.util.Map", configForComponent.get(componentName+"//currentParms"), null);
//                    Lbl.setText(String.valueOf(currentMap.get("continuousLimit")));
//                    outputLimitLbl.setText(String.valueOf(currentMap.get("outputLimit")));
//                    maxSpeedLbl.setText(String.valueOf(currentMap.get("maxSpeed")));
                }
            });
        }

        protected Object sendSyncMetrologyCommand(String target, String name, Object... params) {
            String dest = target == null ? metrology_dest : metrology_dest + "/" + target;
            ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
            CommandRequest cmd = new CommandRequest(dest, name, params);
            try {
                return cmu.sendSynchronousCommand(cmd, 1440000);
            } catch (Exception e) {
//            throw new RuntimeException("error invoking synchronous command", e);
                log.warning("Unable to perform jgroup communication with destination "
                        + dest + " - Exception " + e);
                return null;
            }
        }
    }
}
