package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.Component;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author The LSST CCS Team
 */
public class MetrologyConfigurableSubsystemGUI implements AgentPresenceListener,
        StatusMessageListener {

    private static final Logger LOGGER = Logger.getLogger("org.lsst.ccs.subsystem.metrology.gui");
    private static String DEST = "metrology";
    private final MetrologyConfigurableSubsystemMainPanel mainPanel;
    private final AgentMessagingLayer aml;
    private final ConcurrentMessagingUtils cmu;
    private BusMessageFilter filterConfig;

    public MetrologyConfigurableSubsystemGUI(AgentMessagingLayer aml) {
        this.aml = aml;
        cmu = new ConcurrentMessagingUtils(aml);
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");

        mainPanel = new MetrologyConfigurableSubsystemMainPanel(aml, DEST);
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        if (msg == null) {
            return;
        }
        //                 System.out.println("msg type = "+(msg.getObject()).toString());                         
        ConfigurationInfo configInfo = null;
        if (msg.getObject() instanceof ConfigurationInfo) {
            configInfo = (ConfigurationInfo) msg.getObject();
        } else {
            return;
        }
//        ConfigurationInfo configInfo = (ConfigurationInfo) msg.getObject();
        List<ConfigurationParameterInfo> listChanges = configInfo.getLatestChanges();
        mainPanel.updateWithConfigInfo(configInfo);
    }

    public Component getGuiLayout() {
        return new JScrollPane(mainPanel);
    }

    public void initGui() {
        aml.getAgentPresenceManager().addAgentPresenceListener(this);
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");
        filterConfig = BusMessageFilter.messageOrigin(DEST).and(BusMessageFilter.messageClass(StatusConfigurationInfo.class));

    }

    public void connecting(AgentInfo agent) {
        DEST = System.getProperty("lsst.ccs.metrology.metrologyguidest", "metrology");

        if (!agent.getName().equals(DEST)) {
            return;
        }
        Future<Object> future = cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
        try {
            ConfigurationInfo configInfo = (ConfigurationInfo) future.get();
            mainPanel.updateWithConfigInfo(configInfo);
            mainPanel.setDescriptionName(configInfo.getDescriptionName());
            aml.addStatusMessageListener(this, filterConfig);
        } catch (Exception ex) {
            LOGGER.warn("unable to retrieve configuration information", ex);
        }
    }

    public void disconnecting(AgentInfo agent) {
        aml.removeStatusMessageListener(this);
    }

}
