package org.lsst.ccs.subsystem.metrology.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 ** Contains the state of the metrology subsystem * * @author Homer Neal *
 * **************************************************************************
 */
public class MetrologyState implements Serializable {

    private static final long serialVersionUID = -7596686997197536530L;

    public static final String KEY = "MetrologyState";

    static int ibit = 19;
    static int LEDDEVC_ON_BIT,ACCUM_DONE_BIT,FE55_ON_BIT,CRYO_DEV_WARNING_BIT,VAC_DEV_WARNING_BIT;
    public final static int STARTUP_BIT = 0,
            READY_BIT = 1,
            ACQ1_BIT = 2,
            WARM_BIT = 3,
            SHUTDOWN_BIT = 4,
            IDLE_BIT = 5,
            STOP_BIT = 6,
            PWRDEVC_TRIPPED_BIT = 7,
            PWRDEVC_ON_BIT = 10,
            LEDDEVC_ON = (1 << (LEDDEVC_ON_BIT = ibit++)),
            ACCUM_DONE = (1 << (ACCUM_DONE_BIT = ibit++)),
            FE55_ON_DEV = (1 << (FE55_ON_BIT = ibit++)),
            CRYO_DEV_WARNING = (1 << (CRYO_DEV_WARNING_BIT = ibit++)),
            VAC_DEV_WARNING = (1 << (VAC_DEV_WARNING_BIT = ibit++)),
            STARTUP = 1 << STARTUP_BIT,
            READY = 1 << READY_BIT,
            ACQ1 = 1 << ACQ1_BIT,
            WARM = 1 << WARM_BIT,
            SHUTDOWN = 1 << SHUTDOWN_BIT,
            IDLE = 1 << IDLE_BIT,
            STOP = 1 << STOP_BIT,
            PWRDEVC_TRIPPED = 1 << PWRDEVC_TRIPPED_BIT,
            PWRDEVC_ON = 1 << PWRDEVC_ON_BIT;
    
    int systemState;           // Mask of state bits
    int operState;             // ordinal operating state (READY,IDLE,ACQ1,...)
    int tickMillis;            // Data status update period (ms)
    double val1;              // Bias val1
    double posx,posy,posz,displacement1,displacement2;
    int nsamples;
    int measmode;
    double acceleration;
    double speed;
    String warning;            // any current warning string

    public enum onOff {

        OFF, ON;
    }

    public enum pwrstates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED,
        ACCUM,
        ACCUMDONE;
    }

    public enum cryostates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED;
    }

    public enum vacstates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED;
    }

    public MetrologyState(int systemState, int operState, int tickMillis) {
        this(systemState, operState, tickMillis, 0., 0., 0., 0., 0., 0, 0, 0., 0.);
    }

    public MetrologyState(int systemState, int operState, int tickMillis, double posx, double posy, double posz, double displacement1, double displacement2,
            int nsamples, int measmode, double acceleration, double speed) {
        this.systemState = systemState;
        this.operState = operState;
        this.tickMillis = tickMillis;
        this.posx = posx;
        this.posy = posy;
        this.posz = posz;
        this.displacement1 = displacement1;
        this.displacement2 = displacement2;
        this.nsamples = nsamples;
        this.measmode = measmode;
        this.acceleration = acceleration;
        this.speed = speed;
    }

    public int getSystemState() {
        return systemState;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public double getVolts() {
        return val1;
    }

    public void setVolts(double val1) {
        this.val1 = val1;
    }

    public double getPosx() {
        return posx;
    }

    public void setPosx(double posx) {
        this.posx = posx;
    }

    public double getPosy() {
        return posy;
    }

    public void setPosy(double posy) {
        this.posy = posy;
    }

    public double getPosz() {
        return posz;
    }

    public void setPosz(double posz) {
        this.posz = posz;
    }

    public double getDisplacement1() {
        return displacement1;
    }

    public void setDisplacement1(double displacement1) {
        this.displacement1 = displacement1;
    }

    public double getDisplacement2() {
        return displacement2;
    }

    public void setDisplacement2(double displacement2) {
        this.displacement2 = displacement2;
    }


    public String getWarning() {
        return warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public int getOperState() {
        return operState;
    }

    public void setOperState(int operState) {
        this.operState = operState;
    }

    public int getNsamples() {
        return nsamples;
    }

    public void setNsamples(int nsamples) {
        this.nsamples = nsamples;
    }

    public int getMeasmode() {
        return measmode;
    }

    public void setMeasmode(int measmode) {
        this.measmode = measmode;
    }

    public double getAcceleration() {
        return acceleration;
    }

    public void setAcceleration(double acceleration) {
        this.acceleration = acceleration;
    }

    public double getSpeed() {
        return speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    
    
    @Override
    public String toString() {
        return "systemState=" + systemState
                + ", tickMillis=" + tickMillis
                + ", displacement1=" + displacement1
                + ", displacement2=" + displacement2;
    }

}
