package org.lsst.ccs.subsystem.metrology.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

import org.lsst.ccs.utilities.logging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 ***************************************************************************
 **
 ** Contains the state of the metrology system * * @author Homer Neal *
 * **************************************************************************
 */
public class MetrologyConfig implements Serializable {

    public enum operating_states {

        IDLE, SCANNING, DOWN;
    }
    
    public enum configuration_states {
        RTM, RTM_Explore, RTM_calib, BASEPLATE, SCAN3, SCAN4,
        CCD00, CCD01, CCD02 ,
        CCD10, CCD11, CCD12 ,
        CCD20, CCD21, CCD22 
    }
    
    public enum Displacement_Summing_Modes {
        NormalDispSum,DisplacementHead1Only,DisplacementHead2Only,DisplacementDiff 
    }
    
    public enum EVENT_ID {
        POSX,
        POSY,
        POSZ,
        KEYENCE,
        PWR;
    }

    public static int MAXSTATES = configuration_states.values().length;
    private int cfgstate = 0;
    private int operatingstate = 0;

    private double[] startx = new double[MAXSTATES];            // x start
    private double[] stopx = new double[MAXSTATES];             // x stop
    private double[] dx = new double[MAXSTATES];                // dx
    private double[] starty = new double[MAXSTATES];            // y start
    private double[] stopy = new double[MAXSTATES];             // y stop
    private double[] dy = new double[MAXSTATES];                // dy
    private double[] cornerang = new double[MAXSTATES];         // trapezium corner angle 1
    private double[] rotation = new double[MAXSTATES];          // trapezium x-y plane rotation
    private int[]    nsamples = new int[MAXSTATES];             // displacement samples
    private int[]    measmode = new int[MAXSTATES];             // measurement mode
    private double[] acceleration = new double[MAXSTATES];      // positioner acceleration
    private double[] speed = new double[MAXSTATES];      // positioner speed
    private String configFile;

    public MetrologyConfig() {
    }

    @Override
    public String toString() {
        String line = "";
        for (configuration_states stat : configuration_states.values()) {
            int icfg = stat.ordinal();
            line
                    += "state=" + stat.name()
                    + ", startx=" + startx[icfg]
                    + ", stopx=" + stopx[icfg]
                    + ", dx=" + dx[icfg]
                    + ", starty=" + starty[icfg]
                    + ", stopy=" + stopy[icfg]
                    + ", dy=" + dy[icfg]
                    + ", nsamples=" + nsamples[icfg]
                    + ", measmode=" + measmode[icfg]
                    + ", acceleration=" + acceleration[icfg]
                    + ", speed=" + speed[icfg];
        }
        return line;
    }

    public void setCfgState(int cfgstate) {
        this.cfgstate = cfgstate;
    }

    public int getCfgstate() {
        return cfgstate;
    }

    public int getOperatingState() {
        return operatingstate;
    }

    public void setOperatingState(int operatingstate) {
        this.operatingstate = operatingstate;
    }
}
