/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology.data;

import java.io.Serializable;

public class MetrologyConfig
implements Serializable {
    public static final String[] COMPONENT_NAMES = new String[]{configuration_states.values()[0].name(), configuration_states.values()[1].name(), configuration_states.values()[2].name(), configuration_states.values()[3].name(), configuration_states.values()[4].name(), configuration_states.values()[5].name(), configuration_states.values()[6].name(), configuration_states.values()[7].name(), configuration_states.values()[8].name(), configuration_states.values()[9].name(), configuration_states.values()[10].name(), configuration_states.values()[11].name(), configuration_states.values()[12].name(), configuration_states.values()[13].name(), configuration_states.values()[14].name()};
    public static int MAXSTATES = configuration_states.values().length;
    private int cfgstate = 0;
    private int operatingstate = 0;
    private double[] startx = new double[MAXSTATES];
    private double[] stopx = new double[MAXSTATES];
    private double[] dx = new double[MAXSTATES];
    private double[] starty = new double[MAXSTATES];
    private double[] stopy = new double[MAXSTATES];
    private double[] dy = new double[MAXSTATES];
    private double[] cornerang = new double[MAXSTATES];
    private double[] rotation = new double[MAXSTATES];
    private int[] nsamples = new int[MAXSTATES];
    private int[] measmode = new int[MAXSTATES];
    private double[] acceleration = new double[MAXSTATES];
    private double[] speed = new double[MAXSTATES];
    private String configFile;

    public MetrologyConfig() {
    }

    public MetrologyConfig(double startx, double stopx, double dx, double starty, double stopy, double dy, double rotation, double cornerang, int nsamples, int measmode, double acceleration, double speed) {
        this.update(startx, stopx, dx, starty, stopy, dy, rotation, cornerang, nsamples, measmode, acceleration, speed);
    }

    public void update(double startx, double stopx, double dx, double starty, double stopy, double dy, double rotation, double cornerang, int nsamples, int measmode, double acceleration, double speed) {
        this.update(this.cfgstate, startx, stopx, dx, starty, stopy, dy, rotation, cornerang, nsamples, measmode, acceleration, speed);
    }

    public void update(int istate, double startx, double stopx, double dx, double starty, double stopy, double dy, double rotation, double cornerang, int nsamples, int measmode, double acceleration, double speed) {
        this.startx[istate] = startx;
        this.stopx[istate] = stopx;
        this.dx[istate] = dx;
        this.starty[istate] = starty;
        this.stopy[istate] = stopy;
        this.dy[istate] = dy;
        this.rotation[istate] = rotation;
        this.cornerang[istate] = cornerang;
        this.nsamples[istate] = nsamples;
        this.measmode[istate] = measmode;
        this.acceleration[istate] = acceleration;
        this.speed[istate] = speed;
    }

    public String toString() {
        String line = "";
        for (configuration_states stat : configuration_states.values()) {
            int icfg = stat.ordinal();
            line = line + "state=" + stat.name() + ", startx=" + this.startx[icfg] + ", stopx=" + this.stopx[icfg] + ", dx=" + this.dx[icfg] + ", starty=" + this.starty[icfg] + ", stopy=" + this.stopy[icfg] + ", dy=" + this.dy[icfg] + ", nsamples=" + this.nsamples[icfg] + ", measmode=" + this.measmode[icfg] + ", acceleration=" + this.acceleration[icfg] + ", speed=" + this.speed[icfg];
        }
        return line;
    }

    public void setCfgState(int cfgstate) {
        this.cfgstate = cfgstate;
    }

    public int getCfgstate() {
        return this.cfgstate;
    }

    public int getOperatingState() {
        return this.operatingstate;
    }

    public void setOperatingState(int operatingstate) {
        this.operatingstate = operatingstate;
    }

    public double[] getStartx() {
        return this.startx;
    }

    public void setStartx(double[] startx) {
        this.startx = startx;
    }

    public double[] getStopx() {
        return this.stopx;
    }

    public void setStopx(double[] stopx) {
        this.stopx = stopx;
    }

    public double[] getStarty() {
        return this.starty;
    }

    public void setStarty(double[] starty) {
        this.starty = starty;
    }

    public double[] getStopy() {
        return this.stopy;
    }

    public void setStopy(double[] stopy) {
        this.stopy = stopy;
    }

    public double[] getDx() {
        return this.dx;
    }

    public void setDx(double[] dx) {
        this.dx = dx;
    }

    public double[] getDy() {
        return this.dy;
    }

    public void setDy(double[] dy) {
        this.dy = dy;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public double[] getCornerang() {
        return this.cornerang;
    }

    public void setCornerang(double[] cornerang) {
        this.cornerang = cornerang;
    }

    public double[] getRotation() {
        return this.rotation;
    }

    public void setRotation(double[] rotation) {
        this.rotation = rotation;
    }

    public int[] getNsamples() {
        return this.nsamples;
    }

    public void setNsamples(int[] nsamples) {
        this.nsamples = nsamples;
    }

    public int[] getMeasmode() {
        return this.measmode;
    }

    public void setMeasmode(int[] measmode) {
        this.measmode = measmode;
    }

    public double[] getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(double[] acceleration) {
        this.acceleration = acceleration;
    }

    public double[] getSpeed() {
        return this.speed;
    }

    public void setSpeed(double[] speed) {
        this.speed = speed;
    }

    public static enum EVENT_ID {
        POSX,
        POSY,
        POSZ,
        KEYENCE,
        PWR;

    }

    public static enum configuration_states {
        RTM,
        RTM_Explore,
        RTM_calib,
        BASEPLATE,
        SCAN3,
        SCAN4,
        CCD00,
        CCD01,
        CCD02,
        CCD10,
        CCD11,
        CCD12,
        CCD20,
        CCD21,
        CCD22;

    }

    public static enum operating_states {
        IDLE,
        SCANNING,
        DOWN;

    }
}

