package org.lsst.ccs.subsystem.metrology.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 ***************************************************************************
 **
 **  Contains information describing the full TS5 state.
 **
 **  <p>
 **  Sent on the status bus upon startup or upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class MetrologyFullState implements Serializable {

    private static final long serialVersionUID = -1207498930489246631L;
    
    final private MetrologyState metrologyState;
    final private MonitorFullState monitorState;

    public MetrologyFullState(MetrologyState rState, MonitorFullState mState) {
        metrologyState = rState;
        monitorState = mState;
    }

    public MetrologyState getMetrologyState() {
        return metrologyState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

}
