package org.lsst.ccs.subsystem.metrology.status;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;

/**
 ***************************************************************************
 **
 **  Contains the state of the metrology system
 **
 **  <p>
 **  Sent on the status bus whenever the state changes
 **
 **  @author Homer Neal
 **
 ***************************************************************************
 */
public class MetrologyStateStatus {

    private static final long serialVersionUID = 1728192739910618487L;
    public static final String KEY = "MetrologyStateStatus";

    final private MetrologyState metrologyState;

    public MetrologyStateStatus(MetrologyState metrologyState)
    {
        super();
        this.metrologyState = metrologyState;
    }
    
    public MetrologyState getMetrologyState()
    {
        return metrologyState;
    }

    @Override
    public String toString()
    {
        return "MetrologyStateStatus : "
                + " (" + metrologyState + ")";
    }

}
