package org.lsst.ccs.subsystem.metrology.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

import org.lsst.ccs.utilities.logging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 ***************************************************************************
 **
 ** Contains the state of the metrology system * * @author Homer Neal *
 * **************************************************************************
 */
public class MetrologyConfig implements Serializable {

    public enum operating_states {

        IDLE, SCANNING, DOWN;
    }
    
    public enum configuration_states {
        RTM, RTM_Explore, BASEPLATE, SCAN3, SCAN4 
    }
    public static final String[] COMPONENT_NAMES = {
        configuration_states.values()[0].name(),
        configuration_states.values()[1].name(),
        configuration_states.values()[2].name(),
        configuration_states.values()[3].name(),
        configuration_states.values()[4].name()
    };

    public enum EVENT_ID {

        POSX,
        POSY,
        POSZ,
        KEYENCE,
        PWR;
    }

    public static int MAXSTATES = configuration_states.values().length;
    private int cfgstate = 0;
    private int operatingstate = 0;

    private double[] startx = new double[MAXSTATES];            // x start
    private double[] stopx = new double[MAXSTATES];             // x stop
    private double[] dx = new double[MAXSTATES];                // dx
    private double[] starty = new double[MAXSTATES];            // y start
    private double[] stopy = new double[MAXSTATES];             // y stop
    private double[] dy = new double[MAXSTATES];                // dy
    private double[] cornerang = new double[MAXSTATES];         // trapezium corner angle 1
    private double[] rotation = new double[MAXSTATES];          // trapezium x-y plane rotation
    private int[]    nsamples = new int[MAXSTATES];             // displacement samples
    private int[]    measmode = new int[MAXSTATES];             // measurement mode
    private double[] acceleration = new double[MAXSTATES];      // positioner acceleration
    private double[] speed = new double[MAXSTATES];      // positioner speed
    private String configFile;

    public MetrologyConfig() {
//        this.configFile = System.getProperty("lsst.ccs.teststand.configFile", "TestStand.cfg");
//        System.out.println("Config file path is: " + configFile);
    }

    public MetrologyConfig(double startx, double stopx, double dx, double starty, double stopy, double dy, double rotation, double cornerang,
                       int nsamples, int measmode, double acceleration, double speed) {
        update(startx, stopx, dx, starty, stopy, dy, rotation, cornerang, nsamples, measmode, acceleration, speed);
    }

    public void update(double startx, double stopx, double dx, double starty, double stopy, double dy, double rotation, double cornerang,
                       int nsamples, int measmode, double acceleration, double speed) {
        update(cfgstate, startx, stopx, dx, starty, stopy, dy, rotation, cornerang, nsamples, measmode, acceleration, speed);
    }

    public void update(int istate, double startx, double stopx, double dx, double starty, double stopy, double dy, double rotation, double cornerang,
                       int nsamples, int measmode, double acceleration, double speed) {
        this.startx[istate] = startx;
        this.stopx[istate] = stopx;
        this.dx[istate] = dx;
        this.starty[istate] = starty;
        this.stopy[istate] = stopy;
        this.dy[istate] = dy;
        this.rotation[istate] = rotation;
        this.cornerang[istate] = cornerang;
        this.nsamples[istate] = nsamples;
        this.measmode[istate] = measmode;
        this.acceleration[istate] = acceleration;
        this.speed[istate] = speed;

    }

    @Override
    public String toString() {
        String line = "";
        for (configuration_states stat : configuration_states.values()) {
            int icfg = stat.ordinal();
            line
                    += "state=" + stat.name()
                    + ", startx=" + startx[icfg]
                    + ", stopx=" + stopx[icfg]
                    + ", dx=" + dx[icfg]
                    + ", starty=" + starty[icfg]
                    + ", stopy=" + stopy[icfg]
                    + ", dy=" + dy[icfg]
                    + ", nsamples=" + nsamples[icfg]
                    + ", measmode=" + measmode[icfg]
                    + ", acceleration=" + acceleration[icfg]
                    + ", speed=" + speed[icfg];
        }
        return line;
    }

    public void setCfgState(int cfgstate) {
        this.cfgstate = cfgstate;
    }

    public int getCfgstate() {
        return cfgstate;
    }

    public int getOperatingState() {
        return operatingstate;
    }

    public void setOperatingState(int operatingstate) {
        this.operatingstate = operatingstate;
    }

    public double[] getStartx() {
        return startx;
    }

    public void setStartx(double[] startx) {
        this.startx = startx;
    }

    public double[] getStopx() {
        return stopx;
    }

    public void setStopx(double[] stopx) {
        this.stopx = stopx;
    }

    public double[] getStarty() {
        return starty;
    }

    public void setStarty(double[] starty) {
        this.starty = starty;
    }

    public double[] getStopy() {
        return stopy;
    }

    public void setStopy(double[] stopy) {
        this.stopy = stopy;
    }

    public double[] getDx() {
        return dx;
    }

    public void setDx(double[] dx) {
        this.dx = dx;
    }

    public double[] getDy() {
        return dy;
    }

    public void setDy(double[] dy) {
        this.dy = dy;
    }

    public String getConfigFile() {
        return configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public double[] getCornerang() {
        return cornerang;
    }

    public void setCornerang(double[] cornerang) {
        this.cornerang = cornerang;
    }

    public double[] getRotation() {
        return rotation;
    }

    public void setRotation(double[] rotation) {
        this.rotation = rotation;
    }

    public int[] getNsamples() {
        return nsamples;
    }

    public void setNsamples(int[] nsamples) {
        this.nsamples = nsamples;
    }

    public int[] getMeasmode() {
        return measmode;
    }

    public void setMeasmode(int[] measmode) {
        this.measmode = measmode;
    }

    public double[] getAcceleration() {
        return acceleration;
    }

    public void setAcceleration(double[] acceleration) {
        this.acceleration = acceleration;
    }

    public double[] getSpeed() {
        return speed;
    }

    public void setSpeed(double[] speed) {
        this.speed = speed;
    }
    
}
