/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;

public abstract class BuiltInSchemaFactory
implements Serializable {
    private static HashMap lookup = new HashMap(100);

    private BuiltInSchemaFactory() {
    }

    private static BuiltInAtomicType makeAtomicType(String string, String string2, SimpleType simpleType) {
        BuiltInAtomicType builtInAtomicType = new BuiltInAtomicType(StandardNames.getFingerprint(string, string2));
        builtInAtomicType.setBaseTypeFingerprint(simpleType.getFingerprint());
        lookup.put(new Integer(builtInAtomicType.getFingerprint()), builtInAtomicType);
        return builtInAtomicType;
    }

    private static BuiltInListType makeListType(String string, String string2) {
        BuiltInListType builtInListType = new BuiltInListType(StandardNames.getFingerprint(string, string2));
        lookup.put(new Integer(builtInListType.getFingerprint()), builtInListType);
        return builtInListType;
    }

    public static SchemaType getSchemaType(int n) {
        return (SchemaType)lookup.get(new Integer(n));
    }

    static {
        AnySimpleType anySimpleType = AnySimpleType.getInstance();
        lookup.put(new Integer(573), anySimpleType);
        BuiltInAtomicType builtInAtomicType = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2005/xpath-datatypes", "anyAtomicType", anySimpleType);
        BuiltInAtomicType builtInAtomicType2 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2005/xpath-datatypes", "_numeric_", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType3 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "string", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType4 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "boolean", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType5 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "duration", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType6 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "dateTime", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType7 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "date", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType8 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "time", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType9 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "gYearMonth", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType10 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "gMonth", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType11 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "gMonthDay", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType12 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "gYear", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType13 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "gDay", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType14 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "hexBinary", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType15 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "base64Binary", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType16 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "anyURI", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType17 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "QName", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType18 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "NOTATION", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType19 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2005/xpath-datatypes", "untypedAtomic", builtInAtomicType);
        BuiltInAtomicType builtInAtomicType20 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "decimal", builtInAtomicType2);
        BuiltInAtomicType builtInAtomicType21 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "float", builtInAtomicType2);
        BuiltInAtomicType builtInAtomicType22 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "double", builtInAtomicType2);
        BuiltInAtomicType builtInAtomicType23 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "integer", builtInAtomicType20);
        BuiltInAtomicType builtInAtomicType24 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger", builtInAtomicType23);
        BuiltInAtomicType builtInAtomicType25 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "negativeInteger", builtInAtomicType24);
        BuiltInAtomicType builtInAtomicType26 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "long", builtInAtomicType23);
        BuiltInAtomicType builtInAtomicType27 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "int", builtInAtomicType26);
        BuiltInAtomicType builtInAtomicType28 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "short", builtInAtomicType27);
        BuiltInAtomicType builtInAtomicType29 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "byte", builtInAtomicType28);
        BuiltInAtomicType builtInAtomicType30 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger", builtInAtomicType23);
        BuiltInAtomicType builtInAtomicType31 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "positiveInteger", builtInAtomicType30);
        BuiltInAtomicType builtInAtomicType32 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "unsignedLong", builtInAtomicType30);
        BuiltInAtomicType builtInAtomicType33 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "unsignedInt", builtInAtomicType32);
        BuiltInAtomicType builtInAtomicType34 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "unsignedShort", builtInAtomicType33);
        BuiltInAtomicType builtInAtomicType35 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "unsignedByte", builtInAtomicType34);
        BuiltInAtomicType builtInAtomicType36 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2005/xpath-datatypes", "yearMonthDuration", builtInAtomicType5);
        BuiltInAtomicType builtInAtomicType37 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2005/xpath-datatypes", "dayTimeDuration", builtInAtomicType5);
        BuiltInAtomicType builtInAtomicType38 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "normalizedString", builtInAtomicType3);
        BuiltInAtomicType builtInAtomicType39 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "token", builtInAtomicType38);
        BuiltInAtomicType builtInAtomicType40 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "language", builtInAtomicType39);
        BuiltInAtomicType builtInAtomicType41 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "Name", builtInAtomicType39);
        BuiltInAtomicType builtInAtomicType42 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "NMTOKEN", builtInAtomicType39);
        BuiltInAtomicType builtInAtomicType43 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "NCName", builtInAtomicType41);
        BuiltInAtomicType builtInAtomicType44 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "ID", builtInAtomicType43);
        BuiltInAtomicType builtInAtomicType45 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "IDREF", builtInAtomicType43);
        BuiltInAtomicType builtInAtomicType46 = BuiltInSchemaFactory.makeAtomicType("http://www.w3.org/2001/XMLSchema", "ENTITY", builtInAtomicType43);
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "NMTOKENS");
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "IDREFS");
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "ENTITIES");
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema-instance", "anonymous_schemaLocationType");
        lookup.put(new Integer(572), AnyType.getInstance());
        lookup.put(new Integer(641), Untyped.getInstance());
    }
}

