/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;

public class TempRtds {
    public static final int REG_RTD_COMMAND = 0x700000;
    public static final int REG_RTD_REPLY = 0x700001;
    public static final int REG_RTD_RESET = 0x700002;
    public static final int CMND_READ = 524288;
    public static final int NUM_RTD_TEMPS = 4;
    public static final int STATUS_REG = 0;
    public static final int MODE_REG = 1;
    public static final int CONFIG_REG = 2;
    public static final int DATA_REG = 3;
    public static final int ID_REG = 4;
    public static final int IO_REG = 5;
    public static final int OFFSET_REG = 6;
    public static final int SCALE_REG = 7;
    public static final int STS_READY = 128;
    public static final int STS_ERROR = 64;
    public static final int STS_NOXREF = 32;
    public static final int STS_AD7794 = 8;
    public static final int STS_CHANNEL_M = 7;
    public static final int STS_CHANNEL_V = 0;
    public static final int MOD_MODE_M = 57344;
    public static final int MOD_MODE_V = 13;
    public static final int MODE_CONT = 0;
    public static final int MODE_SINGLE = 1;
    public static final int MODE_IDLE = 2;
    public static final int MODE_PWR_DOWN = 3;
    public static final int MODE_INT_Z_CAL = 4;
    public static final int MODE_INT_F_CAL = 5;
    public static final int MODE_SYS_Z_CAL = 6;
    public static final int MODE_SYS_F_CAL = 7;
    public static final int MOD_PSW = 4096;
    public static final int MOD_AMP_CM = 512;
    public static final int MOD_CLOCK_M = 192;
    public static final int MOD_CLOCK_V = 6;
    public static final int CLOCK_INT = 0;
    public static final int CLOCK_INT_AVL = 1;
    public static final int CLOCK_EXT = 2;
    public static final int CLOCK_EXT_HALF = 3;
    public static final int MOD_CHOP_DIS = 16;
    public static final int MOD_FRS_M = 15;
    public static final int MOD_FRS_V = 0;
    public static final int FRS_RATE_470 = 1;
    public static final int FRS_RATE_242 = 2;
    public static final int FRS_RATE_123 = 3;
    public static final int FRS_RATE_62 = 4;
    public static final int FRS_RATE_50 = 5;
    public static final int FRS_RATE_39 = 6;
    public static final int FRS_RATE_33 = 7;
    public static final int FRS_RATE_19 = 8;
    public static final int FRS_RATE_17 = 9;
    public static final int FRS_RATE_16 = 10;
    public static final int FRS_RATE_12 = 11;
    public static final int FRS_RATE_10 = 12;
    public static final int FRS_RATE_8 = 13;
    public static final int FRS_RATE_6 = 14;
    public static final int FRS_RATE_4 = 15;
    public static final int CFG_VBIAS_M = 49152;
    public static final int CFG_VBIAS_V = 14;
    public static final int VBIAS_OFF = 0;
    public static final int VBIAS_AIN1 = 1;
    public static final int VBIAS_AIN2 = 2;
    public static final int VBIAS_AIN3 = 3;
    public static final int CFG_BURNOUT = 8192;
    public static final int CFG_UNIPOLAR = 4096;
    public static final int CFG_BOOST = 2048;
    public static final int CFG_GAIN_M = 1792;
    public static final int CFG_GAIN_V = 8;
    public static final int GAIN_1 = 0;
    public static final int GAIN_2 = 1;
    public static final int GAIN_4 = 2;
    public static final int GAIN_8 = 3;
    public static final int GAIN_16 = 4;
    public static final int GAIN_32 = 5;
    public static final int GAIN_64 = 6;
    public static final int GAIN_128 = 7;
    public static final int RANGE_2500 = 0;
    public static final int RANGE_1250 = 1;
    public static final int RANGE_625 = 2;
    public static final int RANGE_312 = 3;
    public static final int RANGE_156 = 4;
    public static final int RANGE_78 = 5;
    public static final int RANGE_39 = 6;
    public static final int RANGE_19 = 7;
    public static final int CFG_REFSEL_M = 192;
    public static final int CFG_REFSEL_V = 6;
    public static final int REFSEL_EXT1 = 0;
    public static final int REFSEL_EXT2 = 1;
    public static final int REFSEL_INT = 2;
    public static final int CFG_REF_DETECT = 32;
    public static final int CFG_BUFFERED = 16;
    public static final int CFG_CHANNEL_M = 15;
    public static final int CFG_CHANNEL_V = 0;
    public static final int CHAN_AIN1 = 0;
    public static final int CHAN_AIN2 = 1;
    public static final int CHAN_AIN3 = 2;
    public static final int CHAN_AIN4 = 3;
    public static final int CHAN_AIN5 = 4;
    public static final int CHAN_AIN6 = 5;
    public static final int CHAN_TEMP = 6;
    public static final int CHAN_VDD = 7;
    public static final int CHAN_AIN1A = 8;
    public static final int IO_DIOENA = 64;
    public static final int IO_IO2DAT = 32;
    public static final int IO_IO1DAT = 16;
    public static final int IO_IEXCDIR_M = 12;
    public static final int IO_IEXCDIR_V = 2;
    public static final int IEXCDIR_12 = 0;
    public static final int IEXCDIR_21 = 1;
    public static final int IEXCDIR_11 = 2;
    public static final int IEXCDIR_22 = 3;
    public static final int IO_IEXCENA_M = 3;
    public static final int IO_IEXCENA_V = 0;
    public static final int IEXCENA_OFF = 0;
    public static final int IEXCENA_10 = 1;
    public static final int IEXCENA_210 = 2;
    public static final int IEXCENA_1000 = 3;
    private static final int[] REG_SIZE = new int[]{1, 2, 2, 3, 1, 1, 3, 3};
    private static final int MODE_BASE = 8193;
    private static final int CONFIG_BASE = 16;
    private static final int IO_BASE = 2;
    private static final int READY_WAIT = 1;
    private static final int READY_TIMEOUT = 5000;
    private static final double HALF_RANGE = 8388608.0;
    private static final double INT_REF_VOLTAGE = 1.17;
    private static final double INT_TEMP_SCALE = 100.0;
    private static final double INT_VOLT_SCALE = 6.0;
    private static final double REF_RESIST = 3000.0;
    private static final double RTD_RESIST_1000 = 1000.0;
    private static final double RTD_RESIST_100 = 100.0;
    private static final double TEMP_CONV = 0.00385;
    private final BaseSet bss;

    public TempRtds(BaseSet bss) {
        this.bss = bss;
    }

    public void initialize() throws REBException {
        this.writeRegister(1, 8193);
        this.writeRegister(2, 16);
        this.writeRegister(5, 2);
    }

    public synchronized double readTemperature(int chan) throws REBException {
        if (chan < 0 || chan >= 4) {
            throw new REBException("Invalid RTD channel");
        }
        chan = chan == 3 ? 5 : this.bss.convertStripNum(chan);
        int ref = 0;
        if (chan == 5 && this.bss.isVersion(10, 1)) {
            ref = 1;
        }
        this.writeRegister(5, 2);
        this.writeRegister(2, 0x10 | chan << 0 | ref << 6);
        this.writeRegister(1, 8193);
        if (this.waitReady()) {
            double resist = 3000.0 * Math.abs((double)this.readRegister(3) / 8388608.0 - 1.0);
            double nomResist = resist < 200.0 ? 100.0 : 1000.0;
            return (resist / nomResist - 1.0) / 0.00385;
        }
        return BaseSet.ERROR_VALUE;
    }

    public synchronized double readIntTemperature() throws REBException {
        this.writeRegister(2, 22);
        this.writeRegister(1, 8193);
        if (this.waitReady()) {
            return ((double)this.readRegister(3) / 8388608.0 - 1.0) * 1.17 * 100.0;
        }
        return BaseSet.ERROR_VALUE;
    }

    public synchronized double readIntVoltage() throws REBException {
        this.writeRegister(2, 23);
        this.writeRegister(1, 8193);
        if (this.waitReady()) {
            return ((double)this.readRegister(3) / 8388608.0 - 1.0) * 1.17 * 6.0;
        }
        return BaseSet.ERROR_VALUE;
    }

    public void reset() throws REBException {
        this.bss.write(0x700002, 0);
        try {
            Thread.sleep(0L, 500000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int readRegister(int regnum) throws REBException {
        int reg = regnum & 7;
        this.bss.write(0x700000, 0x80000 | reg << 16);
        return this.bss.read(0x700001) & (1 << 8 * REG_SIZE[reg]) - 1;
    }

    public void writeRegister(int regnum, int value) throws REBException {
        int reg = regnum & 7;
        int val = REG_SIZE[reg] == 1 ? (value & 0xFF) << 8 : value & 0xFFFF;
        this.bss.write(0x700000, reg << 16 | val);
    }

    public boolean waitReady() throws REBException {
        long start = System.currentTimeMillis();
        boolean ready = false;
        int status = this.readRegister(0);
        while (!(ready = (status & 0x80) == 0) && System.currentTimeMillis() - start <= 5000L) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            status = this.readRegister(0);
        }
        if (!ready) {
            throw new REBException("Conversion timed out");
        }
        return (status & 0x40) == 0;
    }
}

