/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.patterns;

import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGenerator;

public class NoisePatternGenerator
extends PatternGenerator {
    NoisePatternGenerator() {
        super("noise");
    }

    @Override
    public GeneratedImage generateImage(int width, int height, Map<String, String> parameters) {
        int noiseWidthSize = this.getIntParameter("noise_xSize", parameters, 15);
        int noiseHightSize = this.getIntParameter("noise_ySize", parameters, 15);
        int nx = width / noiseWidthSize + 1;
        int ny = height / noiseHightSize + 1;
        int totalNoiseWidth = nx * noiseWidthSize;
        int totalNoiseHeight = ny * noiseHightSize;
        int noise_baseline = this.getIntParameter("noise_baseline", parameters, 0);
        int noise_maxAmplitude = this.getIntParameter("noise_maxAmplitude", parameters, 256);
        int maxFluctuation = Math.max(noise_maxAmplitude - noise_baseline, 0);
        WritableRaster raster = NoisePatternGenerator.createRaster(totalNoiseWidth, totalNoiseHeight);
        for (int h = 0; h < ny; ++h) {
            for (int w = 0; w < nx; ++w) {
                int[] fill = new int[noiseWidthSize * noiseHightSize];
                Arrays.fill(fill, (int)((double)noise_baseline + Math.random() * (double)maxFluctuation));
                raster.setSamples(w * noiseWidthSize, h * noiseHightSize, noiseWidthSize, noiseHightSize, 0, fill);
            }
        }
        int[][] data = new int[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                data[i][j] = raster.getSample(i, j, 0);
            }
        }
        return new GeneratedImage(data, noise_maxAmplitude);
    }
}

