/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.groovy.GroovyReferencePlaceHolder;
import org.lsst.ccs.utilities.logging.Logger;

public class GroovyComponentNodeFactory
implements ComponentNodeBuilder.ComponentNodeFactory {
    @Override
    public ComponentLookup buildComponentNode(String descriptionStr) {
        InputStream is;
        if (descriptionStr.contains("/")) {
            throw new IllegalArgumentException("description files must be located at the root of a resource directory");
        }
        if (descriptionStr.endsWith(".groovy")) {
            Logger.getLogger((String)"org.lsst.ccs.description.groovy").warn((Object)"Description file extension has to be skipped in the --description argument");
        }
        if (!descriptionStr.endsWith(".groovy")) {
            descriptionStr = descriptionStr + ".groovy";
        }
        if ((is = BootstrapResourceUtils.getBootstrapResource((String)descriptionStr, GroovyComponentNodeFactory.class)) == null) {
            throw new IllegalArgumentException("Could not find resource for " + descriptionStr);
        }
        try {
            Binding binding = new Binding();
            binding.setProperty("ref", new Object(){

                public Object call(String in) {
                    return new GroovyReferencePlaceHolder(in);
                }
            });
            GroovyShell shell = new GroovyShell(binding);
            InputStreamReader reader = new InputStreamReader(is, "ISO-8859-1");
            Object res = shell.evaluate(reader);
            if (!(res instanceof ComponentNode)) {
                throw new IllegalArgumentException("The described object is not a ComponentNode: " + res.getClass());
            }
            ComponentNode node = (ComponentNode)res;
            node.setProtocol(this.getProtocol());
            return new ComponentLookup(node);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getProtocol() {
        return "groovy";
    }
}

